/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.idea.ActionsBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.SystemProperties;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevealFileAction
extends DumbAwareAction
implements LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(RevealFileAction.class);
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            URL url;
            if (notification == null) {
                1.$$$reportNull$$$0(0);
            }
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((url = e.getURL()) != null) {
                try {
                    RevealFileAction.openFile(new File(url.toURI()));
                }
                catch (URISyntaxException ex) {
                    LOG.warn("invalid URL: " + url, (Throwable)ex);
                }
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/RevealFileAction$1";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public RevealFileAction() {
        this.getTemplatePresentation().setText(RevealFileAction.getActionName());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevealFileAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(RevealFileAction.isSupported() && RevealFileAction.getFile(e) != null);
        e.getPresentation().setText(RevealFileAction.getActionName());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            RevealFileAction.$$$reportNull$$$0(1);
        }
        if ((file2 = RevealFileAction.getFile(e)) != null) {
            RevealFileAction.openFile(new File(file2.getPresentableUrl()));
        }
    }

    @Nullable
    private static VirtualFile getFile(@NotNull AnActionEvent e) {
        if (e == null) {
            RevealFileAction.$$$reportNull$$$0(2);
        }
        return RevealFileAction.findLocalFile((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.isMac || SystemInfo.hasXdgOpen() || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    public static @NlsActions.ActionText @NotNull String getActionName() {
        String string = SystemInfo.isMac ? ActionsBundle.message((String)"action.RevealIn.name.mac", (Object[])new Object[0]) : ActionsBundle.message((String)"action.RevealIn.name.other", (Object[])new Object[]{RevealFileAction.getFileManagerName()});
        if (string == null) {
            RevealFileAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getFileManagerName() {
        String string = Holder.fileManagerName;
        if (string == null) {
            RevealFileAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        if (file2 == null || file2.isInLocalFileSystem()) {
            return file2;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof ArchiveFileSystem && file2.getParent() == null) {
            return ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return null;
    }

    public static void showDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, @NotNull File file2, @Nullable DialogWrapper.DoNotAskOption option2) {
        String cancel;
        String ok;
        if (file2 == null) {
            RevealFileAction.$$$reportNull$$$0(5);
        }
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)title, (String)(ok = RevealFileAction.getActionName()), (String)(cancel = IdeBundle.message((String)"action.close", (Object[])new Object[0])), (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)option2) == 0) {
            RevealFileAction.openFile(file2);
        }
    }

    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            RevealFileAction.$$$reportNull$$$0(6);
        }
        if (!file2.exists()) {
            LOG.info("does not exist: " + file2);
            return;
        }
        File parent = file2.getAbsoluteFile().getParentFile();
        if (parent != null) {
            RevealFileAction.doOpen(parent, file2);
        } else {
            RevealFileAction.doOpen(file2, null);
        }
    }

    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            RevealFileAction.$$$reportNull$$$0(7);
        }
        if (!directory.isDirectory()) {
            LOG.info("not a directory: " + directory);
            return;
        }
        RevealFileAction.doOpen(directory.getAbsoluteFile(), null);
    }

    private static void doOpen(@NotNull File _dir, @Nullable File _toSelect) {
        String toSelect2;
        if (_dir == null) {
            RevealFileAction.$$$reportNull$$$0(8);
        }
        String dir = FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_dir.getPath()));
        String string = toSelect2 = _toSelect != null ? FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)_toSelect.getPath())) : null;
        if (SystemInfo.isWindows) {
            RevealFileAction.spawn(toSelect2 != null ? "explorer /select,\"" + RevealFileAction.shortPath(toSelect2) + '\"' : "explorer /root,\"" + RevealFileAction.shortPath(dir) + '\"');
        } else if (SystemInfo.isMac) {
            if (toSelect2 != null) {
                RevealFileAction.spawn("open", "-R", toSelect2);
            } else {
                RevealFileAction.spawn("open", dir);
            }
        } else {
            String fmApp = Holder.fileManagerApp;
            if (fmApp != null) {
                if (fmApp.endsWith("dolphin") && toSelect2 != null) {
                    RevealFileAction.spawn(fmApp, "--select", toSelect2);
                } else {
                    RevealFileAction.spawn(fmApp, toSelect2 != null ? toSelect2 : dir);
                }
            } else if (SystemInfo.hasXdgOpen()) {
                RevealFileAction.spawn("xdg-open", dir);
            } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                LOG.debug("opening " + dir + " via Desktop API");
                ProcessIOExecutorService.INSTANCE.execute(() -> {
                    try {
                        Desktop.getDesktop().open(new File(dir));
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                });
            } else {
                Messages.showErrorDialog((String)IdeBundle.message((String)"message.this.action.isn.t.supported.on.the.current.platform", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.cannot.open.file", (Object[])new Object[0]));
            }
        }
    }

    private static String shortPath(String path) {
        char[] result2;
        if (path.contains("  ") && JnaLoader.isLoaded() && Kernel32.INSTANCE.GetShortPathName(path, result2 = new char[260], result2.length) <= result2.length) {
            return Native.toString((char[])result2);
        }
        return path;
    }

    private static void spawn(String ... command) {
        LOG.debug(Arrays.toString(command));
        ProcessIOExecutorService.INSTANCE.execute(() -> {
            try {
                CapturingProcessHandler.Silent handler2;
                if (SystemInfo.isWindows) {
                    assert (command.length == 1);
                    Process process2 = Runtime.getRuntime().exec(command[0]);
                    handler2 = new CapturingProcessHandler.Silent(process2, null, command[0]);
                } else {
                    handler2 = new CapturingProcessHandler.Silent(new GeneralCommandLine(command));
                }
                handler2.runProcess(10000, false).checkSuccess(LOG);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/RevealFileAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/RevealFileAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManagerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doOpen";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final String fileManagerApp = Holder.readDesktopEntryKey("Exec").map(line -> line.split(" ")[0]).filter(exec -> exec.endsWith("nautilus") || exec.endsWith("pantheon-files") || exec.endsWith("dolphin")).orElse(null);
        private static final String fileManagerName = SystemInfo.isMac ? "Finder" : (SystemInfo.isWindows ? "Explorer" : Holder.readDesktopEntryKey("Name").orElse("File Manager"));

        private Holder() {
        }

        private static Optional<String> readDesktopEntryKey(@NonNls String key) {
            String appName;
            if (SystemInfo.hasXdgMime() && (appName = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-mime", "query", "default", "inode/directory"}))) != null && appName.endsWith(".desktop")) {
                return Stream.of(Holder.getXdgDataDirectories().split(":")).map(dir -> new File((String)dir, "applications/" + appName)).filter(File::exists).findFirst().map(file2 -> Holder.readDesktopEntryKey(file2, key));
            }
            return Optional.empty();
        }

        private static String getXdgDataDirectories() {
            return StringUtil.defaultIfEmpty((String)System.getenv("XDG_DATA_HOME"), (String)(SystemProperties.getUserHome() + "/.local/share")) + ':' + StringUtil.defaultIfEmpty((String)System.getenv("XDG_DATA_DIRS"), (String)"/usr/local/share:/usr/share");
        }

        private static String readDesktopEntryKey(File file2, String key) {
            String string;
            LOG.debug("looking for '" + key + "' in " + file2);
            String prefix = key + '=';
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));
            try {
                string = reader.lines().filter(l -> l.startsWith(prefix)).map(l -> l.substring(prefix.length())).findFirst().orElse(null);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    LOG.info("Cannot read: " + file2, (Throwable)e);
                    return null;
                }
            }
            reader.close();
            return string;
        }
    }
}

