/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class FileTree {
    private static final Logger LOG = Logger.getInstance(FileTree.class);
    private final Map<VirtualFile, List<VirtualFile>> myDirectory2Children = new ConcurrentHashMap<VirtualFile, List<VirtualFile>>();
    private final Set<VirtualFile> myFiles = ContainerUtil.newConcurrentSet();
    private final Map<VirtualFile, List<VirtualFile>> myStrictDirectory2Children = new ConcurrentHashMap<VirtualFile, List<VirtualFile>>();

    FileTree() {
    }

    void add(VirtualFile file2) {
        if (this.myFiles.contains(file2)) {
            return;
        }
        VirtualFile dir = file2.getParent();
        if (dir == null) {
            LOG.error((Object)file2);
            return;
        }
        this.myFiles.add(file2);
        Object children2 = this.myStrictDirectory2Children.get(dir);
        if (children2 != null) {
            LOG.assertTrue(!children2.contains(file2));
            children2.add(file2);
        } else {
            children2 = ContainerUtil.createConcurrentList();
            children2.add(file2);
            this.myStrictDirectory2Children.put(dir, (List<VirtualFile>)children2);
        }
        children2 = this.myDirectory2Children.get(dir);
        if (children2 != null) {
            LOG.assertTrue(!children2.contains(file2));
            children2.add(file2);
            return;
        }
        children2 = ContainerUtil.createConcurrentList();
        children2.add(file2);
        this.myDirectory2Children.put(dir, (List<VirtualFile>)children2);
        for (VirtualFile parent = dir.getParent(); parent != null; parent = parent.getParent()) {
            children2 = this.myDirectory2Children.get(parent);
            if (children2 != null) {
                if (!children2.contains(dir)) {
                    children2.add(dir);
                }
                return;
            }
            children2 = ContainerUtil.createConcurrentList();
            children2.add(dir);
            this.myDirectory2Children.put(parent, (List<VirtualFile>)children2);
            dir = parent;
        }
    }

    boolean isDirectoryEmpty(VirtualFile dir) {
        List<VirtualFile> files2 = this.myStrictDirectory2Children.get(dir);
        return files2 == null || files2.isEmpty();
    }

    List<VirtualFile> getFilesUnderDirectory(VirtualFile dir) {
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        List<VirtualFile> files2 = this.myStrictDirectory2Children.get(dir);
        if (files2 != null) {
            filesList.addAll(files2);
        }
        return filesList;
    }

    void removeFile(VirtualFile file2) {
        List<VirtualFile> children2;
        if (!this.myFiles.contains(file2)) {
            return;
        }
        this.myFiles.remove(file2);
        List<VirtualFile> dirsToBeRemoved = null;
        for (VirtualFile _directory : this.myDirectory2Children.keySet()) {
            children2 = this.myDirectory2Children.get(_directory);
            LOG.assertTrue(children2 != null);
            dirsToBeRemoved = FileTree.collectDirsToRemove(file2, children2, dirsToBeRemoved, _directory);
        }
        for (VirtualFile dir : this.myStrictDirectory2Children.keySet()) {
            children2 = this.myStrictDirectory2Children.get(dir);
            LOG.assertTrue(children2 != null);
            children2.remove(file2);
        }
        if (dirsToBeRemoved != null) {
            LOG.assertTrue(dirsToBeRemoved.size() > 0);
            for (VirtualFile dirToBeRemoved : dirsToBeRemoved) {
                this.removeDir(dirToBeRemoved);
            }
        }
    }

    private void removeDir(VirtualFile psiDirectory) {
        if (!this.myDirectory2Children.containsKey(psiDirectory)) {
            throw new IllegalArgumentException("directory is not in the tree: " + psiDirectory);
        }
        List<VirtualFile> children2 = this.myDirectory2Children.remove(psiDirectory);
        if (children2 == null) {
            throw new IllegalArgumentException("directory has no children list: " + psiDirectory);
        }
        if (children2.size() > 0) {
            throw new IllegalArgumentException("directory isn't empty: " + psiDirectory);
        }
        this.myStrictDirectory2Children.remove(psiDirectory);
        List<VirtualFile> dirsToBeRemoved = null;
        for (VirtualFile _directory : this.myDirectory2Children.keySet()) {
            children2 = this.myDirectory2Children.get(_directory);
            LOG.assertTrue(children2 != null);
            dirsToBeRemoved = FileTree.collectDirsToRemove(psiDirectory, children2, dirsToBeRemoved, _directory);
        }
        if (dirsToBeRemoved != null) {
            for (VirtualFile dirToBeRemoved : dirsToBeRemoved) {
                this.removeDir(dirToBeRemoved);
            }
        }
    }

    private static List<VirtualFile> collectDirsToRemove(VirtualFile psiDirectory, List<VirtualFile> children2, List<VirtualFile> dirsToBeRemoved, VirtualFile _directory) {
        if (children2.contains(psiDirectory)) {
            children2.remove(psiDirectory);
            if (children2.size() == 0) {
                if (dirsToBeRemoved == null) {
                    dirsToBeRemoved = new ArrayList<VirtualFile>(2);
                }
                dirsToBeRemoved.add(_directory);
            }
        }
        return dirsToBeRemoved;
    }

    boolean contains(VirtualFile file2) {
        return this.myFiles.contains(file2);
    }

    void clear() {
        this.myStrictDirectory2Children.clear();
        this.myDirectory2Children.clear();
        this.myFiles.clear();
    }

    Iterator<VirtualFile> getFileIterator() {
        return this.myFiles.iterator();
    }

    List<VirtualFile> getFiles(VirtualFile dir) {
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>();
        this.collectFiles(dir, filesList);
        return filesList;
    }

    private void collectFiles(VirtualFile dir, List<? super VirtualFile> filesList) {
        List<VirtualFile> children2 = this.myDirectory2Children.get(dir);
        if (children2 != null) {
            for (VirtualFile child2 : children2) {
                ProgressManager.checkCanceled();
                if (!child2.isDirectory()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.assertTrue(!filesList.contains(child2));
                    }
                    filesList.add((VirtualFile)child2);
                    continue;
                }
                this.collectFiles(child2, filesList);
            }
        }
    }
}

