/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryTableBase;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ModuleLibraryTable
extends ModuleLibraryTableBase {
    @NotNull
    protected final RootModelImpl myRootModel;
    @NotNull
    private final ProjectRootManagerImpl myProjectRootManager;

    ModuleLibraryTable(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            ModuleLibraryTable.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            ModuleLibraryTable.$$$reportNull$$$0(1);
        }
        this.myRootModel = rootModel;
        this.myProjectRootManager = projectRootManager;
    }

    @NotNull
    public Library createLibrary(String name, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
        ModuleLibraryOrderEntryImpl orderEntry = new ModuleLibraryOrderEntryImpl(name, kind, this.myRootModel, this.myProjectRootManager, externalSource);
        this.myRootModel.addOrderEntry(orderEntry);
        Library library = orderEntry.getLibrary();
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(2);
        }
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            ModuleLibraryTable.$$$reportNull$$$0(3);
        }
        Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
        while (orderIterator.hasNext()) {
            LibraryOrderEntry libraryOrderEntry;
            OrderEntry orderEntry = orderIterator.next();
            if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || !library.equals(libraryOrderEntry.getLibrary())) continue;
            this.myRootModel.removeOrderEntry(orderEntry);
            return;
        }
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.myRootModel.getOrderIterator(), entry -> entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && ((LibraryOrderEntry)entry).getLibrary() != null);
        Iterator iterator2 = ContainerUtil.mapIterator((Iterator)filteringIterator, LibraryOrderEntry::getLibrary);
        if (iterator2 == null) {
            ModuleLibraryTable.$$$reportNull$$$0(4);
        }
        return iterator2;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myRootModel.getModule();
        if (module == null) {
            ModuleLibraryTable.$$$reportNull$$$0(5);
        }
        return module;
    }

    public boolean isChanged() {
        return this.myRootModel.isChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleLibraryTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleLibraryTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

