/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowWrapperBuilder {
    @NotNull
    private final WindowWrapper.Mode myMode;
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private Project myProject;
    @Nullable
    private Component myParent;
    @Nullable
    private String title;
    @Nullable
    private Computable<JComponent> myPreferredFocusedComponent;
    @Nullable
    private String myDimensionServiceKey;
    @Nullable
    private Runnable myOnShowCallback;
    @Nullable
    private BooleanGetter myOnCloseHandler;

    public WindowWrapperBuilder(@NotNull WindowWrapper.Mode mode, @NotNull JComponent component2) {
        if (mode == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(1);
        }
        this.myMode = mode;
        this.myComponent = component2;
    }

    @NotNull
    public WindowWrapperBuilder setProject(@Nullable Project project) {
        this.myProject = project;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(2);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setParent(@Nullable Component parent) {
        this.myParent = parent;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(3);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setTitle(@Nullable String title) {
        this.title = title;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(4);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = new Computable.PredefinedValueComputable((Object)preferredFocusedComponent);
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(5);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable Computable<JComponent> computable) {
        this.myPreferredFocusedComponent = computable;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(6);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setDimensionServiceKey(@Nullable @NonNls String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(7);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setOnShowCallback(@NotNull Runnable callback2) {
        if (callback2 == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(8);
        }
        this.myOnShowCallback = callback2;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(9);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapperBuilder setOnCloseHandler(@NotNull BooleanGetter handler2) {
        if (handler2 == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(10);
        }
        this.myOnCloseHandler = handler2;
        WindowWrapperBuilder windowWrapperBuilder = this;
        if (windowWrapperBuilder == null) {
            WindowWrapperBuilder.$$$reportNull$$$0(11);
        }
        return windowWrapperBuilder;
    }

    @NotNull
    public WindowWrapper build() {
        switch (this.myMode) {
            case FRAME: {
                return new FrameWindowWrapper(this);
            }
            case MODAL: 
            case NON_MODAL: {
                return new DialogWindowWrapper(this);
            }
        }
        throw new IllegalArgumentException(this.myMode.toString());
    }

    private static void installOnShowCallback(@Nullable Window window, @Nullable Runnable onShowCallback) {
        if (window == null || onShowCallback == null) {
            return;
        }
        UIUtil.runWhenWindowOpened((Window)window, (Runnable)onShowCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/WindowWrapperBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/WindowWrapperBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreferredFocusedComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setDimensionServiceKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setOnShowCallback";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setOnCloseHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOnShowCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setOnCloseHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FrameWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @Nullable
        private final Runnable myOnShowCallback;
        @NotNull
        private final MyFrameWrapper myFrame;

        FrameWindowWrapper(@NotNull WindowWrapperBuilder builder2) {
            if (builder2 == null) {
                FrameWindowWrapper.$$$reportNull$$$0(0);
            }
            assert (builder2.myMode == WindowWrapper.Mode.FRAME);
            this.myProject = builder2.myProject;
            this.myComponent = builder2.myComponent;
            this.myMode = builder2.myMode;
            this.myFrame = new MyFrameWrapper(builder2.myProject, builder2.myDimensionServiceKey);
            this.myFrame.setParameters((Computable<? extends JComponent>)builder2.myPreferredFocusedComponent);
            this.myFrame.setOnCloseHandler(builder2.myOnCloseHandler);
            this.myOnShowCallback = builder2.myOnShowCallback;
            this.myFrame.setComponent(builder2.myComponent);
            this.myFrame.setTitle(builder2.title == null ? "" : builder2.title);
            this.myFrame.closeOnEsc();
            Disposer.register((Disposable)this.myFrame, (Disposable)this);
        }

        public void show() {
            Disposable tb = TouchBarsManager.showDialogWrapperButtons(this.myComponent);
            if (tb != null) {
                Disposer.register((Disposable)this.myFrame, (Disposable)tb);
            }
            this.myFrame.show();
            if (this.myOnShowCallback != null) {
                this.myOnShowCallback.run();
            }
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                FrameWindowWrapper.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            WindowWrapper.Mode mode = this.myMode;
            if (mode == null) {
                FrameWindowWrapper.$$$reportNull$$$0(2);
            }
            return mode;
        }

        @NotNull
        public Window getWindow() {
            Window window = this.myFrame.getFrame();
            if (window == null) {
                FrameWindowWrapper.$$$reportNull$$$0(3);
            }
            return window;
        }

        public void setTitle(@Nullable String title) {
            title = StringUtil.notNullize((String)title);
            this.myFrame.setTitle(title);
            Window window = this.getWindow();
            if (window instanceof JFrame) {
                ((JFrame)window).setTitle(title);
            } else if (window instanceof JDialog) {
                ((JDialog)window).setTitle(title);
            }
        }

        public void setImages(@Nullable List<? extends Image> images) {
            this.myFrame.setImages(images);
        }

        public void close() {
            this.myFrame.close();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFrame);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/WindowWrapperBuilder$FrameWindowWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyFrameWrapper
        extends FrameWrapper {
            private Computable<? extends JComponent> myPreferredFocusedComponent;

            MyFrameWrapper(Project project, @Nullable @NonNls String dimensionServiceKey) {
                super(project, dimensionServiceKey);
            }

            public void setParameters(@Nullable Computable<? extends JComponent> preferredFocusedComponent) {
                this.myPreferredFocusedComponent = preferredFocusedComponent;
            }

            @Override
            public void dispose() {
                this.myPreferredFocusedComponent = null;
                super.dispose();
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }
        }
    }

    private static class DialogWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @NotNull
        private final MyDialogWrapper myDialog;

        DialogWindowWrapper(@NotNull WindowWrapperBuilder builder2) {
            if (builder2 == null) {
                DialogWindowWrapper.$$$reportNull$$$0(0);
            }
            this.myProject = builder2.myProject;
            this.myComponent = builder2.myComponent;
            this.myMode = builder2.myMode;
            this.myDialog = builder2.myParent != null ? new MyDialogWrapper(builder2.myParent, builder2.myComponent) : new MyDialogWrapper(builder2.myProject, builder2.myComponent);
            this.myDialog.setParameters(builder2.myDimensionServiceKey, (Computable<? extends JComponent>)builder2.myPreferredFocusedComponent, builder2.myOnCloseHandler);
            WindowWrapperBuilder.installOnShowCallback(this.myDialog.getWindow(), builder2.myOnShowCallback);
            this.setTitle(builder2.title);
            switch (builder2.myMode) {
                case MODAL: {
                    this.myDialog.setModal(true);
                    break;
                }
                case NON_MODAL: {
                    this.myDialog.setModal(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.myDialog.init();
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myDialog.getDisposable());
        }

        public void show() {
            this.myDialog.show();
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                DialogWindowWrapper.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            WindowWrapper.Mode mode = this.myMode;
            if (mode == null) {
                DialogWindowWrapper.$$$reportNull$$$0(2);
            }
            return mode;
        }

        @NotNull
        public Window getWindow() {
            Window window = this.myDialog.getWindow();
            if (window == null) {
                DialogWindowWrapper.$$$reportNull$$$0(3);
            }
            return window;
        }

        public void setTitle(@Nullable String title) {
            this.myDialog.setTitle(StringUtil.notNullize((String)title));
        }

        public void setImages(@Nullable List<? extends Image> images) {
        }

        public void close() {
            this.myDialog.close(1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyDialogWrapper
        extends DialogWrapper {
            @NotNull
            private final JComponent myComponent;
            @Nullable
            private String myDimensionServiceKey;
            @Nullable
            private Computable<? extends JComponent> myPreferredFocusedComponent;
            @Nullable
            private BooleanGetter myOnCloseHandler;

            MyDialogWrapper(@Nullable Project project, @NotNull JComponent component2) {
                if (component2 == null) {
                    MyDialogWrapper.$$$reportNull$$$0(0);
                }
                super(project, true);
                this.myComponent = component2;
            }

            MyDialogWrapper(@NotNull Component parent, @NotNull JComponent component2) {
                if (parent == null) {
                    MyDialogWrapper.$$$reportNull$$$0(1);
                }
                if (component2 == null) {
                    MyDialogWrapper.$$$reportNull$$$0(2);
                }
                super(parent, true);
                this.myComponent = component2;
            }

            public void setParameters(@Nullable String dimensionServiceKey, @Nullable Computable<? extends JComponent> preferredFocusedComponent, @Nullable BooleanGetter onCloseHandler) {
                this.myDimensionServiceKey = dimensionServiceKey;
                this.myPreferredFocusedComponent = preferredFocusedComponent;
                this.myOnCloseHandler = onCloseHandler;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            protected JComponent createCenterPanel() {
                return this.myComponent;
            }

            protected Action @NotNull [] createActions() {
                return new Action[0];
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return this.myDimensionServiceKey;
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }

            public void doCancelAction() {
                if (this.myOnCloseHandler != null && !this.myOnCloseHandler.get()) {
                    return;
                }
                super.doCancelAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/ui/WindowWrapperBuilder$DialogWindowWrapper$MyDialogWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

