/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.Nullable;

public enum ExternalUpdateManager {
    TOOLBOX("Toolbox"),
    SNAP("Snap"),
    UNKNOWN(null);

    public final String toolName;
    @Nullable
    public static final ExternalUpdateManager ACTUAL;

    private ExternalUpdateManager(String name) {
        this.toolName = name != null ? name : ("true".equalsIgnoreCase(name = System.getProperty("ide.no.platform.update")) ? "(unknown)" : name);
    }

    public static boolean isRoaming() {
        return ACTUAL == TOOLBOX || ACTUAL == SNAP;
    }

    static {
        String home = PathManager.getHomePath().replace('\\', '/');
        ACTUAL = home.contains("/apps/") && home.contains("/ch-") ? TOOLBOX : (SystemInfo.isLinux && (home.startsWith("/snap/") || home.startsWith("/var/lib/snapd/snap/")) ? SNAP : (System.getProperty("ide.no.platform.update") != null ? UNKNOWN : null));
    }
}

