/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J4\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJR\u0010\u0015\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeChangeHandler;", "", "()V", "getNewAffectedBlock", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "side", "Lcom/intellij/diff/util/Side;", "startLine", "", "endLine", "rangeSizeDelta", "ourToOtherShift", "affectedBlocks", "", "getOurToOtherShift", "beforeBlocks", "run", "Lcom/intellij/openapi/vcs/ex/RangeChangeHandler$Result;", "blocks", "beforeLength", "afterLength", "sortRanges", "Lkotlin/Triple;", "line1", "line2", "Result", "intellij.platform.diff.impl"})
final class RangeChangeHandler {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result run(@NotNull List<DocumentTracker.Block> blocks, @NotNull Side side, int startLine, int beforeLength, int afterLength) {
        void $this$mapTo$iv$iv;
        void affectedBlocks;
        void beforeBlocks;
        Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        int endLine = startLine + beforeLength;
        int rangeSizeDelta = afterLength - beforeLength;
        Triple<List<DocumentTracker.Block>, List<DocumentTracker.Block>, List<DocumentTracker.Block>> triple = this.sortRanges(blocks, side, startLine, endLine);
        List list2 = (List)triple.component1();
        List list3 = (List)triple.component2();
        List afterBlocks = (List)triple.component3();
        int ourToOtherShift = this.getOurToOtherShift(side, (List<DocumentTracker.Block>)beforeBlocks);
        DocumentTracker.Block newAffectedBlock = this.getNewAffectedBlock(side, startLine, endLine, rangeSizeDelta, ourToOtherShift, (List<DocumentTracker.Block>)affectedBlocks);
        Iterable $this$map$iv = afterBlocks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentTracker.Block block = (DocumentTracker.Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DocumentTracker.Block block2 = DocumentTrackerKt.access$shift((DocumentTracker.Block)it, side, rangeSizeDelta);
            collection.add(block2);
        }
        List newAfterBlocks = (List)destination$iv$iv;
        ArrayList<DocumentTracker.Block> newBlocks = new ArrayList<DocumentTracker.Block>(beforeBlocks.size() + newAfterBlocks.size() + 1);
        newBlocks.addAll((Collection)beforeBlocks);
        newBlocks.add(newAffectedBlock);
        newBlocks.addAll(newAfterBlocks);
        return new Result((List<DocumentTracker.Block>)beforeBlocks, (List<DocumentTracker.Block>)newBlocks, (List<DocumentTracker.Block>)affectedBlocks, afterBlocks, newAffectedBlock, newAfterBlocks);
    }

    private final Triple<List<DocumentTracker.Block>, List<DocumentTracker.Block>, List<DocumentTracker.Block>> sortRanges(List<DocumentTracker.Block> blocks, Side side, int line1, int line2) {
        ArrayList<DocumentTracker.Block> beforeChange = new ArrayList<DocumentTracker.Block>();
        ArrayList<DocumentTracker.Block> affected = new ArrayList<DocumentTracker.Block>();
        ArrayList<DocumentTracker.Block> afterChange2 = new ArrayList<DocumentTracker.Block>();
        for (DocumentTracker.Block block : blocks) {
            if (RangesBuilder.end(block.getRange(), side) < line1) {
                beforeChange.add(block);
                continue;
            }
            if (RangesBuilder.start(block.getRange(), side) > line2) {
                afterChange2.add(block);
                continue;
            }
            affected.add(block);
        }
        return new Triple(beforeChange, affected, afterChange2);
    }

    private final int getOurToOtherShift(Side side, List<DocumentTracker.Block> beforeBlocks) {
        DocumentTracker.Block block = (DocumentTracker.Block)CollectionsKt.lastOrNull(beforeBlocks);
        Range lastBefore = block != null ? block.getRange() : null;
        int otherShift = 0;
        if (lastBefore == null) {
            otherShift = 0;
        } else {
            Side side2 = side.other();
            Intrinsics.checkExpressionValueIsNotNull((Object)side2, (String)"side.other()");
            otherShift = RangesBuilder.end(lastBefore, side2) - RangesBuilder.end(lastBefore, side);
        }
        return otherShift;
    }

    private final DocumentTracker.Block getNewAffectedBlock(Side side, int startLine, int endLine, int rangeSizeDelta, int ourToOtherShift, List<DocumentTracker.Block> affectedBlocks) {
        boolean bl;
        int rangeEndOther;
        int rangeStartOther;
        int rangeEnd;
        int rangeStart;
        block9: {
            rangeStart = 0;
            rangeEnd = 0;
            rangeStartOther = 0;
            rangeEndOther = 0;
            if (affectedBlocks.isEmpty()) {
                rangeStart = startLine;
                rangeEnd = endLine + rangeSizeDelta;
                rangeStartOther = startLine + ourToOtherShift;
                rangeEndOther = endLine + ourToOtherShift;
            } else {
                Range firstAffected = ((DocumentTracker.Block)CollectionsKt.first(affectedBlocks)).getRange();
                Range lastAffected = ((DocumentTracker.Block)CollectionsKt.last(affectedBlocks)).getRange();
                int affectedStart = RangesBuilder.start(firstAffected, side);
                Side side2 = side.other();
                Intrinsics.checkExpressionValueIsNotNull((Object)side2, (String)"side.other()");
                int affectedStartOther = RangesBuilder.start(firstAffected, side2);
                int affectedEnd = RangesBuilder.end(lastAffected, side);
                Side side3 = side.other();
                Intrinsics.checkExpressionValueIsNotNull((Object)side3, (String)"side.other()");
                int affectedEndOther = RangesBuilder.end(lastAffected, side3);
                if (affectedStart <= startLine) {
                    rangeStart = affectedStart;
                    rangeStartOther = affectedStartOther;
                } else {
                    rangeStart = startLine;
                    rangeStartOther = startLine + (affectedStartOther - affectedStart);
                }
                if (affectedEnd >= endLine) {
                    rangeEnd = affectedEnd + rangeSizeDelta;
                    rangeEndOther = affectedEndOther;
                } else {
                    rangeEnd = endLine + rangeSizeDelta;
                    rangeEndOther = endLine + (affectedEndOther - affectedEnd);
                }
            }
            Iterable $this$any$iv = affectedBlocks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                    boolean bl2 = false;
                    if (!it.isTooBig$intellij_platform_diff_impl()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean isTooBig = bl;
        Range range2 = DocumentTrackerKt.access$createRange(side, rangeStart, rangeEnd, rangeStartOther, rangeEndOther);
        return new DocumentTracker.Block(range2, true, isTooBig);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003Jc\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeChangeHandler$Result;", "", "beforeBlocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "newBlocks", "affectedBlocks", "afterBlocks", "newAffectedBlock", "newAfterBlocks", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "getAffectedBlocks", "()Ljava/util/List;", "getAfterBlocks", "getBeforeBlocks", "getNewAffectedBlock", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getNewAfterBlocks", "getNewBlocks", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class Result {
        @NotNull
        private final List<DocumentTracker.Block> beforeBlocks;
        @NotNull
        private final List<DocumentTracker.Block> newBlocks;
        @NotNull
        private final List<DocumentTracker.Block> affectedBlocks;
        @NotNull
        private final List<DocumentTracker.Block> afterBlocks;
        @NotNull
        private final DocumentTracker.Block newAffectedBlock;
        @NotNull
        private final List<DocumentTracker.Block> newAfterBlocks;

        @NotNull
        public final List<DocumentTracker.Block> getBeforeBlocks() {
            return this.beforeBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getNewBlocks() {
            return this.newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getAffectedBlocks() {
            return this.affectedBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getAfterBlocks() {
            return this.afterBlocks;
        }

        @NotNull
        public final DocumentTracker.Block getNewAffectedBlock() {
            return this.newAffectedBlock;
        }

        @NotNull
        public final List<DocumentTracker.Block> getNewAfterBlocks() {
            return this.newAfterBlocks;
        }

        public Result(@NotNull List<DocumentTracker.Block> beforeBlocks, @NotNull List<DocumentTracker.Block> newBlocks, @NotNull List<DocumentTracker.Block> affectedBlocks, @NotNull List<DocumentTracker.Block> afterBlocks, @NotNull DocumentTracker.Block newAffectedBlock, @NotNull List<DocumentTracker.Block> newAfterBlocks) {
            Intrinsics.checkParameterIsNotNull(beforeBlocks, (String)"beforeBlocks");
            Intrinsics.checkParameterIsNotNull(newBlocks, (String)"newBlocks");
            Intrinsics.checkParameterIsNotNull(affectedBlocks, (String)"affectedBlocks");
            Intrinsics.checkParameterIsNotNull(afterBlocks, (String)"afterBlocks");
            Intrinsics.checkParameterIsNotNull((Object)newAffectedBlock, (String)"newAffectedBlock");
            Intrinsics.checkParameterIsNotNull(newAfterBlocks, (String)"newAfterBlocks");
            this.beforeBlocks = beforeBlocks;
            this.newBlocks = newBlocks;
            this.affectedBlocks = affectedBlocks;
            this.afterBlocks = afterBlocks;
            this.newAffectedBlock = newAffectedBlock;
            this.newAfterBlocks = newAfterBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component1() {
            return this.beforeBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component2() {
            return this.newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component3() {
            return this.affectedBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component4() {
            return this.afterBlocks;
        }

        @NotNull
        public final DocumentTracker.Block component5() {
            return this.newAffectedBlock;
        }

        @NotNull
        public final List<DocumentTracker.Block> component6() {
            return this.newAfterBlocks;
        }

        @NotNull
        public final Result copy(@NotNull List<DocumentTracker.Block> beforeBlocks, @NotNull List<DocumentTracker.Block> newBlocks, @NotNull List<DocumentTracker.Block> affectedBlocks, @NotNull List<DocumentTracker.Block> afterBlocks, @NotNull DocumentTracker.Block newAffectedBlock, @NotNull List<DocumentTracker.Block> newAfterBlocks) {
            Intrinsics.checkParameterIsNotNull(beforeBlocks, (String)"beforeBlocks");
            Intrinsics.checkParameterIsNotNull(newBlocks, (String)"newBlocks");
            Intrinsics.checkParameterIsNotNull(affectedBlocks, (String)"affectedBlocks");
            Intrinsics.checkParameterIsNotNull(afterBlocks, (String)"afterBlocks");
            Intrinsics.checkParameterIsNotNull((Object)newAffectedBlock, (String)"newAffectedBlock");
            Intrinsics.checkParameterIsNotNull(newAfterBlocks, (String)"newAfterBlocks");
            return new Result(beforeBlocks, newBlocks, affectedBlocks, afterBlocks, newAffectedBlock, newAfterBlocks);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list2, List list3, List list4, List list5, DocumentTracker.Block block, List list6, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = result2.beforeBlocks;
            }
            if ((n & 2) != 0) {
                list3 = result2.newBlocks;
            }
            if ((n & 4) != 0) {
                list4 = result2.affectedBlocks;
            }
            if ((n & 8) != 0) {
                list5 = result2.afterBlocks;
            }
            if ((n & 0x10) != 0) {
                block = result2.newAffectedBlock;
            }
            if ((n & 0x20) != 0) {
                list6 = result2.newAfterBlocks;
            }
            return result2.copy(list2, list3, list4, list5, block, list6);
        }

        @NotNull
        public String toString() {
            return "Result(beforeBlocks=" + this.beforeBlocks + ", newBlocks=" + this.newBlocks + ", affectedBlocks=" + this.affectedBlocks + ", afterBlocks=" + this.afterBlocks + ", newAffectedBlock=" + this.newAffectedBlock + ", newAfterBlocks=" + this.newAfterBlocks + ")";
        }

        public int hashCode() {
            List<DocumentTracker.Block> list2 = this.beforeBlocks;
            List<DocumentTracker.Block> list3 = this.newBlocks;
            List<DocumentTracker.Block> list4 = this.affectedBlocks;
            List<DocumentTracker.Block> list5 = this.afterBlocks;
            DocumentTracker.Block block = this.newAffectedBlock;
            List<DocumentTracker.Block> list6 = this.newAfterBlocks;
            return (((((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0)) * 31 + (list5 != null ? ((Object)list5).hashCode() : 0)) * 31 + (block != null ? block.hashCode() : 0)) * 31 + (list6 != null ? ((Object)list6).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual(this.beforeBlocks, result2.beforeBlocks) || !Intrinsics.areEqual(this.newBlocks, result2.newBlocks) || !Intrinsics.areEqual(this.affectedBlocks, result2.affectedBlocks) || !Intrinsics.areEqual(this.afterBlocks, result2.afterBlocks) || !Intrinsics.areEqual((Object)this.newAffectedBlock, (Object)result2.newAffectedBlock) || !Intrinsics.areEqual(this.newAfterBlocks, result2.newAfterBlocks)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

