/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentLogManagerImpl
implements DeploymentLogManager {
    private final LoggingHandlerImpl myMainLoggingHandler;
    private final Project myProject;
    private final List<LoggingHandlerBase> myAdditionalLoggingHandlers;
    private final Runnable myChangeListener;
    private final AtomicBoolean myLogsDisposed;
    private final Disposable myLogsDisposable;
    private boolean myMainHandlerVisible;

    public DeploymentLogManagerImpl(@NotNull Project project, @NotNull Runnable changeListener) {
        if (project == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(0);
        }
        if (changeListener == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(1);
        }
        this.myAdditionalLoggingHandlers = new ArrayList<LoggingHandlerBase>();
        this.myLogsDisposed = new AtomicBoolean(false);
        this.myMainHandlerVisible = false;
        this.myProject = project;
        this.myChangeListener = changeListener;
        this.myMainLoggingHandler = new LoggingHandlerImpl.Colored(null, project);
        this.myLogsDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)this.myMainLoggingHandler);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DeploymentLogManagerImpl.this.disposeLogs();
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    public DeploymentLogManagerImpl withMainHandlerVisible(boolean mainHandlerVisible) {
        this.myMainHandlerVisible = mainHandlerVisible;
        return this;
    }

    public boolean isMainHandlerVisible() {
        return this.myMainHandlerVisible;
    }

    @NotNull
    public LoggingHandlerImpl getMainLoggingHandler() {
        LoggingHandlerImpl loggingHandlerImpl = this.myMainLoggingHandler;
        if (loggingHandlerImpl == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(3);
        }
        return loggingHandlerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public LoggingHandler addAdditionalLog(@NotNull String presentableName) {
        if (presentableName == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(4);
        }
        AtomicBoolean atomicBoolean = this.myLogsDisposed;
        // MONITORENTER : atomicBoolean
        if (this.myLogsDisposed.get()) {
            throw new IllegalStateException("Already disposed, can't add " + presentableName);
        }
        LoggingHandlerImpl.Colored handler2 = new LoggingHandlerImpl.Colored(presentableName, this.myProject);
        this.addAdditionalLoggingHandler(handler2);
        LoggingHandlerImpl.Colored colored = handler2;
        // MONITOREXIT : atomicBoolean
        if (colored != null) return colored;
        DeploymentLogManagerImpl.$$$reportNull$$$0(5);
        return colored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditionalLog(@NotNull String presentableName) {
        if (presentableName == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(6);
        }
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            this.myAdditionalLoggingHandlers.removeIf(next -> presentableName.equals(next.getPresentableName()));
        }
        this.myChangeListener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public LoggingHandler findOrCreateAdditionalLog(@NotNull String presentableName) {
        LoggingHandlerBase next;
        if (presentableName == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(7);
        }
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        // MONITORENTER : list2
        Iterator<LoggingHandlerBase> iterator2 = this.myAdditionalLoggingHandlers.iterator();
        do {
            if (iterator2.hasNext()) continue;
            LoggingHandler loggingHandler = this.addAdditionalLog(presentableName);
            // MONITOREXIT : list2
            if (loggingHandler != null) return loggingHandler;
            DeploymentLogManagerImpl.$$$reportNull$$$0(9);
            return loggingHandler;
        } while (!((next = iterator2.next()) instanceof LoggingHandler) || !presentableName.equals(next.getPresentableName()));
        LoggingHandler loggingHandler = (LoggingHandler)next;
        // MONITOREXIT : list2
        if (loggingHandler != null) return loggingHandler;
        DeploymentLogManagerImpl.$$$reportNull$$$0(8);
        return loggingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TerminalHandler addTerminal(@NotNull String presentableName, InputStream terminalOutput, OutputStream terminalInput) {
        if (presentableName == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(10);
        }
        AtomicBoolean atomicBoolean = this.myLogsDisposed;
        synchronized (atomicBoolean) {
            if (this.myLogsDisposed.get()) {
                return null;
            }
            TerminalHandlerBase handler2 = CloudTerminalProvider.getInstance().createTerminal(presentableName, this.myProject, terminalOutput, terminalInput);
            this.addAdditionalLoggingHandler(handler2);
            return handler2;
        }
    }

    public boolean isTtySupported() {
        return CloudTerminalProvider.getInstance().isTtySupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdditionalLoggingHandler(LoggingHandlerBase loggingHandler) {
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)loggingHandler);
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            this.myAdditionalLoggingHandlers.add(loggingHandler);
        }
        this.myChangeListener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LoggingHandlerBase> getAdditionalLoggingHandlers() {
        ArrayList<LoggingHandlerBase> result2;
        List<LoggingHandlerBase> list2 = this.myAdditionalLoggingHandlers;
        synchronized (list2) {
            result2 = new ArrayList<LoggingHandlerBase>(this.myAdditionalLoggingHandlers);
        }
        ArrayList<LoggingHandlerBase> arrayList = result2;
        if (arrayList == null) {
            DeploymentLogManagerImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeLogs() {
        AtomicBoolean atomicBoolean = this.myLogsDisposed;
        synchronized (atomicBoolean) {
            if (!this.myLogsDisposed.getAndSet(true)) {
                Disposer.dispose((Disposable)this.myLogsDisposable);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainLoggingHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addAdditionalLog";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateAdditionalLog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalLoggingHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalLog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeAdditionalLog";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateAdditionalLog";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTerminal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

