/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyAlternationBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EmptyAlternationBranchInspection.$$$reportNull$$$0(0);
        }
        return new EmptyAlternationBranchVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection", "buildVisitor"));
    }

    private static class EmptyAlternationBranchFix
    implements LocalQuickFix {
        private EmptyAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.empty.branch", new Object[0]);
            if (string == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(2);
            }
            if (!((element2 = descriptor2.getPsiElement()).getParent() instanceof RegExpPattern)) {
                return;
            }
            element2.getNextSibling().delete();
            element2.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$EmptyAlternationBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$EmptyAlternationBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EmptyAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            boolean emptyBranchSeen = false;
            for (int i2 = 0; i2 < branches.length; ++i2) {
                RegExpBranch branch = branches[i2];
                if (branch.getAtoms().length > 0) continue;
                if (i2 == 0) {
                    emptyBranchSeen = true;
                    continue;
                }
                if (!emptyBranchSeen && i2 == branches.length - 1) continue;
                this.myHolder.registerProblem(branch.getPrevSibling(), RegExpBundle.message("inspection.warning.empty.branch.in.alternation", new Object[0]), new LocalQuickFix[]{new EmptyAlternationBranchFix()});
            }
        }
    }
}

