/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.StringDistance;
import net.jcip.annotations.Immutable;

@Immutable
public class LongestCommonSubsequence
implements StringDistance {
    public final double distance(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 0.0;
        }
        return s1.length() + s2.length() - 2 * this.length(s1, s2);
    }

    public final int length(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        int s1_length = s1.length();
        int s2_length = s2.length();
        char[] x = s1.toCharArray();
        char[] y = s2.toCharArray();
        int[][] c = new int[s1_length + 1][s2_length + 1];
        for (int i = 1; i <= s1_length; ++i) {
            for (int j = 1; j <= s2_length; ++j) {
                c[i][j] = x[i - 1] == y[j - 1] ? c[i - 1][j - 1] + 1 : Math.max(c[i][j - 1], c[i - 1][j]);
            }
        }
        return c[s1_length][s2_length];
    }
}

