/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonUpdateAction
extends AbstractVcsAction
implements UpdateInBackground {
    private static final Logger LOG = Logger.getInstance(AbstractCommonUpdateAction.class);
    private final boolean myAlwaysVisible;
    private final ActionInfo myActionInfo;
    private final ScopeInfo myScopeInfo;

    protected AbstractCommonUpdateAction(ActionInfo actionInfo, ScopeInfo scopeInfo, boolean alwaysVisible) {
        this.myActionInfo = actionInfo;
        this.myScopeInfo = scopeInfo;
        this.myAlwaysVisible = alwaysVisible;
    }

    private String getCompleteActionName(VcsContext dataContext) {
        return this.myActionInfo.getActionName(this.myScopeInfo.getScopeName(dataContext, this.myActionInfo));
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        boolean showUpdateOptions = this.myActionInfo.showOptions(project);
        LOG.debug("project: " + project + ", show update options: " + showUpdateOptions);
        if (project == null) {
            return;
        }
        try {
            FilePath[] filePaths = this.myScopeInfo.getRoots(context, this.myActionInfo);
            FilePath[] roots = DescindingFilesFilter.filterDescindingFiles(this.filterRoots(filePaths, context), project);
            if (roots.length == 0) {
                LOG.debug("No roots found.");
                return;
            }
            Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles = this.createVcsToFilesMap(roots, project);
            for (AbstractVcs vcs : vcsToVirtualFiles.keySet()) {
                UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                if (updateEnvironment == null || updateEnvironment.validateOptions(vcsToVirtualFiles.get(vcs))) continue;
                LOG.debug("Options not valid for files: " + vcsToVirtualFiles);
                return;
            }
            if (showUpdateOptions || OptionsDialog.shiftIsPressed((int)context.getModifiers())) {
                this.showOptionsDialog(vcsToVirtualFiles, project, context);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                StoreUtil.saveDocumentsAndProjectSettings((Project)project);
            }
            Updater task2 = new Updater(project, roots, vcsToVirtualFiles, this.myActionInfo, this.getTemplatePresentation().getText());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                task2.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static boolean someSessionWasCanceled(List<? extends UpdateSession> updateSessions) {
        for (UpdateSession updateSession : updateSessions) {
            if (!updateSession.isCanceled()) continue;
            return true;
        }
        return false;
    }

    private static String getAllFilesAreUpToDateMessage(FilePath[] roots) {
        if (roots.length == 1 && !roots[0].isDirectory()) {
            return VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0]);
        }
        return VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]);
    }

    private void showOptionsDialog(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles, Project project, VcsContext dataContext) {
        UpdateOrStatusOptionsDialog dialogOrStatus;
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = this.createConfigurableToEnvMap(updateEnvToVirtualFiles);
        LOG.debug("configurables map: " + envToConfMap);
        if (!envToConfMap.isEmpty() && !(dialogOrStatus = this.myActionInfo.createOptionsDialog(project, envToConfMap, this.myScopeInfo.getScopeName(dataContext, this.myActionInfo))).showAndGet()) {
            throw new ProcessCanceledException();
        }
    }

    private LinkedHashMap<Configurable, AbstractVcs> createConfigurableToEnvMap(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles) {
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = new LinkedHashMap<Configurable, AbstractVcs>();
        for (AbstractVcs vcs : updateEnvToVirtualFiles.keySet()) {
            Configurable configurable = this.myActionInfo.getEnvironment(vcs).createConfigurable(updateEnvToVirtualFiles.get(vcs));
            if (configurable == null) continue;
            envToConfMap.put(configurable, vcs);
        }
        return envToConfMap;
    }

    private Map<AbstractVcs, Collection<FilePath>> createVcsToFilesMap(FilePath @NotNull [] roots, @NotNull Project project) {
        if (project == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(2);
        }
        MultiMap resultPrep = MultiMap.createSet();
        for (FilePath file : roots) {
            UpdateEnvironment updateEnvironment;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file);
            if (vcs == null || (updateEnvironment = this.myActionInfo.getEnvironment(vcs)) == null) continue;
            resultPrep.putValue((Object)vcs, (Object)file);
        }
        THashMap result2 = new THashMap();
        for (Map.Entry entry : resultPrep.entrySet()) {
            AbstractVcs vcs = (AbstractVcs)entry.getKey();
            result2.put(vcs, vcs.filterUniqueRoots(new ArrayList((Collection)entry.getValue()), FilePath::getVirtualFile));
        }
        return result2;
    }

    private FilePath @NotNull [] filterRoots(FilePath[] roots, VcsContext vcsContext) {
        ArrayList<FilePath> result2 = new ArrayList<FilePath>();
        Project project = vcsContext.getProject();
        assert (project != null);
        for (FilePath file : roots) {
            VirtualFile[] vcsRoots;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file);
            if (vcs == null) continue;
            if (!this.myScopeInfo.filterExistsInVcs() || AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)file)) {
                UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                if (updateEnvironment == null) continue;
                result2.add(file);
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !virtualFile.isDirectory()) continue;
            for (VirtualFile vcsRoot : vcsRoots = ProjectLevelVcsManager.getInstance((Project)vcsContext.getProject()).getAllVersionedRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vcsRoot, (boolean)false)) continue;
                result2.add(file);
            }
        }
        FilePath[] filePathArray = result2.toArray(new FilePath[0]);
        if (filePathArray == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(3);
        }
        return filePathArray;
    }

    protected abstract boolean filterRootsBeforeAction();

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        FilePath[] roots;
        Project project;
        if (vcsContext == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(4);
        }
        if (presentation == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(5);
        }
        if ((project = vcsContext.getProject()) == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        boolean underVcs = vcsManager2.hasActiveVcss();
        if (!underVcs) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        String actionName = this.getCompleteActionName(vcsContext);
        if (this.myActionInfo.showOptions(project) || OptionsDialog.shiftIsPressed((int)vcsContext.getModifiers())) {
            actionName = actionName + "...";
        }
        presentation.setText(actionName);
        if (AbstractCommonUpdateAction.supportingVcsesAreEmpty(vcsManager2, this.myActionInfo)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (this.filterRootsBeforeAction() && (roots = this.filterRoots(this.myScopeInfo.getRoots(vcsContext, this.myActionInfo), vcsContext)).length == 0) {
            presentation.setVisible(this.myAlwaysVisible);
            presentation.setEnabled(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(!vcsManager2.isBackgroundVcsOperationRunning());
    }

    private static boolean supportingVcsesAreEmpty(ProjectLevelVcsManager vcsManager2, ActionInfo actionInfo) {
        AbstractVcs[] allActiveVcss;
        for (AbstractVcs activeVcs : allActiveVcss = vcsManager2.getAllActiveVcss()) {
            if (actionInfo.getEnvironment(activeVcs) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean showsCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
        if (vcss == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(6);
        }
        return ContainerUtil.all(vcss, vcs -> {
            UpdateEnvironment environment = vcs.getUpdateEnvironment();
            return environment != null && environment.hasCustomNotification();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcss";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVcsToFilesMap";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showsCustomNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static class Updater
    extends Task.Backgroundable {
        private final String LOCAL_HISTORY_ACTION = VcsBundle.message((String)"local.history.update.from.vcs", (Object[])new Object[0]);
        private final Project myProject;
        private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
        protected UpdatedFiles myUpdatedFiles;
        private final FilePath[] myRoots;
        private final Map<AbstractVcs, Collection<FilePath>> myVcsToVirtualFiles;
        private final Map<HotfixData, List<VcsException>> myGroupedExceptions;
        private final List<UpdateSession> myUpdateSessions;
        private int myUpdateNumber;
        private final Map<AbstractVcs, SequentialUpdatesContext> myContextInfo;
        private final VcsDirtyScopeManager myDirtyScopeManager;
        private Label myBefore;
        private Label myAfter;
        private LocalHistoryAction myLocalHistoryAction;
        private final ActionInfo myActionInfo;
        private final String myActionName;

        public Updater(Project project, FilePath[] roots, Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles, ActionInfo actionInfo, String actionName) {
            super(project, actionName, true, VcsConfiguration.getInstance((Project)project).getUpdateOption());
            this.myProject = project;
            this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
            this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            this.myRoots = roots;
            this.myVcsToVirtualFiles = vcsToVirtualFiles;
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions = new HashMap<HotfixData, List<VcsException>>();
            this.myUpdateSessions = new ArrayList<UpdateSession>();
            this.myActionInfo = actionInfo;
            this.myActionName = actionName;
            this.myContextInfo = new HashMap<AbstractVcs, SequentialUpdatesContext>();
            this.myUpdateNumber = 1;
        }

        private void reset() {
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions.clear();
            this.myUpdateSessions.clear();
            ++this.myUpdateNumber;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Updater.$$$reportNull$$$0(0);
            }
            this.runImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            StoreReloadManager.getInstance().blockReloadingProjectOnExternalChanges();
            this.myProjectLevelVcsManager.startBackgroundVcsOperation();
            this.myBefore = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before update");
            this.myLocalHistoryAction = LocalHistory.getInstance().startAction(this.LOCAL_HISTORY_ACTION);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(false);
            }
            IdeActivity activity = IdeActivity.started((Project)this.myProject, (String)"vcs", (String)"update");
            try {
                int toBeProcessed = this.myVcsToVirtualFiles.size();
                int processed = 0;
                for (AbstractVcs vcs : this.myVcsToVirtualFiles.keySet()) {
                    UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                    updateEnvironment.fillGroups(this.myUpdatedFiles);
                    Collection<FilePath> files = this.myVcsToVirtualFiles.get(vcs);
                    SequentialUpdatesContext context = this.myContextInfo.get(vcs);
                    Ref refContext = new Ref((Object)context);
                    UpdateSession updateSession = this.performUpdate(progressIndicator, updateEnvironment, files, (Ref<SequentialUpdatesContext>)refContext);
                    this.myContextInfo.put(vcs, (SequentialUpdatesContext)refContext.get());
                    ++processed;
                    if (progressIndicator != null) {
                        progressIndicator.setFraction((double)processed / (double)toBeProcessed);
                        progressIndicator.setText2("");
                    }
                    List exceptionList = updateSession.getExceptions();
                    this.gatherExceptions(vcs, exceptionList);
                    this.myUpdateSessions.add(updateSession);
                }
            }
            finally {
                try {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
                    this.doVfsRefresh();
                }
                finally {
                    this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
                    ((UpdatedFilesListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, UpdatedFilesListener.UPDATED_FILES)).consume(UpdatedFilesReverseSide.getPathsFromUpdatedFiles((UpdatedFiles)this.myUpdatedFiles));
                    activity.finished();
                }
            }
        }

        @NotNull
        protected UpdateSession performUpdate(ProgressIndicator progressIndicator, UpdateEnvironment updateEnvironment, Collection<FilePath> files, Ref<SequentialUpdatesContext> refContext) {
            UpdateSession updateSession = updateEnvironment.updateDirectories(files.toArray(new FilePath[0]), this.myUpdatedFiles, progressIndicator, refContext);
            if (updateSession == null) {
                Updater.$$$reportNull$$$0(1);
            }
            return updateSession;
        }

        private void gatherExceptions(AbstractVcs vcs, List<VcsException> exceptionList) {
            VcsExceptionsHotFixer fixer = vcs.getVcsExceptionsHotFixer();
            if (fixer == null) {
                this.putExceptions(null, exceptionList);
            } else {
                this.putExceptions(fixer.groupExceptions(ActionType.update, exceptionList));
            }
        }

        private void putExceptions(Map<HotfixData, List<VcsException>> map2) {
            for (Map.Entry<HotfixData, List<VcsException>> entry : map2.entrySet()) {
                this.putExceptions(entry.getKey(), entry.getValue());
            }
        }

        private void putExceptions(HotfixData key, @NotNull List<? extends VcsException> list) {
            if (list == null) {
                Updater.$$$reportNull$$$0(2);
            }
            if (list.isEmpty()) {
                return;
            }
            this.myGroupedExceptions.computeIfAbsent(key, k -> new ArrayList()).addAll(list);
        }

        private void doVfsRefresh() {
            LOG.info("Calling refresh files after update for roots: " + Arrays.toString(this.myRoots));
            RefreshVFsSynchronously.updateAllChanged(this.myUpdatedFiles);
            this.notifyAnnotations();
        }

        private void notifyAnnotations() {
            final VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
            UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                @Override
                public void onFile(String filePath, String groupId) {
                    refresher.dirty(filePath);
                }
            });
        }

        @NotNull
        private Notification prepareNotification(@NotNull UpdateInfoTree tree, boolean someSessionWasCancelled, @NotNull List<? extends UpdateSession> updateSessions) {
            NotificationType type;
            String content2;
            String title2;
            if (tree == null) {
                Updater.$$$reportNull$$$0(3);
            }
            if (updateSessions == null) {
                Updater.$$$reportNull$$$0(4);
            }
            int allFiles = this.getUpdatedFilesCount();
            String additionalContent = StringUtil.nullize((String)updateSessions.stream().map(UpdateSession::getAdditionalNotificationContent).filter(Objects::nonNull).collect(Collectors.joining(", ")));
            if (someSessionWasCancelled) {
                title2 = "Project Partially Updated";
                content2 = allFiles + " " + StringUtil.pluralize((String)"file", (int)allFiles) + " updated";
                type = NotificationType.WARNING;
            } else {
                title2 = allFiles + " " + StringUtil.pluralize((String)"File", (int)allFiles) + " Updated";
                content2 = StringUtil.notNullize((String)this.prepareScopeUpdatedText(tree));
                type = NotificationType.INFORMATION;
            }
            if (additionalContent != null) {
                if (!content2.isEmpty()) {
                    content2 = content2 + "<br/>";
                }
                content2 = content2 + additionalContent;
            }
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title2, content2, type, null);
            if (notification == null) {
                Updater.$$$reportNull$$$0(5);
            }
            return notification;
        }

        private int getUpdatedFilesCount() {
            return this.myUpdatedFiles.getTopLevelGroups().stream().mapToInt(this::getFilesCount).sum();
        }

        private int getFilesCount(@NotNull FileGroup group) {
            if (group == null) {
                Updater.$$$reportNull$$$0(6);
            }
            return group.getFiles().size() + group.getChildren().stream().mapToInt(g -> this.getFilesCount((FileGroup)g)).sum();
        }

        @Nullable
        private String prepareScopeUpdatedText(@NotNull UpdateInfoTree tree) {
            if (tree == null) {
                Updater.$$$reportNull$$$0(7);
            }
            String scopeText = null;
            NamedScope scopeFilter = tree.getFilterScope();
            if (scopeFilter != null) {
                int filteredFiles = tree.getFilteredFilesCount();
                String filterName = scopeFilter.getName();
                scopeText = filteredFiles == 0 ? filterName + " wasn't modified" : filteredFiles + " in " + filterName;
            }
            return scopeText;
        }

        public void onSuccess() {
            this.onSuccessImpl(false);
        }

        private void onSuccessImpl(boolean wasCanceled) {
            boolean updateSuccess;
            if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
                StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
                LocalHistory.getInstance().putSystemLabel(this.myProject, this.LOCAL_HISTORY_ACTION);
                return;
            }
            boolean continueChain = false;
            for (SequentialUpdatesContext context : this.myContextInfo.values()) {
                continueChain |= context != null && context.shouldFail();
            }
            boolean continueChainFinal = continueChain;
            boolean someSessionWasCancelled = wasCanceled || AbstractCommonUpdateAction.someSessionWasCanceled(this.myUpdateSessions);
            for (UpdateSession updateSession : this.myUpdateSessions) {
                updateSession.onRefreshFilesCompleted();
            }
            if (this.myLocalHistoryAction != null) {
                this.myLocalHistoryAction.finish();
            }
            this.myAfter = LocalHistory.getInstance().putSystemLabel(this.myProject, "After update");
            if (this.myActionInfo.canChangeFileStatus()) {
                final ArrayList files = new ArrayList();
                RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
                revisionsCache.invalidate(this.myUpdatedFiles);
                UpdateFilesHelper.iterateFileGroupFiles(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                    @Override
                    public void onFile(String filePath, String groupId) {
                        String path2 = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(path2);
                        if (file != null) {
                            files.add(file);
                        }
                    }
                });
                this.myDirtyScopeManager.filesDirty(files, null);
            }
            boolean bl = updateSuccess = !someSessionWasCancelled && this.myGroupedExceptions.isEmpty();
            if (this.myProject.isDisposed()) {
                StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
                return;
            }
            if (!this.myGroupedExceptions.isEmpty()) {
                if (continueChainFinal) {
                    this.gatherContextInterruptedMessages();
                }
                AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myActionName}));
            } else if (someSessionWasCancelled) {
                ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]));
            } else {
                ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
            }
            boolean noMerged = this.myUpdatedFiles.getGroupById("MERGED_WITH_CONFLICTS").isEmpty();
            if (this.myUpdatedFiles.isEmpty() && this.myGroupedExceptions.isEmpty()) {
                NotificationType type;
                String content2;
                if (someSessionWasCancelled) {
                    content2 = VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]);
                    type = NotificationType.WARNING;
                } else {
                    content2 = AbstractCommonUpdateAction.getAllFilesAreUpToDateMessage(this.myRoots);
                    type = NotificationType.INFORMATION;
                }
                VcsNotifier.getInstance(this.myProject).notify(VcsNotifier.STANDARD_NOTIFICATION.createNotification(content2, type));
            } else if (!this.myUpdatedFiles.isEmpty()) {
                if (this.myUpdateSessions.size() == 1 && AbstractCommonUpdateAction.showsCustomNotification(this.myVcsToVirtualFiles.keySet())) {
                    this.myUpdateSessions.get(0).showNotification();
                } else {
                    UpdateInfoTree tree = this.showUpdateTree(continueChainFinal && updateSuccess && noMerged, someSessionWasCancelled);
                    CommittedChangesCache cache = CommittedChangesCache.getInstance(this.myProject);
                    cache.processUpdatedFiles(this.myUpdatedFiles, (Consumer<? super List<CommittedChangeList>>)((Consumer)incomingChangeLists -> tree.setChangeLists((List<? extends CommittedChangeList>)incomingChangeLists)));
                    Notification notification = this.prepareNotification(tree, someSessionWasCancelled, this.myUpdateSessions);
                    notification.addAction((AnAction)new ViewUpdateInfoNotification(this.myProject, tree, "View", notification));
                    VcsNotifier.getInstance(this.myProject).notify(notification);
                }
            }
            StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
            if (continueChainFinal && updateSuccess) {
                if (!noMerged) {
                    this.showContextInterruptedError();
                } else {
                    this.reset();
                    ProgressManager.getInstance().run((Task)this);
                }
            }
        }

        private void showContextInterruptedError() {
            this.gatherContextInterruptedMessages();
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myActionName}));
        }

        private void gatherContextInterruptedMessages() {
            for (Map.Entry<AbstractVcs, SequentialUpdatesContext> entry : this.myContextInfo.entrySet()) {
                SequentialUpdatesContext context = entry.getValue();
                if (context == null || !context.shouldFail()) continue;
                VcsException exception = new VcsException(context.getMessageWhenInterruptedBeforeStart());
                this.gatherExceptions(entry.getKey(), Collections.singletonList(exception));
            }
        }

        @NotNull
        private UpdateInfoTree showUpdateTree(boolean willBeContinued, boolean wasCanceled) {
            RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance(this.myProject);
            restoreUpdateTree.registerUpdateInformation(this.myUpdatedFiles, this.myActionInfo);
            String text2 = this.myActionName + (willBeContinued || this.myUpdateNumber > 1 ? "#" + this.myUpdateNumber : "");
            UpdateInfoTree updateInfoTree = Objects.requireNonNull(this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myUpdatedFiles, text2, this.myActionInfo, wasCanceled));
            updateInfoTree.setBefore(this.myBefore);
            updateInfoTree.setAfter(this.myAfter);
            updateInfoTree.setCanGroupByChangeList(this.canGroupByChangelist(this.myVcsToVirtualFiles.keySet()));
            UpdateInfoTree updateInfoTree2 = updateInfoTree;
            if (updateInfoTree2 == null) {
                Updater.$$$reportNull$$$0(8);
            }
            return updateInfoTree2;
        }

        private boolean canGroupByChangelist(Set<? extends AbstractVcs> abstractVcses) {
            if (this.myActionInfo.canGroupByChangelist()) {
                for (AbstractVcs abstractVcs : abstractVcses) {
                    if (abstractVcs.getCachingCommittedChangesProvider() == null) continue;
                    return true;
                }
            }
            return false;
        }

        public void onCancel() {
            this.onSuccessImpl(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateSessions";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performUpdate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareNotification";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showUpdateTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putExceptions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareNotification";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesCount";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareScopeUpdatedText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

