/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileOrDirectoryTreeNode
extends AbstractTreeNode
implements VirtualFilePointerListener,
Disposable {
    private static final Map<FileStatus, SimpleTextAttributes> myFileStatusToAttributeMap = new HashMap<FileStatus, SimpleTextAttributes>();
    private final SimpleTextAttributes myInvalidAttributes;
    @NotNull
    private final Project myProject;
    protected final File myFile;
    private final String myName;

    FileOrDirectoryTreeNode(@NotNull String path2, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project, @Nullable String parentPath) {
        if (path2 == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(0);
        }
        if (invalidAttributes == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(2);
        }
        String preparedPath = path2.replace(File.separatorChar, '/');
        String url = VirtualFileManager.constructUrl((String)LocalFileSystem.getInstance().getProtocol(), (String)preparedPath);
        this.setUserObject(VirtualFilePointerManager.getInstance().create(url, (Disposable)this, (VirtualFilePointerListener)this));
        this.myFile = new File(this.getFilePath());
        this.myInvalidAttributes = invalidAttributes;
        this.myProject = project;
        this.myName = parentPath == null ? this.myFile.getAbsolutePath() : this.myFile.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected String getFilePath() {
        return this.getFilePointer().getPresentableUrl();
    }

    public void validityChanged(VirtualFilePointer @NotNull [] pointers) {
        if (pointers == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(4);
        }
        if (!this.getFilePointer().isValid()) {
            AbstractTreeNode parent = (AbstractTreeNode)this.getParent();
            if (parent != null && parent.getSupportsDeletion()) {
                this.getTreeModel().removeNodeFromParent(this);
            } else if (this.getTree() != null) {
                this.getTree().repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserObject(Object userObject) {
        Object oldObject = this.getUserObject();
        try {
            super.setUserObject(userObject);
        }
        finally {
            if (oldObject instanceof VirtualFilePointer) {
                VirtualFilePointer pointer = (VirtualFilePointer)oldObject;
                Disposer.dispose((Disposable)((Disposable)pointer));
            }
        }
    }

    public VirtualFilePointer getFilePointer() {
        return (VirtualFilePointer)this.getUserObject();
    }

    @Override
    @NotNull
    public SimpleTextAttributes getAttributes() {
        if (!this.getFilePointer().isValid()) {
            SimpleTextAttributes simpleTextAttributes = this.myInvalidAttributes;
            if (simpleTextAttributes == null) {
                FileOrDirectoryTreeNode.$$$reportNull$$$0(5);
            }
            return simpleTextAttributes;
        }
        VirtualFile file = this.getFilePointer().getFile();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        FileStatus status = fileStatusManager.getStatus(file);
        SimpleTextAttributes attributes2 = FileOrDirectoryTreeNode.getAttributesFor(status);
        SimpleTextAttributes simpleTextAttributes = this.myFilterAttributes == null ? attributes2 : SimpleTextAttributes.merge((SimpleTextAttributes)this.myFilterAttributes, (SimpleTextAttributes)attributes2);
        if (simpleTextAttributes == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(6);
        }
        return simpleTextAttributes;
    }

    @NotNull
    private static SimpleTextAttributes getAttributesFor(@NotNull FileStatus status) {
        Color color;
        if (status == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(7);
        }
        if ((color = status.getColor()) == null) {
            color = UIUtil.getListForeground();
        }
        if (!myFileStatusToAttributeMap.containsKey(status)) {
            myFileStatusToAttributeMap.put(status, new SimpleTextAttributes(0, color));
        }
        SimpleTextAttributes simpleTextAttributes = myFileStatusToAttributeMap.get(status);
        if (simpleTextAttributes == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(8);
        }
        return simpleTextAttributes;
    }

    @Override
    public boolean getSupportsDeletion() {
        AbstractTreeNode parent = (AbstractTreeNode)this.getParent();
        return parent != null && parent.getSupportsDeletion();
    }

    public void dispose() {
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileOrDirectoryTreeNode.$$$reportNull$$$0(9);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidAttributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/FileOrDirectoryTreeNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/FileOrDirectoryTreeNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesFor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validityChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

