/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFileResolver {
    public static boolean isRemoteEnabled(Project project) {
        return !ApplicationManager.getApplication().isUnitTestMode() && JsonSchemaCatalogProjectConfiguration.getInstance(project).isRemoteActivityEnabled();
    }

    @Nullable
    public static VirtualFile urlToFile(@NotNull String urlString) {
        if (urlString == null) {
            JsonFileResolver.$$$reportNull$$$0(0);
        }
        if (urlString.startsWith("temp:///")) {
            return TempFileSystem.getInstance().findFileByPath(urlString.substring("temp:///".length() - 1));
        }
        return VirtualFileManager.getInstance().findFileByUrl(JsonFileResolver.replaceUnsafeSchemaStoreUrls(urlString));
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String replaceUnsafeSchemaStoreUrls(@Nullable String urlString) {
        if (urlString == null) {
            return null;
        }
        if (urlString.equals("http://schemastore.org/api/json/catalog.json")) {
            return "https://schemastore.azurewebsites.net/api/json/catalog.json";
        }
        if (StringUtil.startsWithIgnoreCase((String)urlString, (String)"http://json.schemastore.org")) {
            String newUrl = StringUtil.replace((String)urlString, (String)"http://json.schemastore.org/", (String)"https://schemastore.azurewebsites.net/schemas/json/");
            return newUrl.endsWith(".json") ? newUrl : newUrl + ".json";
        }
        return urlString;
    }

    @Nullable
    public static VirtualFile resolveSchemaByReference(@Nullable VirtualFile currentFile, @Nullable String schemaUrl) {
        if (schemaUrl == null) {
            return null;
        }
        boolean isHttpPath = JsonFileResolver.isHttpPath(schemaUrl);
        if (!isHttpPath && currentFile instanceof HttpVirtualFile) {
            String url = StringUtil.trimEnd((String)currentFile.getUrl(), (String)"/");
            int lastSlash = url.lastIndexOf(47);
            assert (lastSlash != -1);
            schemaUrl = url.substring(0, lastSlash) + "/" + schemaUrl;
        } else if (StringUtil.startsWithChar((CharSequence)schemaUrl, (char)'.') || !isHttpPath) {
            VirtualFile parent;
            VirtualFile virtualFile = parent = currentFile == null ? null : currentFile.getParent();
            String string = parent == null ? null : (schemaUrl = parent.getUrl().startsWith("temp:///") ? "temp:///" + parent.getPath() + "/" + schemaUrl : VfsUtilCore.pathToUrl((String)(parent.getPath() + File.separator + schemaUrl)));
        }
        if (schemaUrl != null) {
            String url;
            Url parse;
            VirtualFile virtualFile = JsonFileResolver.urlToFile(schemaUrl);
            if (virtualFile instanceof HttpVirtualFile && ((parse = Urls.parse((String)(url = virtualFile.getUrl()), (boolean)false)) == null || StringUtil.isEmpty((String)parse.getAuthority()) || StringUtil.isEmpty((String)parse.getPath()))) {
                return null;
            }
            if (virtualFile != null) {
                return virtualFile;
            }
        }
        return null;
    }

    public static void startFetchingHttpFileIfNeeded(@Nullable VirtualFile path, Project project) {
        if (!(path instanceof HttpVirtualFile)) {
            return;
        }
        if (!JsonFileResolver.isRemoteEnabled(project)) {
            return;
        }
        RemoteFileInfo info = ((HttpVirtualFile)path).getFileInfo();
        if (info == null || info.getState() == RemoteFileState.DOWNLOADING_NOT_STARTED) {
            path.refresh(true, false);
        }
    }

    public static boolean isHttpPath(@NotNull String schemaFieldText) {
        if (schemaFieldText == null) {
            JsonFileResolver.$$$reportNull$$$0(1);
        }
        Couple couple = UriUtil.splitScheme((String)schemaFieldText);
        return ((String)couple.first).startsWith("http");
    }

    public static boolean isAbsoluteUrl(@NotNull String path) {
        if (path == null) {
            JsonFileResolver.$$$reportNull$$$0(2);
        }
        return JsonFileResolver.isHttpPath(path) || path.startsWith("temp:///");
    }

    public static boolean isTempOrMockUrl(@NotNull String path) {
        if (path == null) {
            JsonFileResolver.$$$reportNull$$$0(3);
        }
        return path.startsWith("temp:///") || path.startsWith("mock:///");
    }

    public static boolean isSchemaUrl(@Nullable String url) {
        return url != null && url.startsWith("http://json-schema.org/") && (url.endsWith("/schema") || url.endsWith("/schema#"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFieldText";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/remote/JsonFileResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "urlToFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAbsoluteUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTempOrMockUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

