/* dino.vapi generated by valac 0.48.10, do not modify. */

namespace Dino {
	namespace Entities {
		[CCode (cheader_filename = "dino.h")]
		public class Account : GLib.Object {
			public Account (Xmpp.Jid bare_jid, string? resourcepart, string? password, string? alias);
			public bool equals (Dino.Entities.Account acc);
			public static bool equals_func (Dino.Entities.Account acc1, Dino.Entities.Account acc2);
			public Account.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public static uint hash_func (Dino.Entities.Account acc);
			public void persist (Dino.Database db);
			public void remove ();
			public string? alias { get; set; }
			public Xmpp.Jid bare_jid { owned get; }
			public string display_name { owned get; }
			public string domainpart { get; }
			public bool enabled { get; set; }
			public Xmpp.Jid full_jid { get; private set; }
			public int id { get; set; }
			public string localpart { get; }
			public GLib.DateTime mam_earliest_synced { get; set; }
			public string? password { get; set; }
			public string resourcepart { get; }
			public string? roster_version { get; set; }
		}
		[CCode (cheader_filename = "dino.h")]
		public class Conversation : GLib.Object {
			public enum NotifySetting {
				DEFAULT,
				ON,
				OFF,
				HIGHLIGHT
			}
			public enum Setting {
				DEFAULT,
				ON,
				OFF
			}
			public enum Type {
				CHAT,
				GROUPCHAT,
				GROUPCHAT_PM;
				public bool is_muc_semantic ();
			}
			public Conversation (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Conversation.Type type);
			public bool equals (Dino.Entities.Conversation? conversation);
			public static bool equals_func (Dino.Entities.Conversation conversation1, Dino.Entities.Conversation conversation2);
			public Conversation.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public Dino.Entities.Conversation.NotifySetting get_notification_default_setting (Dino.StreamInteractor stream_interactor);
			public Dino.Entities.Conversation.NotifySetting get_notification_setting (Dino.StreamInteractor stream_interactor);
			public Dino.Entities.Conversation.Setting get_send_marker_setting (Dino.StreamInteractor stream_interactor);
			public Dino.Entities.Conversation.Setting get_send_typing_setting (Dino.StreamInteractor stream_interactor);
			public static uint hash_func (Dino.Entities.Conversation conversation);
			public void persist (Dino.Database db);
			public Dino.Entities.Account account { get; private set; }
			public bool active { get; set; }
			public Xmpp.Jid counterpart { get; private set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public int id { get; set; }
			public GLib.DateTime? last_active { get; set; }
			public string? nickname { get; set; }
			public Dino.Entities.Conversation.NotifySetting notify_setting { get; set; }
			public Dino.Entities.Message? read_up_to { get; set; }
			public Dino.Entities.Conversation.Setting send_marker { get; set; }
			public Dino.Entities.Conversation.Setting send_typing { get; set; }
			public Dino.Entities.Conversation.Type type_ { get; set; }
			public signal void object_updated (Dino.Entities.Conversation conversation);
		}
		[CCode (cheader_filename = "dino.h")]
		public class FileTransfer : GLib.Object {
			public enum State {
				COMPLETE,
				IN_PROGRESS,
				NOT_STARTED,
				FAILED
			}
			public const bool DIRECTION_RECEIVED;
			public const bool DIRECTION_SENT;
			public FileTransfer ();
			public FileTransfer.from_row (Dino.Database db, Qlite.Row row, string storage_dir) throws Xmpp.InvalidJidError;
			public GLib.File get_file ();
			public void persist (Dino.Database db);
			public Dino.Entities.Account account { get; set; }
			public Xmpp.Jid counterpart { get; set; }
			public bool direction { get; set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public string file_name { get; set; }
			public Xmpp.Jid? from { get; }
			public int id { get; set; }
			public string info { get; set; }
			public GLib.InputStream input_stream { get; set; }
			public GLib.DateTime? local_time { get; set; }
			public string? mime_type { get; set; }
			public Xmpp.Jid ourpart { get; set; }
			public string path { get; set; }
			public int provider { get; set; }
			public string server_file_name { get; set; }
			public int size { get; set; }
			public Dino.Entities.FileTransfer.State state { get; set; }
			public GLib.DateTime time { get; set; }
			public Xmpp.Jid? to { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public class Message : GLib.Object {
			public enum Marked {
				NONE,
				RECEIVED,
				READ,
				ACKNOWLEDGED,
				UNSENT,
				WONTSEND
			}
			public enum Type {
				ERROR,
				CHAT,
				GROUPCHAT,
				GROUPCHAT_PM,
				UNKNOWN;
				public bool is_muc_semantic ();
			}
			public const bool DIRECTION_RECEIVED;
			public const bool DIRECTION_SENT;
			public Message (string? body);
			public bool equals (Dino.Entities.Message? m);
			public static bool equals_func (Dino.Entities.Message m1, Dino.Entities.Message m2);
			public Message.from_row (Dino.Database db, Qlite.Row row) throws Xmpp.InvalidJidError;
			public new string get_type_string ();
			public static uint hash_func (Dino.Entities.Message message);
			public void persist (Dino.Database db);
			public void set_type_string (string type);
			public Dino.Entities.Account account { get; set; }
			public string? body { get; set; }
			public Xmpp.Jid? counterpart { get; set; }
			public bool direction { get; set; }
			public Dino.Entities.Encryption encryption { get; set; }
			public Xmpp.Jid? from { get; }
			public int id { get; set; }
			public GLib.DateTime? local_time { get; set; }
			public Dino.Entities.Message.Marked marked { get; set; }
			public Xmpp.Jid? ourpart { get; set; }
			public Xmpp.Jid? real_jid { get; set; }
			public string? server_id { get; set; }
			public string? stanza_id { get; set; }
			public GLib.DateTime? time { get; set; }
			public Xmpp.Jid? to { get; }
			public Dino.Entities.Message.Type type_ { get; set; }
		}
		[CCode (cheader_filename = "dino.h")]
		public class Settings : GLib.Object {
			public Settings ();
			public Settings.from_db (Dino.Database db);
			public bool convert_utf8_smileys { get; set; }
			public bool notifications { get; set; }
			public bool send_marker { get; set; }
			public bool send_typing { get; set; }
		}
		[CCode (cheader_filename = "dino.h")]
		public enum Encryption {
			NONE,
			PGP,
			OMEMO
		}
	}
	namespace Plugins {
		[CCode (cheader_filename = "dino.h")]
		public abstract class AccountSettingsEntry : GLib.Object {
			protected AccountSettingsEntry ();
			public abstract Dino.Plugins.AccountSettingsWidget? get_widget (Dino.Plugins.WidgetType type);
			public abstract string id { get; }
			public virtual int16 label_top_padding { get; }
			public abstract string name { get; }
			public virtual Dino.Plugins.Priority priority { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public class ContactDetails : GLib.Object {
			public ContactDetails ();
			public signal void add (string category, string label, string? desc, GLib.Object widget);
			public signal void save ();
		}
		[CCode (cheader_filename = "dino.h")]
		public class InputFieldStatus : GLib.Object {
			public enum InputState {
				NORMAL,
				DISABLED,
				NO_SEND
			}
			public enum MessageType {
				NONE,
				INFO,
				WARNING,
				ERROR
			}
			public Dino.Plugins.InputFieldStatus.InputState input_state;
			public string? message;
			public Dino.Plugins.InputFieldStatus.MessageType message_type;
			public InputFieldStatus (string? message, Dino.Plugins.InputFieldStatus.MessageType message_type, Dino.Plugins.InputFieldStatus.InputState input_state);
		}
		[CCode (cheader_filename = "dino.h")]
		public class Loader : GLib.Object {
			public Loader (Dino.Application app);
			public Dino.Plugins.RootInterface load (string name) throws GLib.Error;
			public void loadAll () throws GLib.Error;
			public void shutdown ();
		}
		[CCode (cheader_filename = "dino.h")]
		public abstract class MetaConversationItem : GLib.Object {
			protected MetaConversationItem ();
			public abstract GLib.Object? get_widget (Dino.Plugins.WidgetType type);
			public abstract bool can_merge { get; set; }
			public virtual bool dim { get; set; }
			public virtual GLib.DateTime? display_time { get; set; }
			public virtual Dino.Entities.Encryption encryption { get; set; }
			public virtual Xmpp.Jid? jid { get; set; }
			public virtual Dino.Entities.Message.Marked mark { get; set; }
			public virtual string populator_id { get; set; }
			public abstract bool requires_avatar { get; set; }
			public abstract bool requires_header { get; set; }
			public virtual long seccondary_sort_indicator { get; set; }
			public virtual GLib.DateTime sort_time { get; set; }
			public virtual long tertiary_sort_indicator { get; set; }
		}
		[CCode (cheader_filename = "dino.h")]
		public abstract class MetaConversationNotification : GLib.Object {
			protected MetaConversationNotification ();
			public abstract GLib.Object? get_widget (Dino.Plugins.WidgetType type);
		}
		[CCode (cheader_filename = "dino.h")]
		public class Registry {
			public Registry ();
			public bool register_account_settings_entry (Dino.Plugins.AccountSettingsEntry entry);
			public bool register_contact_details_entry (Dino.Plugins.ContactDetailsProvider entry);
			public bool register_contact_titlebar_entry (Dino.Plugins.ConversationTitlebarEntry entry);
			public bool register_conversation_addition_populator (Dino.Plugins.ConversationAdditionPopulator populator);
			public bool register_encryption_list_entry (Dino.Plugins.EncryptionListEntry entry);
			public bool register_notification_populator (Dino.Plugins.NotificationPopulator populator);
			public bool register_text_command (Dino.Plugins.TextCommand cmd);
		}
		[CCode (cheader_filename = "dino.h")]
		public interface AccountSettingsWidget : GLib.Object {
			public abstract void deactivate ();
			public abstract void set_account (Dino.Entities.Account account);
			public signal void activated ();
		}
		[CCode (cheader_filename = "dino.h")]
		public interface ContactDetailsProvider : GLib.Object {
			public abstract void populate (Dino.Entities.Conversation conversation, Dino.Plugins.ContactDetails contact_details, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public interface ConversationAdditionPopulator : Dino.Plugins.ConversationItemPopulator {
			public virtual void populate_timespan (Dino.Entities.Conversation conversation, GLib.DateTime from, GLib.DateTime to);
		}
		[CCode (cheader_filename = "dino.h")]
		public interface ConversationItemCollection : GLib.Object {
			public abstract void insert_item (Dino.Plugins.MetaConversationItem item);
			public abstract void remove_item (Dino.Plugins.MetaConversationItem item);
			public signal void inserted_item (Dino.Plugins.MetaConversationItem item);
			public signal void removed_item (Dino.Plugins.MetaConversationItem item);
		}
		[CCode (cheader_filename = "dino.h")]
		public interface ConversationItemPopulator : GLib.Object {
			public abstract void close (Dino.Entities.Conversation conversation);
			public abstract void init (Dino.Entities.Conversation conversation, Dino.Plugins.ConversationItemCollection summary, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public interface ConversationTitlebarEntry : GLib.Object {
			public abstract Dino.Plugins.ConversationTitlebarWidget? get_widget (Dino.Plugins.WidgetType type);
			public abstract string id { get; }
			public abstract double order { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public interface ConversationTitlebarWidget : GLib.Object {
			public abstract void set_conversation (Dino.Entities.Conversation conversation);
			public abstract void unset_conversation ();
		}
		[CCode (cheader_filename = "dino.h")]
		public interface EncryptionListEntry : GLib.Object {
			public abstract void encryption_activated (Dino.Entities.Conversation conversation, Dino.Plugins.SetInputFieldStatus callback);
			public abstract Dino.Entities.Encryption encryption { get; }
			public abstract string name { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public interface NotificationCollection : GLib.Object {
			public signal void add_meta_notification (Dino.Plugins.MetaConversationNotification item);
			public signal void remove_meta_notification (Dino.Plugins.MetaConversationNotification item);
		}
		[CCode (cheader_filename = "dino.h")]
		public interface NotificationPopulator : GLib.Object {
			public abstract void close (Dino.Entities.Conversation conversation);
			public abstract void init (Dino.Entities.Conversation conversation, Dino.Plugins.NotificationCollection summary, Dino.Plugins.WidgetType type);
			public abstract string id { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public interface RootInterface : GLib.Object {
			public abstract void registered (Dino.Application app);
			public abstract void shutdown ();
		}
		[CCode (cheader_filename = "dino.h")]
		public interface TextCommand : GLib.Object {
			public abstract string? handle_command (string? text, Dino.Entities.Conversation? conversation);
			public abstract string cmd { get; }
		}
		[CCode (cheader_filename = "dino.h")]
		public enum Priority {
			LOWEST,
			LOWER,
			DEFAULT,
			HIGHER,
			HIGHEST
		}
		[CCode (cheader_filename = "dino.h")]
		public enum WidgetType {
			GTK
		}
		[CCode (cheader_filename = "dino.h")]
		public delegate void SetInputFieldStatus (Dino.Plugins.InputFieldStatus field_status);
	}
	[CCode (cheader_filename = "dino.h")]
	public class AvatarManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.AvatarManager> IDENTITY;
		public async Gdk.Pixbuf? get_avatar (Dino.Entities.Account account, Xmpp.Jid jid);
		public static string get_storage_dir ();
		public bool has_avatar (Dino.Entities.Account account, Xmpp.Jid jid);
		public void publish (Dino.Entities.Account account, string file);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void received_avatar (Gdk.Pixbuf avatar, Xmpp.Jid jid, Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "dino.h")]
	public class AvatarStorage : Xmpp.Xep.PixbufStorage, GLib.Object {
		public AvatarStorage (string folder);
	}
	[CCode (cheader_filename = "dino.h")]
	public class BlockingManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.BlockingManager> IDENTITY;
		public void block (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_blocked (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_supported (Dino.Entities.Account account);
		public static void start (Dino.StreamInteractor stream_interactor);
		public void unblock (Dino.Entities.Account account, Xmpp.Jid jid);
	}
	[CCode (cheader_filename = "dino.h")]
	public class ChatInteraction : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ChatInteraction> IDENTITY;
		public bool has_unread (Dino.Entities.Conversation conversation);
		public bool is_active_focus (Dino.Entities.Conversation? conversation = null);
		public void on_conversation_selected (Dino.Entities.Conversation conversation);
		public void on_message_cleared (Dino.Entities.Conversation? conversation);
		public void on_message_entered (Dino.Entities.Conversation? conversation);
		public void on_window_focus_in (Dino.Entities.Conversation? conversation);
		public void on_window_focus_out (Dino.Entities.Conversation? conversation);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void focused_in (Dino.Entities.Conversation conversation);
		public signal void focused_out (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class ConnectionManager : GLib.Object {
		public class ConnectionError {
			public enum Reconnect {
				NOW,
				LATER,
				NEVER
			}
			public enum Source {
				CONNECTION,
				SASL,
				TLS,
				STREAM_ERROR
			}
			public string? identifier;
			public Dino.ConnectionManager.ConnectionError.Source source;
			public ConnectionError (Dino.ConnectionManager.ConnectionError.Source source, string? identifier);
			public Dino.ConnectionManager.ConnectionError.Reconnect reconnect_recomendation { get; set; }
		}
		public enum ConnectionState {
			CONNECTED,
			CONNECTING,
			DISCONNECTED
		}
		public string? log_options;
		public ConnectionManager (Dino.ModuleManager module_manager);
		public void connect_account (Dino.Entities.Account account);
		public async void disconnect_account (Dino.Entities.Account account);
		public Dino.ConnectionManager.ConnectionError? get_error (Dino.Entities.Account account);
		public Gee.Collection<Dino.Entities.Account> get_managed_accounts ();
		public Dino.ConnectionManager.ConnectionState get_state (Dino.Entities.Account account);
		public Xmpp.XmppStream? get_stream (Dino.Entities.Account account);
		public void make_offline_all ();
		public signal void connection_error (Dino.Entities.Account account, Dino.ConnectionManager.ConnectionError error);
		public signal void connection_state_changed (Dino.Entities.Account account, Dino.ConnectionManager.ConnectionState state);
		public signal void stream_opened (Dino.Entities.Account account, Xmpp.XmppStream stream);
	}
	[CCode (cheader_filename = "dino.h")]
	public abstract class ContentItem : GLib.Object {
		public static int compare (Dino.ContentItem a, Dino.ContentItem b);
		public GLib.DateTime display_time { get; set; }
		public Dino.Entities.Encryption encryption { get; set; }
		public int id { get; set; }
		public Xmpp.Jid jid { get; set; }
		public Dino.Entities.Message.Marked mark { get; set; }
		public GLib.DateTime sort_time { get; set; }
		public string type_ { get; set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class ContentItemStore : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ContentItemStore> IDENTITY;
		public ContentItemStore (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void add_filter (Dino.ContentFilter content_filter);
		public Gee.List<Dino.ContentItem> get_after (Dino.Entities.Conversation conversation, Dino.ContentItem item, int count);
		public Gee.List<Dino.ContentItem> get_before (Dino.Entities.Conversation conversation, Dino.ContentItem item, int count);
		public Dino.ContentItem? get_item (Dino.Entities.Conversation conversation, int type, int foreign_id);
		public bool get_item_hide (Dino.ContentItem content_item);
		public Gee.List<Dino.ContentItem> get_items_from_query (Qlite.QueryBuilder select, Dino.Entities.Conversation conversation);
		public Dino.ContentItem? get_latest (Dino.Entities.Conversation conversation);
		public Gee.List<Dino.ContentItem> get_n_latest (Dino.Entities.Conversation conversation, int count);
		public void init (Dino.Entities.Conversation conversation, Dino.ContentItemCollection item_collection);
		public void insert_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation, bool hide = false);
		public void set_item_hide (Dino.ContentItem content_item, bool hide);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void uninit (Dino.Entities.Conversation conversation, Dino.ContentItemCollection item_collection);
		public signal void new_item (Dino.ContentItem item, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class ConversationManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.ConversationManager> IDENTITY;
		public void close_conversation (Dino.Entities.Conversation conversation);
		public Dino.Entities.Conversation create_conversation (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Conversation.Type? type = null);
		public Gee.List<Dino.Entities.Conversation> get_active_conversations (Dino.Entities.Account? account = null);
		public Dino.Entities.Conversation? get_conversation (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Conversation.Type? type = null);
		public Dino.Entities.Conversation? get_conversation_by_id (int id);
		public Dino.Entities.Conversation? get_conversation_for_message (Dino.Entities.Message message);
		public Gee.List<Dino.Entities.Conversation> get_conversations (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Dino.Entities.Conversation> get_conversations_for_presence (Dino.Show show, Dino.Entities.Account account);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void start_conversation (Dino.Entities.Conversation conversation);
		public signal void conversation_activated (Dino.Entities.Conversation conversation);
		public signal void conversation_deactivated (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class CounterpartInteractionManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.CounterpartInteractionManager> IDENTITY;
		public Gee.HashMap? get_chat_states (Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void received_marker (Dino.Entities.Account account, Xmpp.Jid jid, Dino.Entities.Message message, Dino.Entities.Message.Marked marker);
		public signal void received_message_displayed (Dino.Entities.Account account, Xmpp.Jid jid, Dino.Entities.Message message);
		public signal void received_message_received (Dino.Entities.Account account, Xmpp.Jid jid, Dino.Entities.Message message);
		public signal void received_state (Dino.Entities.Account account, Xmpp.Jid jid, string state);
	}
	[CCode (cheader_filename = "dino.h")]
	public class Database : Qlite.Database {
		public class AccountTable : Qlite.Table {
			public Qlite.Column<string> alias;
			public Qlite.Column<string> bare_jid;
			public Qlite.Column<bool> enabled;
			public Qlite.Column<int> id;
			public Qlite.Column<long> mam_earliest_synced;
			public Qlite.Column<string> password;
			public Qlite.Column<string> resourcepart;
			public Qlite.Column<string> roster_version;
		}
		public class AvatarTable : Qlite.Table {
			public Qlite.Column<string> hash;
			public Qlite.Column<string> jid;
			public Qlite.Column<int> type_;
		}
		public class ContentItemTable : Qlite.Table {
			public Qlite.Column<int> content_type;
			public Qlite.Column<int> conversation_id;
			public Qlite.Column<int> foreign_id;
			public Qlite.Column<bool> hide;
			public Qlite.Column<int> id;
			public Qlite.Column<long> local_time;
			public Qlite.Column<long> time;
		}
		public class ConversationTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<bool> active;
			public Qlite.Column<int> encryption;
			public Qlite.Column<int> id;
			public Qlite.Column<int> jid_id;
			public Qlite.Column<long> last_active;
			public Qlite.Column<int> notification;
			public Qlite.Column<int> read_up_to;
			public Qlite.Column<string> resource;
			public Qlite.Column<int> send_marker;
			public Qlite.Column<int> send_typing;
			public Qlite.Column<int> type_;
		}
		public class EntityFeatureTable : Qlite.Table {
			public Qlite.Column<string> entity;
			public Qlite.Column<string> feature;
		}
		public class FileTransferTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<int> counterpart_id;
			public Qlite.Column<string> counterpart_resource;
			public Qlite.Column<bool> direction;
			public Qlite.Column<int> encryption;
			public Qlite.Column<string> file_name;
			public Qlite.Column<int> id;
			public Qlite.Column<string> info;
			public Qlite.Column<long> local_time;
			public Qlite.Column<string> mime_type;
			public Qlite.Column<string> our_resource;
			public Qlite.Column<string> path;
			public Qlite.Column<int> provider;
			public Qlite.Column<int> size;
			public Qlite.Column<int> state;
			public Qlite.Column<long> time;
		}
		public class JidTable : Qlite.Table {
			public Qlite.Column<string> bare_jid;
			public Qlite.Column<int> id;
		}
		public class MamCatchupTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<bool> from_end;
			public Qlite.Column<string> from_id;
			public Qlite.Column<long> from_time;
			public Qlite.Column<int> id;
			public Qlite.Column<string> to_id;
			public Qlite.Column<long> to_time;
		}
		public class MessageTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<string> body;
			public Qlite.Column<int> counterpart_id;
			public Qlite.Column<string> counterpart_resource;
			public Qlite.Column<bool> direction;
			public Qlite.Column<int> encryption;
			public Qlite.Column<int> id;
			public Qlite.Column<long> local_time;
			public Qlite.Column<int> marked;
			public Qlite.Column<string> our_resource;
			public Qlite.Column<string> server_id;
			public Qlite.Column<string> stanza_id;
			public Qlite.Column<long> time;
			public Qlite.Column<int> type_;
		}
		public class RealJidTable : Qlite.Table {
			public Qlite.Column<int> message_id;
			public Qlite.Column<string> real_jid;
		}
		public class RosterTable : Qlite.Table {
			public Qlite.Column<int> account_id;
			public Qlite.Column<string> handle;
			public Qlite.Column<string> jid;
			public Qlite.Column<string> subscription;
		}
		public class SettingsTable : Qlite.Table {
			public Qlite.Column<int> id;
			public Qlite.Column<string> key;
			public Qlite.Column<string> value;
		}
		public class UndecryptedTable : Qlite.Table {
			public Qlite.Column<string> data;
			public Qlite.Column<int> message_id;
			public Qlite.Column<int> type_;
		}
		public Gee.Map<int,Dino.Entities.Account> account_table_cache;
		public Gee.Map<int,Xmpp.Jid> jid_table_cache;
		public Gee.Map<Xmpp.Jid,int> jid_table_reverse;
		public Database (string fileName);
		public int add_content_item (Dino.Entities.Conversation conversation, GLib.DateTime time, GLib.DateTime local_time, int content_type, int foreign_id, bool hide);
		public void add_entity_features (string entity, Gee.List<string> features);
		public Dino.Entities.Account? get_account_by_id (int id);
		public Gee.ArrayList<Dino.Entities.Account> get_accounts ();
		public Gee.HashMap<Xmpp.Jid,string> get_avatar_hashes (int type);
		public Gee.ArrayList<Dino.Entities.Conversation> get_conversations (Dino.Entities.Account account);
		public Gee.List<string> get_entity_features (string entity);
		public Xmpp.Jid? get_jid_by_id (int id) throws Xmpp.InvalidJidError;
		public int get_jid_id (Xmpp.Jid jid_obj);
		public Dino.Entities.Message? get_message_by_id (int id);
		public Gee.List<Dino.Entities.Message> get_messages (Xmpp.Jid jid, Dino.Entities.Account account, Dino.Entities.Message.Type? type, int count, GLib.DateTime? before, GLib.DateTime? after, int id);
		public Gee.List<Dino.Entities.Message> get_unsend_messages (Dino.Entities.Account account, Xmpp.Jid? jid = null);
		public override void migrate (long oldVersion);
		public void set_avatar_hash (Xmpp.Jid jid, string hash, int type);
		public Dino.Database.AccountTable account { get; private set; }
		public Dino.Database.AvatarTable avatar { get; private set; }
		public Dino.Database.ContentItemTable content_item { get; private set; }
		public Dino.Database.ConversationTable conversation { get; private set; }
		public Dino.Database.EntityFeatureTable entity_feature { get; private set; }
		public Dino.Database.FileTransferTable file_transfer { get; private set; }
		public Dino.Database.JidTable jid { get; private set; }
		public Dino.Database.MamCatchupTable mam_catchup { get; private set; }
		public Dino.Database.MessageTable message { get; private set; }
		public Dino.Database.RealJidTable real_jid { get; private set; }
		public Dino.Database.RosterTable roster { get; private set; }
		public Dino.Database.SettingsTable settings { get; private set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class EntityCapabilitiesStorage : Xmpp.Xep.EntityCapabilities.Storage, GLib.Object {
		public EntityCapabilitiesStorage (Dino.Database db);
	}
	[CCode (cheader_filename = "dino.h")]
	public class FileItem : Dino.ContentItem {
		public Dino.Entities.Conversation conversation;
		public Dino.Entities.FileTransfer file_transfer;
		public const string TYPE;
		public FileItem (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation, int id, Dino.Entities.Message? message = null);
	}
	[CCode (cheader_filename = "dino.h")]
	public class FileManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.FileManager> IDENTITY;
		public void add_file_decryptor (Dino.FileDecryptor decryptor);
		public void add_file_encryptor (Dino.FileEncryptor encryptor);
		public void add_provider (Dino.FileProvider file_provider);
		public void add_sender (Dino.FileSender file_sender);
		public async void download_file (Dino.Entities.FileTransfer file_transfer);
		public Gee.List<Dino.Entities.FileTransfer> get_latest_transfers (Dino.Entities.Account account, Xmpp.Jid counterpart, int n);
		public static string get_storage_dir ();
		public Gee.List<Dino.Entities.FileTransfer> get_transfers_after (Dino.Entities.Account account, Xmpp.Jid counterpart, GLib.DateTime after, int n);
		public Gee.List<Dino.Entities.FileTransfer> get_transfers_before (Dino.Entities.Account account, Xmpp.Jid counterpart, GLib.DateTime before, int n);
		public bool is_sender_trustworthy (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation);
		public bool is_upload_available (Dino.Entities.Conversation? conversation);
		public async void send_file (string uri, Dino.Entities.Conversation conversation);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void received_file (Dino.Entities.FileTransfer file_transfer, Dino.Entities.Conversation conversation);
		public signal void upload_available (Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "dino.h")]
	public class FileMeta {
		public Dino.Entities.Encryption encryption;
		public string? file_name;
		public string? mime_type;
		public int64 size;
		public FileMeta ();
	}
	[CCode (cheader_filename = "dino.h")]
	public class FileReceiveData {
		public FileReceiveData ();
	}
	[CCode (cheader_filename = "dino.h")]
	public class FileSendData {
		public FileSendData ();
	}
	[CCode (cheader_filename = "dino.h")]
	public class HttpFileMeta : Dino.FileMeta {
		public Dino.Entities.Message message;
		public HttpFileMeta ();
	}
	[CCode (cheader_filename = "dino.h")]
	public class HttpFileReceiveData : Dino.FileReceiveData {
		public HttpFileReceiveData ();
		public string url { get; set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class HttpFileSendData : Dino.FileSendData {
		public HttpFileSendData ();
		public bool encrypt_message { get; set; }
		public Gee.HashMap<string,string> headers { get; set; }
		public string url_down { get; set; }
		public string url_up { get; set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class JingleFileEncryptionHelperTransferOnly : Dino.JingleFileEncryptionHelper, GLib.Object {
		public JingleFileEncryptionHelperTransferOnly ();
	}
	[CCode (cheader_filename = "dino.h")]
	public class JingleFileHelperRegistry {
		public JingleFileHelperRegistry ();
		public void add_encryption_helper (Dino.Entities.Encryption encryption, Dino.JingleFileEncryptionHelper helper);
		public Dino.JingleFileEncryptionHelper? get_encryption_helper (Dino.Entities.Encryption encryption);
		public static Dino.JingleFileHelperRegistry instance { get; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class JingleFileProvider : Dino.FileProvider, GLib.Object {
		public JingleFileProvider (Dino.StreamInteractor stream_interactor);
	}
	[CCode (cheader_filename = "dino.h")]
	public class JingleFileSender : Dino.FileSender, GLib.Object {
		public JingleFileSender (Dino.StreamInteractor stream_interactor);
	}
	[CCode (cheader_filename = "dino.h")]
	public class MessageItem : Dino.ContentItem {
		public Dino.Entities.Conversation conversation;
		public Dino.Entities.Message message;
		public const string TYPE;
		public MessageItem (Dino.Entities.Message message, Dino.Entities.Conversation conversation, int id);
	}
	[CCode (cheader_filename = "dino.h")]
	public abstract class MessageListener : Xmpp.OrderedListener {
		protected MessageListener ();
		public abstract async bool run (Dino.Entities.Message message, Xmpp.MessageStanza stanza, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class MessageListenerHolder : Xmpp.ListenerHolder {
		public MessageListenerHolder ();
		public async bool run (Dino.Entities.Message message, Xmpp.MessageStanza stanza, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class MessageProcessor : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.MessageProcessor> IDENTITY;
		public Gee.HashMap<Dino.Entities.Account,string> catchup_until_id;
		public Gee.HashMap<Dino.Entities.Account,GLib.DateTime> catchup_until_time;
		public Gee.HashMap<string,int> hitted_range;
		public Dino.MessageListenerHolder received_pipeline;
		public Dino.Entities.Message create_out_message (string text, Dino.Entities.Conversation conversation);
		public async Dino.Entities.Message parse_message_stanza (Dino.Entities.Account account, Xmpp.MessageStanza message);
		public Dino.Entities.Message send_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public Dino.Entities.Message send_text (string text, Dino.Entities.Conversation conversation);
		public void send_unsent_messages (Dino.Entities.Account account, Xmpp.Jid? jid = null);
		public void send_xmpp_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation, bool delayed = false);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void build_message_stanza (Dino.Entities.Message message, Xmpp.MessageStanza message_stanza, Dino.Entities.Conversation conversation);
		public signal void history_synced (Dino.Entities.Account account);
		public signal void message_received (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public signal void message_sent (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public signal void pre_message_send (Dino.Entities.Message message, Xmpp.MessageStanza message_stanza, Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class MessageStorage : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.MessageStorage> IDENTITY;
		public void add_message (Dino.Entities.Message message, Dino.Entities.Conversation conversation);
		public Dino.Entities.Conversation? get_conversation_for_stanza_id (Dino.Entities.Account account, string stanza_id);
		public Dino.Entities.Message? get_last_message (Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_by_id (int id, Dino.Entities.Conversation conversation);
		public Dino.Entities.Message? get_message_by_stanza_id (string stanza_id, Dino.Entities.Conversation conversation);
		public Gee.List<Dino.Entities.Message> get_messages (Dino.Entities.Conversation conversation, int count = 50);
		public Gee.List<Dino.MessageItem> get_messages_after_message (Dino.Entities.Conversation? conversation, GLib.DateTime after, int id, int count = 20);
		public Gee.List<Dino.MessageItem> get_messages_before_message (Dino.Entities.Conversation? conversation, GLib.DateTime before, int id, int count = 20);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
	}
	[CCode (cheader_filename = "dino.h")]
	public class ModuleIdentity<T> : GLib.Object {
		public ModuleIdentity (string id);
		public T cast (Dino.StreamInteractionModule module);
		public bool matches (Dino.StreamInteractionModule module);
		public string id { get; private set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class ModuleManager {
		public ModuleManager (Dino.Database db);
		public T get_module<T> (Dino.Entities.Account account, Xmpp.ModuleIdentity<T> identity);
		public Gee.ArrayList<Xmpp.XmppStreamModule> get_modules (Dino.Entities.Account account, string? resource = null);
		public void initialize (Dino.Entities.Account account);
		public signal void initialize_account_modules (Dino.Entities.Account account, Gee.ArrayList<Xmpp.XmppStreamModule> modules);
	}
	[CCode (cheader_filename = "dino.h")]
	public class MucManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.MucManager> IDENTITY;
		public void add_bookmark (Dino.Entities.Account account, Xmpp.Conference conference);
		public void change_affiliation (Dino.Entities.Account account, Xmpp.Jid jid, string nick, string role);
		public void change_nick (Dino.Entities.Account account, Xmpp.Jid jid, string new_nick);
		public void change_subject (Dino.Entities.Account account, Xmpp.Jid jid, string subject);
		public Xmpp.Xep.Muc.Affiliation? get_affiliation (Xmpp.Jid muc_jid, Xmpp.Jid jid, Dino.Entities.Account account);
		public async Gee.Set<Xmpp.Conference>? get_bookmarks (Dino.Entities.Account account);
		public async Xmpp.Xep.DataForms.DataForm? get_config_form (Dino.Entities.Account account, Xmpp.Jid jid);
		public string? get_groupchat_subject (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_occupants (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_offline_members (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_other_occupants (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.List<Xmpp.Jid>? get_other_offline_members (Xmpp.Jid jid, Dino.Entities.Account account);
		public Xmpp.Jid? get_own_jid (Xmpp.Jid muc_jid, Dino.Entities.Account account);
		public Xmpp.Jid? get_real_jid (Xmpp.Jid jid, Dino.Entities.Account account);
		public Xmpp.Xep.Muc.Role? get_role (Xmpp.Jid jid, Dino.Entities.Account account);
		public string? get_room_name (Dino.Entities.Account account, Xmpp.Jid jid);
		public void invite (Dino.Entities.Account account, Xmpp.Jid muc, Xmpp.Jid invitee);
		public bool is_groupchat (Xmpp.Jid jid, Dino.Entities.Account account);
		public bool is_groupchat_occupant (Xmpp.Jid jid, Dino.Entities.Account account);
		public bool is_joined (Xmpp.Jid jid, Dino.Entities.Account account);
		public bool is_private_room (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool is_public_room (Dino.Entities.Account account, Xmpp.Jid jid);
		public async Xmpp.Xep.Muc.JoinResult? join (Dino.Entities.Account account, Xmpp.Jid jid, string? nick, string? password);
		public void kick (Dino.Entities.Account account, Xmpp.Jid jid, string nick);
		public bool kick_possible (Dino.Entities.Account account, Xmpp.Jid occupant);
		public void part (Dino.Entities.Account account, Xmpp.Jid jid);
		public void remove_bookmark (Dino.Entities.Account account, Xmpp.Conference conference);
		public void replace_bookmark (Dino.Entities.Account account, Xmpp.Conference was, Xmpp.Conference replace);
		public void set_config_form (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Xep.DataForms.DataForm data_form);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void bookmarks_updated (Dino.Entities.Account account, Gee.Set<Xmpp.Conference> conferences);
		public signal void conference_added (Dino.Entities.Account account, Xmpp.Conference conference);
		public signal void conference_removed (Dino.Entities.Account account, Xmpp.Jid jid);
		public signal void invite_received (Dino.Entities.Account account, Xmpp.Jid room_jid, Xmpp.Jid from_jid, string? password, string? reason);
		public signal void left (Dino.Entities.Account account, Xmpp.Jid jid);
		public signal void private_room_occupant_updated (Dino.Entities.Account account, Xmpp.Jid room, Xmpp.Jid occupant);
		public signal void room_name_set (Dino.Entities.Account account, Xmpp.Jid jid, string? room_name);
		public signal void subject_set (Dino.Entities.Account account, Xmpp.Jid jid, string? subject);
	}
	[CCode (cheader_filename = "dino.h")]
	public class NotificationEvents : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.NotificationEvents> IDENTITY;
		public NotificationEvents (Dino.StreamInteractor stream_interactor);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void notify_connection_error (Dino.Entities.Account account, Dino.ConnectionManager.ConnectionError error);
		public signal void notify_content_item (Dino.ContentItem content_item, Dino.Entities.Conversation conversation);
		public signal void notify_muc_invite (Dino.Entities.Account account, Xmpp.Jid room_jid, Xmpp.Jid from_jid, string? password, string? reason);
		public signal void notify_subscription_request (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public class PresenceManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.PresenceManager> IDENTITY;
		public void approve_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public void cancel_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public void deny_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public bool exists_subscription_request (Dino.Entities.Account account, Xmpp.Jid jid);
		public Gee.List<Xmpp.Jid>? get_full_jids (Xmpp.Jid jid, Dino.Entities.Account account);
		public Dino.Show get_last_show (Xmpp.Jid jid, Dino.Entities.Account account);
		public Gee.HashMap<Xmpp.Jid,Gee.ArrayList<Dino.Show>>? get_shows (Xmpp.Jid jid, Dino.Entities.Account account);
		public void request_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public static void start (Dino.StreamInteractor stream_interactor);
		public signal void received_subscription_approval (Xmpp.Jid jid, Dino.Entities.Account account);
		public signal void received_subscription_request (Xmpp.Jid jid, Dino.Entities.Account account);
		public signal void show_received (Dino.Show show, Xmpp.Jid jid, Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "dino.h")]
	public class Register : Dino.StreamInteractionModule, GLib.Object {
		public class ServerAvailabilityReturn {
			public ServerAvailabilityReturn ();
			public bool available { get; set; }
			public GLib.TlsCertificateFlags? error_flags { get; set; }
		}
		public static Dino.ModuleIdentity<Dino.Register> IDENTITY;
		public async Dino.ConnectionManager.ConnectionError.Source? add_check_account (Dino.Entities.Account account);
		public static async Dino.Register.ServerAvailabilityReturn check_server_availability (Xmpp.Jid jid);
		public static async Xmpp.Xep.InBandRegistration.Form? get_registration_form (Xmpp.Jid jid);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public static async string? submit_form (Xmpp.Jid jid, Xmpp.Xep.InBandRegistration.Form form);
	}
	[CCode (cheader_filename = "dino.h")]
	public class RosterManager : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.RosterManager> IDENTITY;
		public RosterManager (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public void add_jid (Dino.Entities.Account account, Xmpp.Jid jid, string? handle);
		public Gee.Collection<Xmpp.Roster.Item> get_roster (Dino.Entities.Account account);
		public Xmpp.Roster.Item? get_roster_item (Dino.Entities.Account account, Xmpp.Jid jid);
		public void remove_jid (Dino.Entities.Account account, Xmpp.Jid jid);
		public void set_jid_handle (Dino.Entities.Account account, Xmpp.Jid jid, string? handle);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public signal void mutual_subscription (Dino.Entities.Account account, Xmpp.Jid jid);
		public signal void removed_roster_item (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Roster.Item roster_item);
		public signal void updated_roster_item (Dino.Entities.Account account, Xmpp.Jid jid, Xmpp.Roster.Item roster_item);
	}
	[CCode (cheader_filename = "dino.h")]
	public class RosterStoreImpl : Xmpp.Roster.Storage, GLib.Object {
		public RosterStoreImpl (Dino.Entities.Account account, Dino.Database db);
		public Xmpp.Roster.Item? get_item (Xmpp.Jid jid);
	}
	[CCode (cheader_filename = "dino.h")]
	public class SearchPathGenerator {
		public SearchPathGenerator (string? exec_path);
		public string get_locale_path (string gettext_package, string locale_install_dir);
		public string[] get_plugin_paths ();
		public string? exec_path { get; private set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class SearchProcessor : Dino.StreamInteractionModule, GLib.Object {
		public static Dino.ModuleIdentity<Dino.SearchProcessor> IDENTITY;
		public SearchProcessor (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public int count_match_messages (string query);
		public Gee.List<Dino.MessageItem> match_messages (string query, int offset = -1);
		public static void start (Dino.StreamInteractor stream_interactor, Dino.Database db);
		public Gee.List<Dino.SearchSuggestion> suggest_auto_complete (string query, int cursor_position, int limit = 5);
	}
	[CCode (cheader_filename = "dino.h")]
	public class SearchSuggestion : GLib.Object {
		public SearchSuggestion (Dino.Entities.Conversation conversation, Xmpp.Jid? jid, string completion, int start_index, int end_index);
		public Dino.Entities.Account account { get; }
		public string completion { get; private set; }
		public Dino.Entities.Conversation conversation { get; private set; }
		public int end_index { get; private set; }
		public Xmpp.Jid? jid { get; private set; }
		public long order { get; set; }
		public int start_index { get; private set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public class Show : GLib.Object {
		public string @as;
		public GLib.DateTime datetime;
		public Xmpp.Jid jid;
		public const string AWAY;
		public const string CHAT;
		public const string DND;
		public const string OFFLINE;
		public const string ONLINE;
		public const string XA;
		public Show (Xmpp.Jid jid, string show, GLib.DateTime datetime);
	}
	[CCode (cheader_filename = "dino.h")]
	public class StreamInteractor : GLib.Object {
		public Dino.ConnectionManager connection_manager;
		public Dino.ModuleManager module_manager;
		public StreamInteractor (Dino.Database db);
		public void add_module (Dino.StreamInteractionModule module);
		public void connect_account (Dino.Entities.Account account);
		public async void disconnect_account (Dino.Entities.Account account);
		public new T @get<T> ();
		public Gee.ArrayList<Dino.Entities.Account> get_accounts ();
		public T get_module<T> (Dino.ModuleIdentity<T>? identity);
		public Xmpp.XmppStream? get_stream (Dino.Entities.Account account);
		public signal void account_added (Dino.Entities.Account account);
		public signal void account_removed (Dino.Entities.Account account);
		public signal void attached_modules (Dino.Entities.Account account, Xmpp.XmppStream stream);
		public signal void stream_negotiated (Dino.Entities.Account account, Xmpp.XmppStream stream);
	}
	[CCode (cheader_filename = "dino.h")]
	public class Util {
		public Util ();
		public static Dino.Entities.Message.Type get_message_type_for_conversation (Dino.Entities.Conversation conversation);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface Application : GLib.Application {
		protected void add_connection (Dino.Entities.Account account);
		public void create_actions ();
		public static unowned Dino.Application get_default ();
		public static string get_storage_dir ();
		public abstract void handle_uri (string jid, string query, Gee.Map<string,string> options);
		public void init () throws GLib.Error;
		protected void remove_connection (Dino.Entities.Account account);
		public abstract Dino.Database db { get; set; }
		public abstract Dino.Plugins.Registry plugin_registry { get; set; }
		public abstract Dino.SearchPathGenerator? search_path_generator { get; set; }
		public abstract Dino.Entities.Settings settings { get; set; }
		public abstract Dino.StreamInteractor stream_interactor { get; set; }
	}
	[CCode (cheader_filename = "dino.h")]
	public interface ContentFilter : GLib.Object {
		public abstract bool discard (Dino.ContentItem content_item);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface ContentItemCollection : GLib.Object {
		public abstract void insert_item (Dino.ContentItem item);
		public abstract void remove_item (Dino.ContentItem item);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface FileDecryptor : GLib.Object {
		public abstract bool can_decrypt_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data);
		public abstract async GLib.InputStream decrypt_file (GLib.InputStream encrypted_stream, Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data) throws Dino.FileReceiveError;
		public abstract Dino.FileMeta prepare_download_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta);
		public abstract Dino.FileReceiveData prepare_get_meta_info (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface FileEncryptor : GLib.Object {
		public abstract bool can_encrypt_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract Dino.FileMeta encrypt_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer) throws Dino.FileSendError;
		public abstract Dino.FileSendData? preprocess_send_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileSendData file_send_data, Dino.FileMeta file_meta) throws Dino.FileSendError;
	}
	[CCode (cheader_filename = "dino.h")]
	public interface FileProvider : GLib.Object {
		public abstract async GLib.InputStream download (Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta) throws Dino.FileReceiveError;
		public abstract Dino.FileMeta get_file_meta (Dino.Entities.FileTransfer file_transfer) throws Dino.FileReceiveError;
		public abstract Dino.FileReceiveData? get_file_receive_data (Dino.Entities.FileTransfer file_transfer);
		public abstract int get_id ();
		public abstract async Dino.FileMeta get_meta_info (Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta) throws Dino.FileReceiveError;
		public signal void file_incoming (string info, Xmpp.Jid from, GLib.DateTime time, GLib.DateTime local_time, Dino.Entities.Conversation conversation, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface FileSender : GLib.Object {
		public abstract bool can_encrypt (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract bool can_send (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract int get_id ();
		public abstract float get_priority ();
		public abstract bool is_upload_available (Dino.Entities.Conversation conversation);
		public abstract async Dino.FileSendData? prepare_send_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileMeta file_meta) throws Dino.FileSendError;
		public abstract async void send_file (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Dino.FileSendData file_send_data, Dino.FileMeta file_meta) throws Dino.FileSendError;
		public signal void upload_available (Dino.Entities.Account account);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface JingleFileEncryptionHelper : GLib.Object {
		public abstract bool can_encrypt (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer, Xmpp.Jid? full_jid = null);
		public abstract bool can_transfer (Dino.Entities.Conversation conversation);
		public abstract Dino.FileMeta complete_meta (Dino.Entities.FileTransfer file_transfer, Dino.FileReceiveData receive_data, Dino.FileMeta file_meta, Xmpp.Xep.JingleFileTransfer.FileTransfer jingle_transfer);
		public abstract string? get_precondition_name (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
		public abstract GLib.Object? get_precondition_options (Dino.Entities.Conversation conversation, Dino.Entities.FileTransfer file_transfer);
	}
	[CCode (cheader_filename = "dino.h")]
	[DBus (name = "org.freedesktop.login1.Manager")]
	public interface Login1Manager : GLib.Object {
		public signal void PrepareForSleep (bool suspend);
	}
	[CCode (cheader_filename = "dino.h")]
	public interface StreamInteractionModule : GLib.Object {
		public abstract string id { get; }
	}
	[CCode (cheader_filename = "dino.h")]
	[DBus (name = "org.freedesktop.UPower")]
	public interface UPower : GLib.Object {
		public signal void Resuming ();
		public signal void Sleeping ();
	}
	[CCode (cheader_filename = "dino.h")]
	public errordomain FileReceiveError {
		GET_METADATA_FAILED,
		DECRYPTION_FAILED,
		DOWNLOAD_FAILED
	}
	[CCode (cheader_filename = "dino.h")]
	public errordomain FileSendError {
		ENCRYPTION_FAILED,
		UPLOAD_FAILED,
		SAVE_FAILED
	}
	[CCode (cheader_filename = "dino_i18n.h", cname = "dino_gettext")]
	public static unowned string _ (string s);
	[CCode (cheader_filename = "dino.h")]
	public static Dino.Login1Manager? get_login1 ();
	[CCode (cheader_filename = "dino.h")]
	public static string get_storage_dir ();
	[CCode (cheader_filename = "dino.h")]
	public static Dino.UPower? get_upower ();
	[CCode (cheader_filename = "dino.h")]
	public static void internationalize (string gettext_package, string locales_dir);
	[CCode (cheader_filename = "dino_i18n.h", cname = "dino_ngettext")]
	public static unowned string n (string msgid, string plural, ulong number);
}
