/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.abort;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.abort.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryAbort
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String messageAbort;

    public JobEntryAbort(String n, String scr) {
        super(n, "");
        this.messageAbort = null;
        this.setJobEntryType(JobEntryType.ABORT);
    }

    public JobEntryAbort() {
        this("", "");
    }

    public JobEntryAbort(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryAbort je = (JobEntryAbort)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"message", (String)this.messageAbort));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.messageAbort = XMLHandler.getTagValue((Node)entrynode, (String)"message");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobEntryAbort.UnableToLoadFromXml.Label"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.messageAbort = rep.getJobEntryAttributeString(id_jobentry, "message");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryAbort.UnableToLoadFromRepo.Label", String.valueOf(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "message", this.messageAbort);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryAbort.UnableToSaveToRepo.Label", String.valueOf(id_job)), (Throwable)dbe);
        }
    }

    public boolean evaluate(Result result) {
        LogWriter log = LogWriter.getInstance();
        String Returnmessage = null;
        String RealMessageabort = this.environmentSubstitute(this.getMessageabort());
        try {
            Returnmessage = RealMessageabort == null ? Messages.getString("JobEntryAbort.Meta.CheckResult.Label") : RealMessageabort;
            log.logError(this.toString(), Returnmessage, new Object[0]);
            result.setNrErrors(1L);
            return false;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            log.logError(this.toString(), Messages.getString("JobEntryAbort.Meta.CheckResult.CouldNotExecute") + e.toString(), new Object[0]);
            return false;
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        previousResult.setResult(this.evaluate(previousResult));
        parentJob.stopAll();
        return previousResult;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    public void setMessageabort(String messageabort) {
        this.messageAbort = messageabort;
    }

    public String getMessageabort() {
        return this.messageAbort;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.addOkRemark(this, "messageabort", remarks);
    }
}

