/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.di.trans.steps.fieldsplitter.Messages;

public class FieldSplitter
extends BaseStep
implements StepInterface {
    private FieldSplitterMeta meta;
    private FieldSplitterData data;

    public FieldSplitter(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] splitField(Object[] r) throws KettleValueException {
        int i;
        if (this.first) {
            this.first = false;
            this.data.previousMeta = this.getInputRowMeta().clone();
            this.data.fieldnr = this.data.previousMeta.indexOfValue(this.meta.getSplitField());
            if (this.data.fieldnr < 0) {
                throw new KettleValueException(Messages.getString("FieldSplitter.Log.CouldNotFindFieldToSplit", this.meta.getSplitField()));
            }
            if (!this.data.previousMeta.getValueMeta(this.data.fieldnr).isString()) {
                throw new KettleValueException(Messages.getString("FieldSplitter.Log.SplitFieldNotValid", this.meta.getSplitField()));
            }
            this.data.outputMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputMeta, this.getStepname(), null, null, this);
            this.data.conversionMeta = this.data.outputMeta.clone();
            for (ValueMetaInterface valueMeta : this.data.conversionMeta.getValueMetaList()) {
                valueMeta.setType(2);
            }
            this.data.delimiter = this.environmentSubstitute(this.meta.getDelimiter());
        }
        String v = this.data.previousMeta.getString(r, this.data.fieldnr);
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputMeta.size());
        int nrExtraFields = this.meta.getFieldID().length - 1;
        for (i = 0; i < this.data.fieldnr; ++i) {
            outputRow[i] = r[i];
        }
        for (i = this.data.fieldnr + 1; i < this.data.previousMeta.size(); ++i) {
            outputRow[i + nrExtraFields] = r[i];
        }
        boolean use_ids = this.meta.getFieldID().length > 0 && this.meta.getFieldID()[0] != null && this.meta.getFieldID()[0].length() > 0;
        Object value = null;
        if (use_ids) {
            int i2;
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("FieldSplitter.Log.UsingIds"));
            }
            int polSize = 0;
            if (v != null) {
                ++polSize;
                for (int i3 = 0; i3 < v.length() && (i3 = v.indexOf(this.data.delimiter, i3)) != -1; ++i3) {
                    ++polSize;
                }
            }
            String[] pol = new String[polSize];
            int prev = 0;
            for (i2 = 0; v != null && prev < v.length() && i2 < pol.length; prev += pol[i2].length() + this.data.delimiter.length(), ++i2) {
                pol[i2] = FieldSplitter.polNext(v, this.data.delimiter, prev);
                if (!this.log.isDebug()) continue;
                this.logDebug(Messages.getString("FieldSplitter.Log.SplitFieldsInfo", pol[i2], String.valueOf(prev)));
            }
            for (i2 = 0; i2 < this.meta.getFieldName().length; ++i2) {
                String split = null;
                for (int p = 0; p < pol.length && split == null; ++p) {
                    if (pol[p] == null || Const.trimToType((String)pol[p], (int)this.meta.getFieldTrimType()[i2]).indexOf(this.meta.getFieldID()[i2]) != 0) continue;
                    split = pol[p];
                }
                if (split != null && this.meta.getFieldRemoveID()[i2]) {
                    StringBuilder sb = new StringBuilder(split);
                    int idx = sb.indexOf(this.meta.getFieldID()[i2]);
                    sb.delete(idx, idx + this.meta.getFieldID()[i2].length());
                    split = sb.toString();
                }
                if (split == null) {
                    split = "";
                }
                if (this.log.isDebug()) {
                    this.logDebug(Messages.getString("FieldSplitter.Log.SplitInfo") + split);
                }
                try {
                    ValueMetaInterface valueMeta = this.data.outputMeta.getValueMeta(this.data.fieldnr + i2);
                    ValueMetaInterface conversionValueMeta = this.data.conversionMeta.getValueMeta(this.data.fieldnr + i2);
                    value = valueMeta.convertDataFromString(split, conversionValueMeta, this.meta.getFieldNullIf()[i2], this.meta.getFieldIfNull()[i2], this.meta.getFieldTrimType()[i2]);
                }
                catch (Exception e) {
                    throw new KettleValueException(Messages.getString("FieldSplitter.Log.ErrorConvertingSplitValue", split, this.meta.getSplitField() + "]!"), (Throwable)e);
                }
                outputRow[this.data.fieldnr + i2] = value;
            }
        } else {
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("FieldSplitter.Log.UsingPositionOfValue"));
            }
            int prev = 0;
            for (int i4 = 0; i4 < this.meta.getFieldName().length; ++i4) {
                String pol = FieldSplitter.polNext(v, this.data.delimiter, prev);
                if (this.log.isDebug()) {
                    this.logDebug(Messages.getString("FieldSplitter.Log.SplitFieldsInfo", pol, String.valueOf(prev)));
                }
                prev += (pol == null ? 0 : pol.length()) + this.data.delimiter.length();
                try {
                    ValueMetaInterface valueMeta = this.data.outputMeta.getValueMeta(this.data.fieldnr + i4);
                    ValueMetaInterface conversionValueMeta = this.data.conversionMeta.getValueMeta(this.data.fieldnr + i4);
                    value = valueMeta.convertDataFromString(pol, conversionValueMeta, this.meta.getFieldNullIf()[i4], this.meta.getFieldIfNull()[i4], this.meta.getFieldTrimType()[i4]);
                }
                catch (Exception e) {
                    throw new KettleValueException(Messages.getString("FieldSplitter.Log.ErrorConvertingSplitValue", pol, this.meta.getSplitField() + "]!"), (Throwable)e);
                }
                outputRow[this.data.fieldnr + i4] = value;
            }
        }
        return outputRow;
    }

    private static final String polNext(String str, String del, int start) {
        if (str == null || start >= str.length()) {
            return "";
        }
        int next = str.indexOf(del, start);
        String retval = next == start ? "" : (next > start ? str.substring(start, next) : str.substring(start));
        return retval;
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        Object[] outputRowData = this.splitField(r);
        this.putRow(this.data.outputMeta, outputRowData);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("FieldSplitter.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

