// Unfortunately this list is manually maintained as there's no (nice) automated way to get
// data from Azure.

export const locationMetadata = [
  {
    location: 'eastus',
    displayName: 'East US',
    supportsLogs: true,
  },
  {
    location: 'eastus2',
    displayName: 'East US 2',
    supportsLogs: true,
  },
  {
    location: 'southcentralus',
    displayName: 'South Central US',
    supportsLogs: true,
  },
  {
    location: 'westus2',
    displayName: 'West US 2',
    supportsLogs: true,
  },
  {
    location: 'westus3',
    displayName: 'West US 3',
    supportsLogs: true,
  },
  {
    location: 'australiaeast',
    displayName: 'Australia East',
    supportsLogs: true,
  },
  {
    location: 'southeastasia',
    displayName: 'Southeast Asia',
    supportsLogs: true,
  },
  {
    location: 'northeurope',
    displayName: 'North Europe',
    supportsLogs: true,
  },
  {
    location: 'uksouth',
    displayName: 'UK South',
    supportsLogs: true,
  },
  {
    location: 'westeurope',
    displayName: 'West Europe',
    supportsLogs: true,
  },
  {
    location: 'centralus',
    displayName: 'Central US',
    supportsLogs: true,
  },
  {
    location: 'northcentralus',
    displayName: 'North Central US',
    supportsLogs: true,
  },
  {
    location: 'westus',
    displayName: 'West US',
    supportsLogs: true,
  },
  {
    location: 'southafricanorth',
    displayName: 'South Africa North',
    supportsLogs: true,
  },
  {
    location: 'centralindia',
    displayName: 'Central India',
    supportsLogs: true,
  },
  {
    location: 'eastasia',
    displayName: 'East Asia',
    supportsLogs: true,
  },
  {
    location: 'japaneast',
    displayName: 'Japan East',
    supportsLogs: true,
  },
  {
    location: 'jioindiawest',
    displayName: 'Jio India West',
    supportsLogs: true,
  },
  {
    location: 'koreacentral',
    displayName: 'Korea Central',
    supportsLogs: true,
  },
  {
    location: 'canadacentral',
    displayName: 'Canada Central',
    supportsLogs: true,
  },
  {
    location: 'francecentral',
    displayName: 'France Central',
    supportsLogs: true,
  },
  {
    location: 'germanywestcentral',
    displayName: 'Germany West Central',
    supportsLogs: true,
  },
  {
    location: 'norwayeast',
    displayName: 'Norway East',
    supportsLogs: true,
  },
  {
    location: 'switzerlandnorth',
    displayName: 'Switzerland North',
    supportsLogs: true,
  },
  {
    location: 'uaenorth',
    displayName: 'UAE North',
    supportsLogs: true,
  },
  {
    location: 'brazilsouth',
    displayName: 'Brazil South',
    supportsLogs: true,
  },
  {
    location: 'centralusstage',
    displayName: 'Central US (Stage)',
    supportsLogs: true,
  },
  {
    location: 'eastusstage',
    displayName: 'East US (Stage)',
    supportsLogs: true,
  },
  {
    location: 'eastus2stage',
    displayName: 'East US 2 (Stage)',
    supportsLogs: true,
  },
  {
    location: 'northcentralusstage',
    displayName: 'North Central US (Stage)',
    supportsLogs: true,
  },
  {
    location: 'southcentralusstage',
    displayName: 'South Central US (Stage)',
    supportsLogs: true,
  },
  {
    location: 'westusstage',
    displayName: 'West US (Stage)',
    supportsLogs: true,
  },
  {
    location: 'westus2stage',
    displayName: 'West US 2 (Stage)',
    supportsLogs: true,
  },
  {
    location: 'asia',
    displayName: 'Asia',
    supportsLogs: true,
  },
  {
    location: 'asiapacific',
    displayName: 'Asia Pacific',
    supportsLogs: true,
  },
  {
    location: 'australia',
    displayName: 'Australia',
    supportsLogs: true,
  },
  {
    location: 'brazil',
    displayName: 'Brazil',
    supportsLogs: true,
  },
  {
    location: 'canada',
    displayName: 'Canada',
    supportsLogs: true,
  },
  {
    location: 'europe',
    displayName: 'Europe',
    supportsLogs: true,
  },
  {
    location: 'global',
    displayName: 'Global',
    supportsLogs: true,
  },
  {
    location: 'india',
    displayName: 'India',
    supportsLogs: true,
  },
  {
    location: 'japan',
    displayName: 'Japan',
    supportsLogs: true,
  },
  {
    location: 'uk',
    displayName: 'United Kingdom',
    supportsLogs: true,
  },
  {
    location: 'unitedstates',
    displayName: 'United States',
    supportsLogs: true,
  },
  {
    location: 'eastasiastage',
    displayName: 'East Asia (Stage)',
    supportsLogs: true,
  },
  {
    location: 'southeastasiastage',
    displayName: 'Southeast Asia (Stage)',
    supportsLogs: true,
  },
  {
    location: 'westcentralus',
    displayName: 'West Central US',
    supportsLogs: true,
  },
  {
    location: 'southafricawest',
    displayName: 'South Africa West',
    supportsLogs: true,
  },
  {
    location: 'australiacentral',
    displayName: 'Australia Central',
    supportsLogs: true,
  },
  {
    location: 'australiacentral2',
    displayName: 'Australia Central 2',
    supportsLogs: true,
  },
  {
    location: 'australiasoutheast',
    displayName: 'Australia Southeast',
    supportsLogs: true,
  },
  {
    location: 'japanwest',
    displayName: 'Japan West',
    supportsLogs: true,
  },
  {
    location: 'koreasouth',
    displayName: 'Korea South',
    supportsLogs: true,
  },
  {
    location: 'southindia',
    displayName: 'South India',
    supportsLogs: true,
  },
  {
    location: 'westindia',
    displayName: 'West India',
    supportsLogs: true,
  },
  {
    location: 'canadaeast',
    displayName: 'Canada East',
    supportsLogs: true,
  },
  {
    location: 'francesouth',
    displayName: 'France South',
    supportsLogs: true,
  },
  {
    location: 'germanynorth',
    displayName: 'Germany North',
    supportsLogs: true,
  },
  {
    location: 'norwaywest',
    displayName: 'Norway West',
    supportsLogs: true,
  },
  {
    location: 'switzerlandwest',
    displayName: 'Switzerland West',
    supportsLogs: true,
  },
  {
    location: 'ukwest',
    displayName: 'UK West',
    supportsLogs: true,
  },
  {
    location: 'uaecentral',
    displayName: 'UAE Central',
    supportsLogs: true,
  },
  {
    location: 'brazilsoutheast',
    displayName: 'Brazil Southeast',
    supportsLogs: true,
  },
  {
    location: 'chinaeast',
    displayName: 'China Eest',
    supportsLogs: true,
  },
  {
    location: 'chinaeast2',
    displayName: 'China Eest 2',
    supportsLogs: true,
  },
  {
    location: 'chinanorth',
    displayName: 'China North',
    supportsLogs: true,
  },
  {
    location: 'chinanorth2',
    displayName: 'China North 2',
    supportsLogs: true,
  },
  {
    location: 'chinanorth3',
    displayName: 'China North 3',
    supportsLogs: true,
  },
];

export const logsSupportedLocationsKusto = locationMetadata
  .filter((v) => v.supportsLogs)
  .map((v) => `"${v.location}"`)
  .join(',');

// Object, keyed by location ID
export const locationDisplayNames: Record<string, string> = locationMetadata.reduce(
  (acc, location) => ({
    ...acc,
    [location.location]: location.displayName,
  }),
  {}
);
