/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;

class ExpireJob
extends JobImpl {
    private final PooledTunnelCreatorConfig _cfg;
    private final AtomicBoolean _leaseUpdated = new AtomicBoolean(false);
    private final long _dropAfter;
    private static final long OB_EARLY_EXPIRE = 30000L;
    private static final long IB_EARLY_EXPIRE = 37500L;

    public ExpireJob(RouterContext ctx, PooledTunnelCreatorConfig cfg) {
        super(ctx);
        this._cfg = cfg;
        long expire = cfg.getExpiration();
        if (cfg.getTunnelPool().getSettings().isInbound()) {
            this._dropAfter = expire + 120000L;
            expire -= 37500L + ctx.random().nextLong(37500L);
        } else {
            this._dropAfter = expire + 60000L;
            expire -= 30000L + ctx.random().nextLong(30000L);
        }
        cfg.setExpiration(expire);
        this.getTiming().setStartAfter(expire);
    }

    @Override
    public String getName() {
        return "Expire our tunnel";
    }

    @Override
    public void runJob() {
        if (this._leaseUpdated.compareAndSet(false, true)) {
            TunnelPool pool = this._cfg.getTunnelPool();
            pool.removeTunnel(this._cfg);
            pool.refreshLeaseSet();
            long timeToDrop = this._dropAfter - this.getContext().clock().now();
            this.requeue(timeToDrop);
        } else {
            this.getContext().tunnelDispatcher().remove(this._cfg);
        }
    }
}

