/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendAnnotation;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdNioBackend;
import org.rrd4j.core.RrdSyncThreadPool;

@RrdBackendAnnotation(name="NIO", shouldValidateHeader=true)
public class RrdNioBackendFactory
extends RrdFileBackendFactory {
    public static final int DEFAULT_SYNC_PERIOD = 300;
    private static int defaultSyncPeriod = 300;
    public static final int DEFAULT_SYNC_CORE_POOL_SIZE = 6;
    private static int defaultSyncPoolSize = 6;
    private final int syncPeriod;
    private RrdSyncThreadPool syncThreadPool;

    public static int getSyncPeriod() {
        return defaultSyncPeriod;
    }

    public static void setSyncPeriod(int syncPeriod) {
        defaultSyncPeriod = syncPeriod;
    }

    public static int getSyncPoolSize() {
        return defaultSyncPoolSize;
    }

    public static void setSyncPoolSize(int syncPoolSize) {
        defaultSyncPoolSize = syncPoolSize;
    }

    public RrdNioBackendFactory() {
        this(defaultSyncPeriod, defaultSyncPeriod > 0 ? DefaultSyncThreadPool.INSTANCE : null);
    }

    public RrdNioBackendFactory(int syncPeriod) {
        this(syncPeriod, syncPeriod > 0 ? DefaultSyncThreadPool.INSTANCE : null);
    }

    public RrdNioBackendFactory(int syncPeriod, int syncPoolSize) {
        this(syncPeriod, syncPoolSize > 0 ? new RrdSyncThreadPool(syncPoolSize) : null);
    }

    public RrdNioBackendFactory(int syncPeriod, ScheduledExecutorService syncThreadPool) {
        this(syncPeriod, syncThreadPool != null ? new RrdSyncThreadPool(syncThreadPool) : null);
    }

    public RrdNioBackendFactory(int syncPeriod, RrdSyncThreadPool syncThreadPool) {
        if (syncThreadPool != null && syncPeriod < 0) {
            throw new IllegalArgumentException("Both thread pool defined and negative sync period");
        }
        this.syncPeriod = syncPeriod;
        this.syncThreadPool = syncThreadPool;
    }

    @Deprecated
    public void setSyncThreadPool(RrdSyncThreadPool syncThreadPool) {
        this.syncThreadPool = syncThreadPool;
    }

    @Deprecated
    public void setSyncThreadPool(ScheduledExecutorService syncThreadPool) {
        this.syncThreadPool = new RrdSyncThreadPool(syncThreadPool);
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdNioBackend(path, readOnly, this.syncThreadPool, this.syncPeriod);
    }

    public RrdSyncThreadPool getSyncThreadPool() {
        return this.syncThreadPool;
    }

    @Override
    public void close() throws IOException {
        if (this.syncThreadPool != null) {
            this.syncThreadPool.shutdown();
        }
    }

    static /* synthetic */ int access$000() {
        return defaultSyncPoolSize;
    }

    private static class DefaultSyncThreadPool {
        static final RrdSyncThreadPool INSTANCE = new RrdSyncThreadPool(RrdNioBackendFactory.access$000());

        private DefaultSyncThreadPool() {
        }
    }
}

