/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugUtilsObjectNameInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECTHANDLE;
    public static final int POBJECTNAME;

    public VkDebugUtilsObjectNameInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDebugUtilsObjectNameInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugUtilsObjectNameInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugUtilsObjectNameInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkObjectType")
    public int objectType() {
        return VkDebugUtilsObjectNameInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long objectHandle() {
        return VkDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public ByteBuffer pObjectName() {
        return VkDebugUtilsObjectNameInfoEXT.npObjectName(this.address());
    }

    @Nullable
    @NativeType(value="char const *")
    public String pObjectNameString() {
        return VkDebugUtilsObjectNameInfoEXT.npObjectNameString(this.address());
    }

    public VkDebugUtilsObjectNameInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugUtilsObjectNameInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectNameInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugUtilsObjectNameInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectNameInfoEXT objectType(@NativeType(value="VkObjectType") int value) {
        VkDebugUtilsObjectNameInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectNameInfoEXT objectHandle(@NativeType(value="uint64_t") long value) {
        VkDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectNameInfoEXT pObjectName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
        VkDebugUtilsObjectNameInfoEXT.npObjectName(this.address(), value);
        return this;
    }

    public VkDebugUtilsObjectNameInfoEXT set(int sType, long pNext, int objectType, long objectHandle, @Nullable ByteBuffer pObjectName) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.objectHandle(objectHandle);
        this.pObjectName(pObjectName);
        return this;
    }

    public VkDebugUtilsObjectNameInfoEXT set(VkDebugUtilsObjectNameInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDebugUtilsObjectNameInfoEXT malloc() {
        return (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDebugUtilsObjectNameInfoEXT calloc() {
        return (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDebugUtilsObjectNameInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDebugUtilsObjectNameInfoEXT create(long address) {
        return (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkDebugUtilsObjectNameInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDebugUtilsObjectNameInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugUtilsObjectNameInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDebugUtilsObjectNameInfoEXT mallocStack() {
        return VkDebugUtilsObjectNameInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsObjectNameInfoEXT callocStack() {
        return VkDebugUtilsObjectNameInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkDebugUtilsObjectNameInfoEXT mallocStack(MemoryStack stack) {
        return (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugUtilsObjectNameInfoEXT callocStack(MemoryStack stack) {
        return (VkDebugUtilsObjectNameInfoEXT)VkDebugUtilsObjectNameInfoEXT.wrap(VkDebugUtilsObjectNameInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDebugUtilsObjectNameInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDebugUtilsObjectNameInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugUtilsObjectNameInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static long nobjectHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)OBJECTHANDLE);
    }

    @Nullable
    public static ByteBuffer npObjectName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)POBJECTNAME)));
    }

    @Nullable
    public static String npObjectNameString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)POBJECTNAME)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    public static void nobjectHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OBJECTHANDLE, value);
    }

    public static void npObjectName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)POBJECTNAME), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    static {
        Struct.Layout layout = VkDebugUtilsObjectNameInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkDebugUtilsObjectNameInfoEXT.__member((int)4), VkDebugUtilsObjectNameInfoEXT.__member((int)POINTER_SIZE), VkDebugUtilsObjectNameInfoEXT.__member((int)4), VkDebugUtilsObjectNameInfoEXT.__member((int)8), VkDebugUtilsObjectNameInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECTHANDLE = layout.offsetof(3);
        POBJECTNAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDebugUtilsObjectNameInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugUtilsObjectNameInfoEXT ELEMENT_FACTORY = VkDebugUtilsObjectNameInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDebugUtilsObjectNameInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugUtilsObjectNameInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugUtilsObjectNameInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkObjectType")
        public int objectType() {
            return VkDebugUtilsObjectNameInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long objectHandle() {
            return VkDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public ByteBuffer pObjectName() {
            return VkDebugUtilsObjectNameInfoEXT.npObjectName(this.address());
        }

        @Nullable
        @NativeType(value="char const *")
        public String pObjectNameString() {
            return VkDebugUtilsObjectNameInfoEXT.npObjectNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugUtilsObjectNameInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugUtilsObjectNameInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="VkObjectType") int value) {
            VkDebugUtilsObjectNameInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer objectHandle(@NativeType(value="uint64_t") long value) {
            VkDebugUtilsObjectNameInfoEXT.nobjectHandle(this.address(), value);
            return this;
        }

        public Buffer pObjectName(@Nullable @NativeType(value="char const *") ByteBuffer value) {
            VkDebugUtilsObjectNameInfoEXT.npObjectName(this.address(), value);
            return this;
        }
    }
}

