/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMDebugInfo {
    public static final int LLVMDIFlagZero = 0;
    public static final int LLVMDIFlagPrivate = 1;
    public static final int LLVMDIFlagProtected = 2;
    public static final int LLVMDIFlagPublic = 3;
    public static final int LLVMDIFlagFwdDecl = 4;
    public static final int LLVMDIFlagAppleBlock = 8;
    public static final int LLVMDIFlagBlockByrefStruct = 16;
    public static final int LLVMDIFlagVirtual = 32;
    public static final int LLVMDIFlagArtificial = 64;
    public static final int LLVMDIFlagExplicit = 128;
    public static final int LLVMDIFlagPrototyped = 256;
    public static final int LLVMDIFlagObjcClassComplete = 512;
    public static final int LLVMDIFlagObjectPointer = 1024;
    public static final int LLVMDIFlagVector = 2048;
    public static final int LLVMDIFlagStaticMember = 4096;
    public static final int LLVMDIFlagLValueReference = 8192;
    public static final int LLVMDIFlagRValueReference = 16384;
    public static final int LLVMDIFlagReserved = 32768;
    public static final int LLVMDIFlagSingleInheritance = 65536;
    public static final int LLVMDIFlagMultipleInheritance = 131072;
    public static final int LLVMDIFlagVirtualInheritance = 196608;
    public static final int LLVMDIFlagIntroducedVirtual = 262144;
    public static final int LLVMDIFlagBitField = 524288;
    public static final int LLVMDIFlagNoReturn = 0x100000;
    public static final int LLVMDIFlagMainSubprogram = 0x200000;
    public static final int LLVMDIFlagTypePassByValue = 0x400000;
    public static final int LLVMDIFlagTypePassByReference = 0x800000;
    public static final int LLVMDIFlagEnumClass = 0x1000000;
    public static final int LLVMDIFlagFixedEnum = 0x1000000;
    public static final int LLVMDIFlagThunk = 0x2000000;
    public static final int LLVMDIFlagTrivial = 0x4000000;
    public static final int LLVMDIFlagBigEndian = 0x8000000;
    public static final int LLVMDIFlagLittleEndian = 0x10000000;
    public static final int LLVMDIFlagIndirectVirtualBase = 36;
    public static final int LLVMDIFlagAccessibility = 3;
    public static final int LLVMDIFlagPtrToMemberRep = 196608;
    public static final int LLVMDWARFSourceLanguageC89 = 0;
    public static final int LLVMDWARFSourceLanguageC = 1;
    public static final int LLVMDWARFSourceLanguageAda83 = 2;
    public static final int LLVMDWARFSourceLanguageC_plus_plus = 3;
    public static final int LLVMDWARFSourceLanguageCobol74 = 4;
    public static final int LLVMDWARFSourceLanguageCobol85 = 5;
    public static final int LLVMDWARFSourceLanguageFortran77 = 6;
    public static final int LLVMDWARFSourceLanguageFortran90 = 7;
    public static final int LLVMDWARFSourceLanguagePascal83 = 8;
    public static final int LLVMDWARFSourceLanguageModula2 = 9;
    public static final int LLVMDWARFSourceLanguageJava = 10;
    public static final int LLVMDWARFSourceLanguageC99 = 11;
    public static final int LLVMDWARFSourceLanguageAda95 = 12;
    public static final int LLVMDWARFSourceLanguageFortran95 = 13;
    public static final int LLVMDWARFSourceLanguagePLI = 14;
    public static final int LLVMDWARFSourceLanguageObjC = 15;
    public static final int LLVMDWARFSourceLanguageObjC_plus_plus = 16;
    public static final int LLVMDWARFSourceLanguageUPC = 17;
    public static final int LLVMDWARFSourceLanguageD = 18;
    public static final int LLVMDWARFSourceLanguagePython = 19;
    public static final int LLVMDWARFSourceLanguageOpenCL = 20;
    public static final int LLVMDWARFSourceLanguageGo = 21;
    public static final int LLVMDWARFSourceLanguageModula3 = 22;
    public static final int LLVMDWARFSourceLanguageHaskell = 23;
    public static final int LLVMDWARFSourceLanguageC_plus_plus_03 = 24;
    public static final int LLVMDWARFSourceLanguageC_plus_plus_11 = 25;
    public static final int LLVMDWARFSourceLanguageOCaml = 26;
    public static final int LLVMDWARFSourceLanguageRust = 27;
    public static final int LLVMDWARFSourceLanguageC11 = 28;
    public static final int LLVMDWARFSourceLanguageSwift = 29;
    public static final int LLVMDWARFSourceLanguageJulia = 30;
    public static final int LLVMDWARFSourceLanguageDylan = 31;
    public static final int LLVMDWARFSourceLanguageC_plus_plus_14 = 32;
    public static final int LLVMDWARFSourceLanguageFortran03 = 33;
    public static final int LLVMDWARFSourceLanguageFortran08 = 34;
    public static final int LLVMDWARFSourceLanguageRenderScript = 35;
    public static final int LLVMDWARFSourceLanguageBLISS = 36;
    public static final int LLVMDWARFSourceLanguageMips_Assembler = 37;
    public static final int LLVMDWARFSourceLanguageGOOGLE_RenderScript = 38;
    public static final int LLVMDWARFSourceLanguageBORLAND_Delphi = 39;
    public static final int LLVMDWARFEmissionNone = 0;
    public static final int LLVMDWARFEmissionFull = 1;
    public static final int LLVMDWARFEmissionLineTablesOnly = 2;
    public static final int LLVMMDStringMetadataKind = 0;
    public static final int LLVMConstantAsMetadataMetadataKind = 1;
    public static final int LLVMLocalAsMetadataMetadataKind = 2;
    public static final int LLVMDistinctMDOperandPlaceholderMetadataKind = 3;
    public static final int LLVMMDTupleMetadataKind = 4;
    public static final int LLVMDILocationMetadataKind = 5;
    public static final int LLVMDIExpressionMetadataKind = 6;
    public static final int LLVMDIGlobalVariableExpressionMetadataKind = 7;
    public static final int LLVMGenericDINodeMetadataKind = 8;
    public static final int LLVMDISubrangeMetadataKind = 9;
    public static final int LLVMDIEnumeratorMetadataKind = 10;
    public static final int LLVMDIBasicTypeMetadataKind = 11;
    public static final int LLVMDIDerivedTypeMetadataKind = 12;
    public static final int LLVMDICompositeTypeMetadataKind = 13;
    public static final int LLVMDISubroutineTypeMetadataKind = 14;
    public static final int LLVMDIFileMetadataKind = 15;
    public static final int LLVMDICompileUnitMetadataKind = 16;
    public static final int LLVMDISubprogramMetadataKind = 17;
    public static final int LLVMDILexicalBlockMetadataKind = 18;
    public static final int LLVMDILexicalBlockFileMetadataKind = 19;
    public static final int LLVMDINamespaceMetadataKind = 20;
    public static final int LLVMDIModuleMetadataKind = 21;
    public static final int LLVMDITemplateTypeParameterMetadataKind = 22;
    public static final int LLVMDITemplateValueParameterMetadataKind = 23;
    public static final int LLVMDIGlobalVariableMetadataKind = 24;
    public static final int LLVMDILocalVariableMetadataKind = 25;
    public static final int LLVMDILabelMetadataKind = 26;
    public static final int LLVMDIObjCPropertyMetadataKind = 27;
    public static final int LLVMDIImportedEntityMetadataKind = 28;
    public static final int LLVMDIMacroMetadataKind = 29;
    public static final int LLVMDIMacroFileMetadataKind = 30;

    protected LLVMDebugInfo() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="unsigned int")
    public static int LLVMDebugMetadataVersion() {
        long __functionAddress = Functions.DebugMetadataVersion;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetModuleDebugMetadataVersion(@NativeType(value="LLVMModuleRef") long Module) {
        long __functionAddress = Functions.GetModuleDebugMetadataVersion;
        if (Checks.CHECKS) {
            Checks.check((long)Module);
        }
        return JNI.invokePI((long)Module, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMStripModuleDebugInfo(@NativeType(value="LLVMModuleRef") long Module) {
        long __functionAddress = Functions.StripModuleDebugInfo;
        if (Checks.CHECKS) {
            Checks.check((long)Module);
        }
        return JNI.invokePI((long)Module, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMDIBuilderRef")
    public static long LLVMCreateDIBuilderDisallowUnresolved(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateDIBuilderDisallowUnresolved;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    @NativeType(value="LLVMDIBuilderRef")
    public static long LLVMCreateDIBuilder(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateDIBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    public static void LLVMDisposeDIBuilder(@NativeType(value="LLVMDIBuilderRef") long Builder) {
        long __functionAddress = Functions.DisposeDIBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        JNI.invokePV((long)Builder, (long)__functionAddress);
    }

    public static void LLVMDIBuilderFinalize(@NativeType(value="LLVMDIBuilderRef") long Builder) {
        long __functionAddress = Functions.DIBuilderFinalize;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        JNI.invokePV((long)Builder, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateCompileUnit(long Builder, int Lang, long FileRef, long Producer, long ProducerLen, int isOptimized, long Flags, long FlagsLen, int RuntimeVer, long SplitName, long SplitNameLen, int Kind, int DWOId, int SplitDebugInlining, int DebugInfoForProfiling) {
        long __functionAddress = Functions.DIBuilderCreateCompileUnit;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)FileRef);
        }
        return JNI.invokePPPPPPPPP((long)Builder, (int)Lang, (long)FileRef, (long)Producer, (long)ProducerLen, (int)isOptimized, (long)Flags, (long)FlagsLen, (int)RuntimeVer, (long)SplitName, (long)SplitNameLen, (int)Kind, (int)DWOId, (int)SplitDebugInlining, (int)DebugInfoForProfiling, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateCompileUnit(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMDWARFSourceLanguage") int Lang, @NativeType(value="LLVMMetadataRef") long FileRef, @NativeType(value="char const *") ByteBuffer Producer, @NativeType(value="LLVMBool") boolean isOptimized, @NativeType(value="char const *") ByteBuffer Flags, @NativeType(value="unsigned int") int RuntimeVer, @NativeType(value="char const *") ByteBuffer SplitName, @NativeType(value="LLVMDWARFEmissionKind") int Kind, @NativeType(value="unsigned int") int DWOId, @NativeType(value="LLVMBool") boolean SplitDebugInlining, @NativeType(value="LLVMBool") boolean DebugInfoForProfiling) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateCompileUnit(Builder, Lang, FileRef, MemoryUtil.memAddress((ByteBuffer)Producer), Producer.remaining(), isOptimized ? 1 : 0, MemoryUtil.memAddress((ByteBuffer)Flags), Flags.remaining(), RuntimeVer, MemoryUtil.memAddress((ByteBuffer)SplitName), SplitName.remaining(), Kind, DWOId, SplitDebugInlining ? 1 : 0, DebugInfoForProfiling ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateCompileUnit(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMDWARFSourceLanguage") int Lang, @NativeType(value="LLVMMetadataRef") long FileRef, @NativeType(value="char const *") CharSequence Producer, @NativeType(value="LLVMBool") boolean isOptimized, @NativeType(value="char const *") CharSequence Flags, @NativeType(value="unsigned int") int RuntimeVer, @NativeType(value="char const *") CharSequence SplitName, @NativeType(value="LLVMDWARFEmissionKind") int Kind, @NativeType(value="unsigned int") int DWOId, @NativeType(value="LLVMBool") boolean SplitDebugInlining, @NativeType(value="LLVMBool") boolean DebugInfoForProfiling) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int ProducerEncodedLength = stack.nUTF8(Producer, false);
            long ProducerEncoded = stack.getPointerAddress();
            int FlagsEncodedLength = stack.nUTF8(Flags, false);
            long FlagsEncoded = stack.getPointerAddress();
            int SplitNameEncodedLength = stack.nUTF8(SplitName, false);
            long SplitNameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateCompileUnit(Builder, Lang, FileRef, ProducerEncoded, ProducerEncodedLength, isOptimized ? 1 : 0, FlagsEncoded, FlagsEncodedLength, RuntimeVer, SplitNameEncoded, SplitNameEncodedLength, Kind, DWOId, SplitDebugInlining ? 1 : 0, DebugInfoForProfiling ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateFile(long Builder, long Filename, long FilenameLen, long Directory, long DirectoryLen) {
        long __functionAddress = Functions.DIBuilderCreateFile;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPPPPP((long)Builder, (long)Filename, (long)FilenameLen, (long)Directory, (long)DirectoryLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFile(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") ByteBuffer Filename, @NativeType(value="char const *") ByteBuffer Directory) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateFile(Builder, MemoryUtil.memAddress((ByteBuffer)Filename), Filename.remaining(), MemoryUtil.memAddress((ByteBuffer)Directory), Directory.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFile(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") CharSequence Filename, @NativeType(value="char const *") CharSequence Directory) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int FilenameEncodedLength = stack.nUTF8(Filename, false);
            long FilenameEncoded = stack.getPointerAddress();
            int DirectoryEncodedLength = stack.nUTF8(Directory, false);
            long DirectoryEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateFile(Builder, FilenameEncoded, FilenameEncodedLength, DirectoryEncoded, DirectoryEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateModule(long Builder, long ParentScope, long Name, long NameLen, long ConfigMacros, long ConfigMacrosLen, long IncludePath, long IncludePathLen, long ISysRoot, long ISysRootLen) {
        long __functionAddress = Functions.DIBuilderCreateModule;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)ParentScope);
        }
        return JNI.invokePPPPPPPPPPP((long)Builder, (long)ParentScope, (long)Name, (long)NameLen, (long)ConfigMacros, (long)ConfigMacrosLen, (long)IncludePath, (long)IncludePathLen, (long)ISysRoot, (long)ISysRootLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateModule(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="char const *") ByteBuffer ConfigMacros, @NativeType(value="char const *") ByteBuffer IncludePath, @NativeType(value="char const *") ByteBuffer ISysRoot) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateModule(Builder, ParentScope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), MemoryUtil.memAddress((ByteBuffer)ConfigMacros), ConfigMacros.remaining(), MemoryUtil.memAddress((ByteBuffer)IncludePath), IncludePath.remaining(), MemoryUtil.memAddress((ByteBuffer)ISysRoot), ISysRoot.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateModule(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="char const *") CharSequence ConfigMacros, @NativeType(value="char const *") CharSequence IncludePath, @NativeType(value="char const *") CharSequence ISysRoot) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int ConfigMacrosEncodedLength = stack.nUTF8(ConfigMacros, false);
            long ConfigMacrosEncoded = stack.getPointerAddress();
            int IncludePathEncodedLength = stack.nUTF8(IncludePath, false);
            long IncludePathEncoded = stack.getPointerAddress();
            int ISysRootEncodedLength = stack.nUTF8(ISysRoot, false);
            long ISysRootEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateModule(Builder, ParentScope, NameEncoded, NameEncodedLength, ConfigMacrosEncoded, ConfigMacrosEncodedLength, IncludePathEncoded, IncludePathEncodedLength, ISysRootEncoded, ISysRootEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateNameSpace(long Builder, long ParentScope, long Name, long NameLen, int ExportSymbols) {
        long __functionAddress = Functions.DIBuilderCreateNameSpace;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)ParentScope);
        }
        return JNI.invokePPPPP((long)Builder, (long)ParentScope, (long)Name, (long)NameLen, (int)ExportSymbols, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateNameSpace(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMBool") boolean ExportSymbols) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateNameSpace(Builder, ParentScope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), ExportSymbols ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateNameSpace(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMBool") boolean ExportSymbols) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateNameSpace(Builder, ParentScope, NameEncoded, NameEncodedLength, ExportSymbols ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateFunction(long Builder, long Scope, long Name, long NameLen, long LinkageName, long LinkageNameLen, long File, int LineNo, long Ty, int IsLocalToUnit, int IsDefinition, int ScopeLine, int Flags, int IsOptimized) {
        long __functionAddress = Functions.DIBuilderCreateFunction;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)LinkageName, (long)LinkageNameLen, (long)File, (int)LineNo, (long)Ty, (int)IsLocalToUnit, (int)IsDefinition, (int)ScopeLine, (int)Flags, (int)IsOptimized, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFunction(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="char const *") ByteBuffer LinkageName, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean IsLocalToUnit, @NativeType(value="LLVMBool") boolean IsDefinition, @NativeType(value="unsigned int") int ScopeLine, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMBool") boolean IsOptimized) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateFunction(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), MemoryUtil.memAddress((ByteBuffer)LinkageName), LinkageName.remaining(), File, LineNo, Ty, IsLocalToUnit ? 1 : 0, IsDefinition ? 1 : 0, ScopeLine, Flags, IsOptimized ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFunction(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="char const *") CharSequence LinkageName, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean IsLocalToUnit, @NativeType(value="LLVMBool") boolean IsDefinition, @NativeType(value="unsigned int") int ScopeLine, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMBool") boolean IsOptimized) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int LinkageNameEncodedLength = stack.nUTF8(LinkageName, false);
            long LinkageNameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateFunction(Builder, Scope, NameEncoded, NameEncodedLength, LinkageNameEncoded, LinkageNameEncodedLength, File, LineNo, Ty, IsLocalToUnit ? 1 : 0, IsDefinition ? 1 : 0, ScopeLine, Flags, IsOptimized ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateLexicalBlock(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int Column) {
        long __functionAddress = Functions.DIBuilderCreateLexicalBlock;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
        }
        return JNI.invokePPPP((long)Builder, (long)Scope, (long)File, (int)Line, (int)Column, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateLexicalBlockFile(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Discriminator) {
        long __functionAddress = Functions.DIBuilderCreateLexicalBlockFile;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
        }
        return JNI.invokePPPP((long)Builder, (long)Scope, (long)File, (int)Discriminator, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedModuleFromNamespace(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long NS, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line) {
        long __functionAddress = Functions.DIBuilderCreateImportedModuleFromNamespace;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)NS);
            Checks.check((long)File);
        }
        return JNI.invokePPPPP((long)Builder, (long)Scope, (long)NS, (long)File, (int)Line, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedModuleFromAlias(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long ImportedEntity, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line) {
        long __functionAddress = Functions.DIBuilderCreateImportedModuleFromAlias;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)ImportedEntity);
            Checks.check((long)File);
        }
        return JNI.invokePPPPP((long)Builder, (long)Scope, (long)ImportedEntity, (long)File, (int)Line, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedModuleFromModule(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long M, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line) {
        long __functionAddress = Functions.DIBuilderCreateImportedModuleFromModule;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)M);
            Checks.check((long)File);
        }
        return JNI.invokePPPPP((long)Builder, (long)Scope, (long)M, (long)File, (int)Line, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateImportedDeclaration(long Builder, long Scope, long Decl, long File, int Line, long Name, long NameLen) {
        long __functionAddress = Functions.DIBuilderCreateImportedDeclaration;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)Decl);
            Checks.check((long)File);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Scope, (long)Decl, (long)File, (int)Line, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedDeclaration(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateImportedDeclaration(Builder, Scope, Decl, File, Line, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedDeclaration(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateImportedDeclaration(Builder, Scope, Decl, File, Line, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateDebugLocation(@NativeType(value="LLVMContextRef") long Ctx, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int Column, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long InlinedAt) {
        long __functionAddress = Functions.DIBuilderCreateDebugLocation;
        if (Checks.CHECKS) {
            Checks.check((long)Ctx);
            Checks.check((long)Scope);
            Checks.check((long)InlinedAt);
        }
        return JNI.invokePPPP((long)Ctx, (int)Line, (int)Column, (long)Scope, (long)InlinedAt, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMDILocationGetLine(@NativeType(value="LLVMMetadataRef") long Location) {
        long __functionAddress = Functions.DILocationGetLine;
        if (Checks.CHECKS) {
            Checks.check((long)Location);
        }
        return JNI.invokePI((long)Location, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMDILocationGetColumn(@NativeType(value="LLVMMetadataRef") long Location) {
        long __functionAddress = Functions.DILocationGetColumn;
        if (Checks.CHECKS) {
            Checks.check((long)Location);
        }
        return JNI.invokePI((long)Location, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDILocationGetScope(@NativeType(value="LLVMMetadataRef") long Location) {
        long __functionAddress = Functions.DILocationGetScope;
        if (Checks.CHECKS) {
            Checks.check((long)Location);
        }
        return JNI.invokePP((long)Location, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderGetOrCreateTypeArray(long Builder, long Data, long NumElements) {
        long __functionAddress = Functions.DIBuilderGetOrCreateTypeArray;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPPP((long)Builder, (long)Data, (long)NumElements, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderGetOrCreateTypeArray(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef *") PointerBuffer Data) {
        return LLVMDebugInfo.nLLVMDIBuilderGetOrCreateTypeArray(Builder, MemoryUtil.memAddress((CustomBuffer)Data), Data.remaining());
    }

    public static long nLLVMDIBuilderCreateSubroutineType(long Builder, long File, long ParameterTypes, int NumParameterTypes, int Flags) {
        long __functionAddress = Functions.DIBuilderCreateSubroutineType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)File);
        }
        return JNI.invokePPPP((long)Builder, (long)File, (long)ParameterTypes, (int)NumParameterTypes, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateSubroutineType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="LLVMMetadataRef *") PointerBuffer ParameterTypes, @NativeType(value="LLVMDIFlags") int Flags) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateSubroutineType(Builder, File, MemoryUtil.memAddress((CustomBuffer)ParameterTypes), ParameterTypes.remaining(), Flags);
    }

    public static long nLLVMDIBuilderCreateEnumerationType(long Builder, long Scope, long Name, long NameLen, long File, int LineNumber, long SizeInBits, int AlignInBits, long Elements, int NumElements, long ClassTy) {
        long __functionAddress = Functions.DIBuilderCreateEnumerationType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)ClassTy);
        }
        return JNI.invokePPPPPJPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNumber, (long)SizeInBits, (int)AlignInBits, (long)Elements, (int)NumElements, (long)ClassTy, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateEnumerationType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long ClassTy) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateEnumerationType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNumber, SizeInBits, AlignInBits, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), ClassTy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateEnumerationType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long ClassTy) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateEnumerationType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNumber, SizeInBits, AlignInBits, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), ClassTy);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateUnionType(long Builder, long Scope, long Name, long NameLen, long File, int LineNumber, long SizeInBits, int AlignInBits, int Flags, long Elements, int NumElements, int RunTimeLang, long UniqueId, long UniqueIdLen) {
        long __functionAddress = Functions.DIBuilderCreateUnionType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
        }
        return JNI.invokePPPPPJPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNumber, (long)SizeInBits, (int)AlignInBits, (int)Flags, (long)Elements, (int)NumElements, (int)RunTimeLang, (long)UniqueId, (long)UniqueIdLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnionType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="char const *") ByteBuffer UniqueId) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateUnionType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNumber, SizeInBits, AlignInBits, Flags, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), RunTimeLang, MemoryUtil.memAddress((ByteBuffer)UniqueId), UniqueId.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnionType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="char const *") CharSequence UniqueId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdEncodedLength = stack.nUTF8(UniqueId, false);
            long UniqueIdEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateUnionType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNumber, SizeInBits, AlignInBits, Flags, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), RunTimeLang, UniqueIdEncoded, UniqueIdEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateArrayType(long Builder, long Size, int AlignInBits, long Ty, long Subscripts, int NumSubscripts) {
        long __functionAddress = Functions.DIBuilderCreateArrayType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
        }
        return JNI.invokePJPPP((long)Builder, (long)Size, (int)AlignInBits, (long)Ty, (long)Subscripts, (int)NumSubscripts, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateArrayType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="uint64_t") long Size, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef *") PointerBuffer Subscripts) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateArrayType(Builder, Size, AlignInBits, Ty, MemoryUtil.memAddress((CustomBuffer)Subscripts), Subscripts.remaining());
    }

    public static long nLLVMDIBuilderCreateVectorType(long Builder, long Size, int AlignInBits, long Ty, long Subscripts, int NumSubscripts) {
        long __functionAddress = Functions.DIBuilderCreateVectorType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
        }
        return JNI.invokePJPPP((long)Builder, (long)Size, (int)AlignInBits, (long)Ty, (long)Subscripts, (int)NumSubscripts, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateVectorType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="uint64_t") long Size, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef *") PointerBuffer Subscripts) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateVectorType(Builder, Size, AlignInBits, Ty, MemoryUtil.memAddress((CustomBuffer)Subscripts), Subscripts.remaining());
    }

    public static long nLLVMDIBuilderCreateUnspecifiedType(long Builder, long Name, long NameLen) {
        long __functionAddress = Functions.DIBuilderCreateUnspecifiedType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPPP((long)Builder, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnspecifiedType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateUnspecifiedType(Builder, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnspecifiedType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateUnspecifiedType(Builder, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateBasicType(long Builder, long Name, long NameLen, long SizeInBits, int Encoding, int Flags) {
        long __functionAddress = Functions.DIBuilderCreateBasicType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPPJP((long)Builder, (long)Name, (long)NameLen, (long)SizeInBits, (int)Encoding, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBasicType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="LLVMDWARFTypeEncoding") int Encoding, @NativeType(value="LLVMDIFlags") int Flags) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateBasicType(Builder, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), SizeInBits, Encoding, Flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBasicType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") CharSequence Name, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="LLVMDWARFTypeEncoding") int Encoding, @NativeType(value="LLVMDIFlags") int Flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateBasicType(Builder, NameEncoded, NameEncodedLength, SizeInBits, Encoding, Flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreatePointerType(long Builder, long PointeeTy, long SizeInBits, int AlignInBits, int AddressSpace, long Name, long NameLen) {
        long __functionAddress = Functions.DIBuilderCreatePointerType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)PointeeTy);
        }
        return JNI.invokePPJPPP((long)Builder, (long)PointeeTy, (long)SizeInBits, (int)AlignInBits, (int)AddressSpace, (long)Name, (long)NameLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreatePointerType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long PointeeTy, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="unsigned int") int AddressSpace, @NativeType(value="char const *") ByteBuffer Name) {
        return LLVMDebugInfo.nLLVMDIBuilderCreatePointerType(Builder, PointeeTy, SizeInBits, AlignInBits, AddressSpace, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreatePointerType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long PointeeTy, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="unsigned int") int AddressSpace, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreatePointerType(Builder, PointeeTy, SizeInBits, AlignInBits, AddressSpace, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateStructType(long Builder, long Scope, long Name, long NameLen, long File, int LineNumber, long SizeInBits, int AlignInBits, int Flags, long DerivedFrom, long Elements, int NumElements, int RunTimeLang, long VTableHolder, long UniqueId, long UniqueIdLen) {
        long __functionAddress = Functions.DIBuilderCreateStructType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)DerivedFrom);
            Checks.check((long)VTableHolder);
        }
        return JNI.invokePPPPPJPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNumber, (long)SizeInBits, (int)AlignInBits, (int)Flags, (long)DerivedFrom, (long)Elements, (int)NumElements, (int)RunTimeLang, (long)VTableHolder, (long)UniqueId, (long)UniqueIdLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStructType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="char const *") ByteBuffer UniqueId) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateStructType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNumber, SizeInBits, AlignInBits, Flags, DerivedFrom, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), RunTimeLang, VTableHolder, MemoryUtil.memAddress((ByteBuffer)UniqueId), UniqueId.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStructType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="char const *") CharSequence UniqueId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdEncodedLength = stack.nUTF8(UniqueId, false);
            long UniqueIdEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateStructType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNumber, SizeInBits, AlignInBits, Flags, DerivedFrom, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), RunTimeLang, VTableHolder, UniqueIdEncoded, UniqueIdEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateMemberType(long Builder, long Scope, long Name, long NameLen, long File, int LineNo, long SizeInBits, int AlignInBits, long OffsetInBits, int Flags, long Ty) {
        long __functionAddress = Functions.DIBuilderCreateMemberType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPPJJPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNo, (long)SizeInBits, (int)AlignInBits, (long)OffsetInBits, (int)Flags, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateMemberType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateMemberType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateStaticMemberType(long Builder, long Scope, long Name, long NameLen, long File, int LineNumber, long Type, int Flags, long ConstantVal, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateStaticMemberType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Type);
            Checks.check((long)ConstantVal);
        }
        return JNI.invokePPPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNumber, (long)Type, (int)Flags, (long)ConstantVal, (int)AlignInBits, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStaticMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="LLVMMetadataRef") long Type, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateStaticMemberType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNumber, Type, Flags, ConstantVal, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStaticMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="LLVMMetadataRef") long Type, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateStaticMemberType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNumber, Type, Flags, ConstantVal, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMemberPointerType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long PointeeType, @NativeType(value="LLVMMetadataRef") long ClassType, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags) {
        long __functionAddress = Functions.DIBuilderCreateMemberPointerType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)PointeeType);
            Checks.check((long)ClassType);
        }
        return JNI.invokePPPJP((long)Builder, (long)PointeeType, (long)ClassType, (long)SizeInBits, (int)AlignInBits, (int)Flags, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateObjCIVar(long Builder, long Name, long NameLen, long File, int LineNo, long SizeInBits, int AlignInBits, long OffsetInBits, int Flags, long Ty, long PropertyNode) {
        long __functionAddress = Functions.DIBuilderCreateObjCIVar;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)File);
            Checks.check((long)Ty);
            Checks.check((long)PropertyNode);
        }
        return JNI.invokePPPPJJPPP((long)Builder, (long)Name, (long)NameLen, (long)File, (int)LineNo, (long)SizeInBits, (int)AlignInBits, (long)OffsetInBits, (int)Flags, (long)Ty, (long)PropertyNode, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCIVar(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef") long PropertyNode) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateObjCIVar(Builder, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty, PropertyNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCIVar(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef") long PropertyNode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateObjCIVar(Builder, NameEncoded, NameEncodedLength, File, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty, PropertyNode);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateObjCProperty(long Builder, long Name, long NameLen, long File, int LineNo, long GetterName, long GetterNameLen, long SetterName, long SetterNameLen, int PropertyAttributes, long Ty) {
        long __functionAddress = Functions.DIBuilderCreateObjCProperty;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)File);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPPPPPPP((long)Builder, (long)Name, (long)NameLen, (long)File, (int)LineNo, (long)GetterName, (long)GetterNameLen, (long)SetterName, (long)SetterNameLen, (int)PropertyAttributes, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCProperty(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="char const *") ByteBuffer GetterName, @NativeType(value="char const *") ByteBuffer SetterName, @NativeType(value="unsigned int") int PropertyAttributes, @NativeType(value="LLVMMetadataRef") long Ty) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateObjCProperty(Builder, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNo, MemoryUtil.memAddress((ByteBuffer)GetterName), GetterName.remaining(), MemoryUtil.memAddress((ByteBuffer)SetterName), SetterName.remaining(), PropertyAttributes, Ty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCProperty(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="char const *") CharSequence GetterName, @NativeType(value="char const *") CharSequence SetterName, @NativeType(value="unsigned int") int PropertyAttributes, @NativeType(value="LLVMMetadataRef") long Ty) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int GetterNameEncodedLength = stack.nUTF8(GetterName, false);
            long GetterNameEncoded = stack.getPointerAddress();
            int SetterNameEncodedLength = stack.nUTF8(SetterName, false);
            long SetterNameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateObjCProperty(Builder, NameEncoded, NameEncodedLength, File, LineNo, GetterNameEncoded, GetterNameEncodedLength, SetterNameEncoded, SetterNameEncodedLength, PropertyAttributes, Ty);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjectPointerType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Type) {
        long __functionAddress = Functions.DIBuilderCreateObjectPointerType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Type);
        }
        return JNI.invokePPP((long)Builder, (long)Type, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateQualifiedType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="unsigned int") int Tag, @NativeType(value="LLVMMetadataRef") long Type) {
        long __functionAddress = Functions.DIBuilderCreateQualifiedType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Type);
        }
        return JNI.invokePPP((long)Builder, (int)Tag, (long)Type, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateReferenceType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="unsigned int") int Tag, @NativeType(value="LLVMMetadataRef") long Type) {
        long __functionAddress = Functions.DIBuilderCreateReferenceType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Type);
        }
        return JNI.invokePPP((long)Builder, (int)Tag, (long)Type, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateNullPtrType(@NativeType(value="LLVMDIBuilderRef") long Builder) {
        long __functionAddress = Functions.DIBuilderCreateNullPtrType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePP((long)Builder, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateTypedef(long Builder, long Type, long Name, long NameLen, long File, int LineNo, long Scope) {
        long __functionAddress = Functions.DIBuilderCreateTypedef;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Type);
            Checks.check((long)File);
            Checks.check((long)Scope);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Type, (long)Name, (long)NameLen, (long)File, (int)LineNo, (long)Scope, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTypedef(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Type, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Scope) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateTypedef(Builder, Type, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNo, Scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTypedef(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Type, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Scope) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateTypedef(Builder, Type, NameEncoded, NameEncodedLength, File, LineNo, Scope);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateInheritance(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef") long BaseTy, @NativeType(value="uint64_t") long BaseOffset, @NativeType(value="uint32_t") int VBPtrOffset, @NativeType(value="LLVMDIFlags") int Flags) {
        long __functionAddress = Functions.DIBuilderCreateInheritance;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Ty);
            Checks.check((long)BaseTy);
        }
        return JNI.invokePPPJP((long)Builder, (long)Ty, (long)BaseTy, (long)BaseOffset, (int)VBPtrOffset, (int)Flags, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateForwardDecl(long Builder, int Tag, long Name, long NameLen, long Scope, long File, int Line, int RuntimeLang, long SizeInBits, int AlignInBits, long UniqueIdentifier, long UniqueIdentifierLen) {
        long __functionAddress = Functions.DIBuilderCreateForwardDecl;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
        }
        return JNI.invokePPPPPJPPP((long)Builder, (int)Tag, (long)Name, (long)NameLen, (long)Scope, (long)File, (int)Line, (int)RuntimeLang, (long)SizeInBits, (int)AlignInBits, (long)UniqueIdentifier, (long)UniqueIdentifierLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateForwardDecl(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="char const *") ByteBuffer UniqueIdentifier) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateForwardDecl(Builder, Tag, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), Scope, File, Line, RuntimeLang, SizeInBits, AlignInBits, MemoryUtil.memAddress((ByteBuffer)UniqueIdentifier), UniqueIdentifier.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateForwardDecl(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="char const *") CharSequence UniqueIdentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdentifierEncodedLength = stack.nUTF8(UniqueIdentifier, false);
            long UniqueIdentifierEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateForwardDecl(Builder, Tag, NameEncoded, NameEncodedLength, Scope, File, Line, RuntimeLang, SizeInBits, AlignInBits, UniqueIdentifierEncoded, UniqueIdentifierEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateReplaceableCompositeType(long Builder, int Tag, long Name, long NameLen, long Scope, long File, int Line, int RuntimeLang, long SizeInBits, int AlignInBits, int Flags, long UniqueIdentifier, long UniqueIdentifierLen) {
        long __functionAddress = Functions.DIBuilderCreateReplaceableCompositeType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
        }
        return JNI.invokePPPPPJPPP((long)Builder, (int)Tag, (long)Name, (long)NameLen, (long)Scope, (long)File, (int)Line, (int)RuntimeLang, (long)SizeInBits, (int)AlignInBits, (int)Flags, (long)UniqueIdentifier, (long)UniqueIdentifierLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateReplaceableCompositeType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="char const *") ByteBuffer UniqueIdentifier) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateReplaceableCompositeType(Builder, Tag, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), Scope, File, Line, RuntimeLang, SizeInBits, AlignInBits, Flags, MemoryUtil.memAddress((ByteBuffer)UniqueIdentifier), UniqueIdentifier.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateReplaceableCompositeType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="char const *") CharSequence UniqueIdentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdentifierEncodedLength = stack.nUTF8(UniqueIdentifier, false);
            long UniqueIdentifierEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateReplaceableCompositeType(Builder, Tag, NameEncoded, NameEncodedLength, Scope, File, Line, RuntimeLang, SizeInBits, AlignInBits, Flags, UniqueIdentifierEncoded, UniqueIdentifierEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateBitFieldMemberType(long Builder, long Scope, long Name, long NameLen, long File, int LineNumber, long SizeInBits, long OffsetInBits, long StorageOffsetInBits, int Flags, long Type) {
        long __functionAddress = Functions.DIBuilderCreateBitFieldMemberType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Type);
        }
        return JNI.invokePPPPPJJJPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNumber, (long)SizeInBits, (long)OffsetInBits, (long)StorageOffsetInBits, (int)Flags, (long)Type, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBitFieldMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="uint64_t") long StorageOffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Type) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateBitFieldMemberType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNumber, SizeInBits, OffsetInBits, StorageOffsetInBits, Flags, Type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBitFieldMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="uint64_t") long StorageOffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Type) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateBitFieldMemberType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNumber, SizeInBits, OffsetInBits, StorageOffsetInBits, Flags, Type);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateClassType(long Builder, long Scope, long Name, long NameLen, long File, int LineNumber, long SizeInBits, int AlignInBits, long OffsetInBits, int Flags, long DerivedFrom, long Elements, int NumElements, long VTableHolder, long TemplateParamsNode, long UniqueIdentifier, long UniqueIdentifierLen) {
        long __functionAddress = Functions.DIBuilderCreateClassType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)DerivedFrom);
            Checks.check((long)VTableHolder);
            Checks.check((long)TemplateParamsNode);
        }
        return JNI.invokePPPPPJJPPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNumber, (long)SizeInBits, (int)AlignInBits, (long)OffsetInBits, (int)Flags, (long)DerivedFrom, (long)Elements, (int)NumElements, (long)VTableHolder, (long)TemplateParamsNode, (long)UniqueIdentifier, (long)UniqueIdentifierLen, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateClassType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="LLVMMetadataRef") long TemplateParamsNode, @NativeType(value="char const *") ByteBuffer UniqueIdentifier) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateClassType(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNumber, SizeInBits, AlignInBits, OffsetInBits, Flags, DerivedFrom, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), VTableHolder, TemplateParamsNode, MemoryUtil.memAddress((ByteBuffer)UniqueIdentifier), UniqueIdentifier.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateClassType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="LLVMMetadataRef") long TemplateParamsNode, @NativeType(value="char const *") CharSequence UniqueIdentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdentifierEncodedLength = stack.nUTF8(UniqueIdentifier, false);
            long UniqueIdentifierEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateClassType(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNumber, SizeInBits, AlignInBits, OffsetInBits, Flags, DerivedFrom, MemoryUtil.memAddress((CustomBuffer)Elements), Elements.remaining(), VTableHolder, TemplateParamsNode, UniqueIdentifierEncoded, UniqueIdentifierEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateArtificialType(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Type) {
        long __functionAddress = Functions.DIBuilderCreateArtificialType;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Type);
        }
        return JNI.invokePPP((long)Builder, (long)Type, (long)__functionAddress);
    }

    public static long nLLVMDITypeGetName(long DType, long Length) {
        long __functionAddress = Functions.DITypeGetName;
        if (Checks.CHECKS) {
            Checks.check((long)DType);
        }
        return JNI.invokePPP((long)DType, (long)Length, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMDITypeGetName(@NativeType(value="LLVMMetadataRef") long DType) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Length = stack.callocPointer(1);
            long __result = LLVMDebugInfo.nLLVMDITypeGetName(DType, MemoryUtil.memAddress((CustomBuffer)Length));
            String string = MemoryUtil.memUTF8Safe((long)__result, (int)((int)Length.get(0)));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint64_t")
    public static long LLVMDITypeGetSizeInBits(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetSizeInBits;
        if (Checks.CHECKS) {
            Checks.check((long)DType);
        }
        return JNI.invokePJ((long)DType, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMDITypeGetOffsetInBits(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetOffsetInBits;
        if (Checks.CHECKS) {
            Checks.check((long)DType);
        }
        return JNI.invokePJ((long)DType, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMDITypeGetAlignInBits(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetAlignInBits;
        if (Checks.CHECKS) {
            Checks.check((long)DType);
        }
        return JNI.invokePI((long)DType, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMDITypeGetLine(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetLine;
        if (Checks.CHECKS) {
            Checks.check((long)DType);
        }
        return JNI.invokePI((long)DType, (long)__functionAddress);
    }

    @NativeType(value="LLVMDIFlags")
    public static int LLVMDITypeGetFlags(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetFlags;
        if (Checks.CHECKS) {
            Checks.check((long)DType);
        }
        return JNI.invokePI((long)DType, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderGetOrCreateSubrange(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="int64_t") long LowerBound, @NativeType(value="int64_t") long Count) {
        long __functionAddress = Functions.DIBuilderGetOrCreateSubrange;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePJJP((long)Builder, (long)LowerBound, (long)Count, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderGetOrCreateArray(long Builder, long Data, long NumElements) {
        long __functionAddress = Functions.DIBuilderGetOrCreateArray;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPPP((long)Builder, (long)Data, (long)NumElements, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderGetOrCreateArray(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef *") PointerBuffer Data) {
        return LLVMDebugInfo.nLLVMDIBuilderGetOrCreateArray(Builder, MemoryUtil.memAddress((CustomBuffer)Data), Data.remaining());
    }

    public static long nLLVMDIBuilderCreateExpression(long Builder, long Addr, long Length) {
        long __functionAddress = Functions.DIBuilderCreateExpression;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePPPP((long)Builder, (long)Addr, (long)Length, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateExpression(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="int64_t *") LongBuffer Addr) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateExpression(Builder, MemoryUtil.memAddress((LongBuffer)Addr), Addr.remaining());
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateConstantValueExpression(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="int64_t") long Value) {
        long __functionAddress = Functions.DIBuilderCreateConstantValueExpression;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
        }
        return JNI.invokePJP((long)Builder, (long)Value, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateGlobalVariableExpression(long Builder, long Scope, long Name, long NameLen, long Linkage, long LinkLen, long File, int LineNo, long Ty, int LocalToUnit, long Expr, long Decl, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateGlobalVariableExpression;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Ty);
            Checks.check((long)Expr);
            Checks.check((long)Decl);
        }
        return JNI.invokePPPPPPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)Linkage, (long)LinkLen, (long)File, (int)LineNo, (long)Ty, (int)LocalToUnit, (long)Expr, (long)Decl, (int)AlignInBits, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateGlobalVariableExpression(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="char const *") ByteBuffer Linkage, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateGlobalVariableExpression(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), MemoryUtil.memAddress((ByteBuffer)Linkage), Linkage.remaining(), File, LineNo, Ty, LocalToUnit ? 1 : 0, Expr, Decl, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateGlobalVariableExpression(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="char const *") CharSequence Linkage, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int LinkageEncodedLength = stack.nUTF8(Linkage, false);
            long LinkageEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateGlobalVariableExpression(Builder, Scope, NameEncoded, NameEncodedLength, LinkageEncoded, LinkageEncodedLength, File, LineNo, Ty, LocalToUnit ? 1 : 0, Expr, Decl, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMTemporaryMDNode(long Ctx, long Data, long NumElements) {
        long __functionAddress = Functions.TemporaryMDNode;
        if (Checks.CHECKS) {
            Checks.check((long)Ctx);
        }
        return JNI.invokePPPP((long)Ctx, (long)Data, (long)NumElements, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMTemporaryMDNode(@NativeType(value="LLVMContextRef") long Ctx, @NativeType(value="LLVMMetadataRef *") PointerBuffer Data) {
        return LLVMDebugInfo.nLLVMTemporaryMDNode(Ctx, MemoryUtil.memAddress((CustomBuffer)Data), Data.remaining());
    }

    public static void LLVMDisposeTemporaryMDNode(@NativeType(value="LLVMMetadataRef") long TempNode) {
        long __functionAddress = Functions.DisposeTemporaryMDNode;
        if (Checks.CHECKS) {
            Checks.check((long)TempNode);
        }
        JNI.invokePV((long)TempNode, (long)__functionAddress);
    }

    public static void LLVMMetadataReplaceAllUsesWith(@NativeType(value="LLVMMetadataRef") long TempTargetMetadata, @NativeType(value="LLVMMetadataRef") long Replacement) {
        long __functionAddress = Functions.MetadataReplaceAllUsesWith;
        if (Checks.CHECKS) {
            Checks.check((long)TempTargetMetadata);
            Checks.check((long)Replacement);
        }
        JNI.invokePPV((long)TempTargetMetadata, (long)Replacement, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateTempGlobalVariableFwdDecl(long Builder, long Scope, long Name, long NameLen, long Linkage, long LnkLen, long File, int LineNo, long Ty, int LocalToUnit, long Decl, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateTempGlobalVariableFwdDecl;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Ty);
            Checks.check((long)Decl);
        }
        return JNI.invokePPPPPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)Linkage, (long)LnkLen, (long)File, (int)LineNo, (long)Ty, (int)LocalToUnit, (long)Decl, (int)AlignInBits, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTempGlobalVariableFwdDecl(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="char const *") ByteBuffer Linkage, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateTempGlobalVariableFwdDecl(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), MemoryUtil.memAddress((ByteBuffer)Linkage), Linkage.remaining(), File, LineNo, Ty, LocalToUnit ? 1 : 0, Decl, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTempGlobalVariableFwdDecl(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="char const *") CharSequence Linkage, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            int LinkageEncodedLength = stack.nUTF8(Linkage, false);
            long LinkageEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateTempGlobalVariableFwdDecl(Builder, Scope, NameEncoded, NameEncodedLength, LinkageEncoded, LinkageEncodedLength, File, LineNo, Ty, LocalToUnit ? 1 : 0, Decl, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDeclareBefore(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Storage, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.DIBuilderInsertDeclareBefore;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Storage);
            Checks.check((long)VarInfo);
            Checks.check((long)Expr);
            Checks.check((long)DebugLoc);
            Checks.check((long)Instr);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Storage, (long)VarInfo, (long)Expr, (long)DebugLoc, (long)Instr, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDeclareAtEnd(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Storage, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMBasicBlockRef") long Block) {
        long __functionAddress = Functions.DIBuilderInsertDeclareAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Storage);
            Checks.check((long)VarInfo);
            Checks.check((long)Expr);
            Checks.check((long)DebugLoc);
            Checks.check((long)Block);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Storage, (long)VarInfo, (long)Expr, (long)DebugLoc, (long)Block, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDbgValueBefore(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.DIBuilderInsertDbgValueBefore;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)VarInfo);
            Checks.check((long)Expr);
            Checks.check((long)DebugLoc);
            Checks.check((long)Instr);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Val, (long)VarInfo, (long)Expr, (long)DebugLoc, (long)Instr, (long)__functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDbgValueAtEnd(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMBasicBlockRef") long Block) {
        long __functionAddress = Functions.DIBuilderInsertDbgValueAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Val);
            Checks.check((long)VarInfo);
            Checks.check((long)Expr);
            Checks.check((long)DebugLoc);
            Checks.check((long)Block);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Val, (long)VarInfo, (long)Expr, (long)DebugLoc, (long)Block, (long)__functionAddress);
    }

    public static long nLLVMDIBuilderCreateAutoVariable(long Builder, long Scope, long Name, long NameLen, long File, int LineNo, long Ty, int AlwaysPreserve, int Flags, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateAutoVariable;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (long)File, (int)LineNo, (long)Ty, (int)AlwaysPreserve, (int)Flags, (int)AlignInBits, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateAutoVariable(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateAutoVariable(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), File, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateAutoVariable(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateAutoVariable(Builder, Scope, NameEncoded, NameEncodedLength, File, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateParameterVariable(long Builder, long Scope, long Name, long NameLen, int ArgNo, long File, int LineNo, long Ty, int AlwaysPreserve, int Flags) {
        long __functionAddress = Functions.DIBuilderCreateParameterVariable;
        if (Checks.CHECKS) {
            Checks.check((long)Builder);
            Checks.check((long)Scope);
            Checks.check((long)File);
            Checks.check((long)Ty);
        }
        return JNI.invokePPPPPPP((long)Builder, (long)Scope, (long)Name, (long)NameLen, (int)ArgNo, (long)File, (int)LineNo, (long)Ty, (int)AlwaysPreserve, (int)Flags, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateParameterVariable(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name, @NativeType(value="unsigned int") int ArgNo, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateParameterVariable(Builder, Scope, MemoryUtil.memAddress((ByteBuffer)Name), Name.remaining(), ArgNo, File, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateParameterVariable(@NativeType(value="LLVMDIBuilderRef") long Builder, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name, @NativeType(value="unsigned int") int ArgNo, @NativeType(value="LLVMMetadataRef") long File, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateParameterVariable(Builder, Scope, NameEncoded, NameEncodedLength, ArgNo, File, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetSubprogram(@NativeType(value="LLVMValueRef") long Func) {
        long __functionAddress = Functions.GetSubprogram;
        if (Checks.CHECKS) {
            Checks.check((long)Func);
        }
        return JNI.invokePP((long)Func, (long)__functionAddress);
    }

    public static void LLVMSetSubprogram(@NativeType(value="LLVMValueRef") long Func, @NativeType(value="LLVMMetadataRef") long SP) {
        long __functionAddress = Functions.SetSubprogram;
        if (Checks.CHECKS) {
            Checks.check((long)Func);
            Checks.check((long)SP);
        }
        JNI.invokePPV((long)Func, (long)SP, (long)__functionAddress);
    }

    @NativeType(value="LLVMMetadataKind")
    public static int LLVMGetMetadataKind(@NativeType(value="LLVMMetadataRef") long Metadata) {
        long __functionAddress = Functions.GetMetadataKind;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Metadata);
        }
        return JNI.invokePI((long)Metadata, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long DebugMetadataVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDebugMetadataVersion");
        public static final long GetModuleDebugMetadataVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetModuleDebugMetadataVersion");
        public static final long StripModuleDebugInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMStripModuleDebugInfo");
        public static final long CreateDIBuilderDisallowUnresolved = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateDIBuilderDisallowUnresolved");
        public static final long CreateDIBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateDIBuilder");
        public static final long DisposeDIBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeDIBuilder");
        public static final long DIBuilderFinalize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderFinalize");
        public static final long DIBuilderCreateCompileUnit = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateCompileUnit");
        public static final long DIBuilderCreateFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateFile");
        public static final long DIBuilderCreateModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateModule");
        public static final long DIBuilderCreateNameSpace = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateNameSpace");
        public static final long DIBuilderCreateFunction = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateFunction");
        public static final long DIBuilderCreateLexicalBlock = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateLexicalBlock");
        public static final long DIBuilderCreateLexicalBlockFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateLexicalBlockFile");
        public static final long DIBuilderCreateImportedModuleFromNamespace = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateImportedModuleFromNamespace");
        public static final long DIBuilderCreateImportedModuleFromAlias = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateImportedModuleFromAlias");
        public static final long DIBuilderCreateImportedModuleFromModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateImportedModuleFromModule");
        public static final long DIBuilderCreateImportedDeclaration = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateImportedDeclaration");
        public static final long DIBuilderCreateDebugLocation = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateDebugLocation");
        public static final long DILocationGetLine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDILocationGetLine");
        public static final long DILocationGetColumn = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDILocationGetColumn");
        public static final long DILocationGetScope = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDILocationGetScope");
        public static final long DIBuilderGetOrCreateTypeArray = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderGetOrCreateTypeArray");
        public static final long DIBuilderCreateSubroutineType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateSubroutineType");
        public static final long DIBuilderCreateEnumerationType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateEnumerationType");
        public static final long DIBuilderCreateUnionType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateUnionType");
        public static final long DIBuilderCreateArrayType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateArrayType");
        public static final long DIBuilderCreateVectorType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateVectorType");
        public static final long DIBuilderCreateUnspecifiedType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateUnspecifiedType");
        public static final long DIBuilderCreateBasicType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateBasicType");
        public static final long DIBuilderCreatePointerType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreatePointerType");
        public static final long DIBuilderCreateStructType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateStructType");
        public static final long DIBuilderCreateMemberType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateMemberType");
        public static final long DIBuilderCreateStaticMemberType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateStaticMemberType");
        public static final long DIBuilderCreateMemberPointerType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateMemberPointerType");
        public static final long DIBuilderCreateObjCIVar = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateObjCIVar");
        public static final long DIBuilderCreateObjCProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateObjCProperty");
        public static final long DIBuilderCreateObjectPointerType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateObjectPointerType");
        public static final long DIBuilderCreateQualifiedType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateQualifiedType");
        public static final long DIBuilderCreateReferenceType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateReferenceType");
        public static final long DIBuilderCreateNullPtrType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateNullPtrType");
        public static final long DIBuilderCreateTypedef = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateTypedef");
        public static final long DIBuilderCreateInheritance = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateInheritance");
        public static final long DIBuilderCreateForwardDecl = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateForwardDecl");
        public static final long DIBuilderCreateReplaceableCompositeType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateReplaceableCompositeType");
        public static final long DIBuilderCreateBitFieldMemberType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateBitFieldMemberType");
        public static final long DIBuilderCreateClassType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateClassType");
        public static final long DIBuilderCreateArtificialType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateArtificialType");
        public static final long DITypeGetName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDITypeGetName");
        public static final long DITypeGetSizeInBits = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDITypeGetSizeInBits");
        public static final long DITypeGetOffsetInBits = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDITypeGetOffsetInBits");
        public static final long DITypeGetAlignInBits = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDITypeGetAlignInBits");
        public static final long DITypeGetLine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDITypeGetLine");
        public static final long DITypeGetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDITypeGetFlags");
        public static final long DIBuilderGetOrCreateSubrange = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderGetOrCreateSubrange");
        public static final long DIBuilderGetOrCreateArray = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderGetOrCreateArray");
        public static final long DIBuilderCreateExpression = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateExpression");
        public static final long DIBuilderCreateConstantValueExpression = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateConstantValueExpression");
        public static final long DIBuilderCreateGlobalVariableExpression = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateGlobalVariableExpression");
        public static final long TemporaryMDNode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMTemporaryMDNode");
        public static final long DisposeTemporaryMDNode = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeTemporaryMDNode");
        public static final long MetadataReplaceAllUsesWith = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMMetadataReplaceAllUsesWith");
        public static final long DIBuilderCreateTempGlobalVariableFwdDecl = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateTempGlobalVariableFwdDecl");
        public static final long DIBuilderInsertDeclareBefore = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderInsertDeclareBefore");
        public static final long DIBuilderInsertDeclareAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderInsertDeclareAtEnd");
        public static final long DIBuilderInsertDbgValueBefore = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderInsertDbgValueBefore");
        public static final long DIBuilderInsertDbgValueAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderInsertDbgValueAtEnd");
        public static final long DIBuilderCreateAutoVariable = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateAutoVariable");
        public static final long DIBuilderCreateParameterVariable = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDIBuilderCreateParameterVariable");
        public static final long GetSubprogram = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSubprogram");
        public static final long SetSubprogram = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSetSubprogram");
        public static final long GetMetadataKind = LLVMCore.getLibrary().getFunctionAddress((CharSequence)"LLVMGetMetadataKind");

        private Functions() {
        }
    }
}

