"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiHeaderSectionItem", {
  enumerable: true,
  get: function get() {
    return _header_section_item.EuiHeaderSectionItem;
  }
});
exports.OuiHeaderSectionItem = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _header_section_item = require("../../../eui_components/header/header_section/header_section_item");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var borderToClassNameMap = {
  left: 'ouiHeaderSectionItem--borderLeft',
  right: 'ouiHeaderSectionItem--borderRight',
  none: undefined
};

var OuiHeaderSectionItem = function OuiHeaderSectionItem(_ref) {
  var _ref$border = _ref.border,
      border = _ref$border === void 0 ? 'left' : _ref$border,
      children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["border", "children", "className"]);

  var classes = (0, _classnames.default)('ouiHeaderSectionItem', borderToClassNameMap[border], className);
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: classes
  }, rest), children);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiHeaderSectionItem = OuiHeaderSectionItem;
OuiHeaderSectionItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Side to display a short border on.
     * Not supported in Cascadia theme.
     */
  border: _propTypes.default.oneOf(["left", "right", "none"]),

  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node
};