var _excluded = ["children", "onSort", "isSorted", "isSortAscending", "className", "ariaLabel", "align", "scope"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { LEFT_ALIGNMENT, RIGHT_ALIGNMENT } from '../../services';
export var KuiTableHeaderCell = function KuiTableHeaderCell(_ref) {
  var children = _ref.children,
      onSort = _ref.onSort,
      isSorted = _ref.isSorted,
      isSortAscending = _ref.isSortAscending,
      className = _ref.className,
      ariaLabel = _ref.ariaLabel,
      align = _ref.align,
      scope = _ref.scope,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = classNames('kuiTableHeaderCell', className, {
    'kuiTableHeaderCell--alignRight': align === RIGHT_ALIGNMENT
  });

  if (onSort) {
    var sortIconClasses = classNames('kuiTableSortIcon kuiIcon', {
      'fa-long-arrow-up': isSortAscending,
      'fa-long-arrow-down': !isSortAscending
    });
    var sortIcon = /*#__PURE__*/React.createElement("span", {
      className: sortIconClasses,
      "aria-hidden": "true"
    });
    var buttonClasses = classNames('kuiTableHeaderCellButton', {
      'kuiTableHeaderCellButton-isSorted': isSorted
    });
    var columnTitle = ariaLabel ? ariaLabel : children;
    var statefulAriaLabel = "Sort ".concat(columnTitle, " ").concat(isSortAscending ? 'descending' : 'ascending');
    return /*#__PURE__*/React.createElement("th", _extends({
      className: classes,
      scope: scope
    }, rest), /*#__PURE__*/React.createElement("button", {
      className: buttonClasses,
      onClick: onSort,
      "aria-label": statefulAriaLabel
    }, /*#__PURE__*/React.createElement("span", {
      className: "kuiTableHeaderCell__liner"
    }, children, sortIcon)));
  }

  return /*#__PURE__*/React.createElement("th", _extends({
    className: classes,
    "aria-label": ariaLabel,
    scope: scope
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "kuiTableHeaderCell__liner"
  }, children));
};
KuiTableHeaderCell.propTypes = {
  children: PropTypes.node,
  className: PropTypes.string,
  onSort: PropTypes.func,
  isSorted: PropTypes.bool,
  isSortAscending: PropTypes.bool,
  align: PropTypes.oneOf([LEFT_ALIGNMENT, RIGHT_ALIGNMENT]),
  scope: PropTypes.oneOf(['col', 'row', 'colgroup', 'rowgroup'])
};
KuiTableHeaderCell.defaultProps = {
  align: LEFT_ALIGNMENT,
  scope: 'col'
};
