/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.constants.TrustedCaIndicationIdentifierType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.TrustedAuthorityPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.TrustedCaIndicationExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;

public class TrustedCaIndicationExtensionPreparator
extends ExtensionPreparator<TrustedCaIndicationExtensionMessage> {
    private final TrustedCaIndicationExtensionMessage msg;

    public TrustedCaIndicationExtensionPreparator(Chooser chooser, TrustedCaIndicationExtensionMessage message, TrustedCaIndicationExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        this.msg.setTrustedAuthorities(this.chooser.getConfig().getTrustedCaIndicationExtensionAuthorties());
        int taLength = 0;
        for (TrustedAuthority ta : this.msg.getTrustedAuthorities()) {
            TrustedAuthorityPreparator preparator = new TrustedAuthorityPreparator(this.chooser, ta);
            preparator.prepare();
            taLength += this.getLength(ta);
        }
        this.msg.setTrustedAuthoritiesLength(taLength);
    }

    public int getLength(TrustedAuthority authority) {
        switch (TrustedCaIndicationIdentifierType.getIdentifierByByte((Byte)authority.getIdentifierType().getValue())) {
            case PRE_AGREED: {
                return 1;
            }
            case KEY_SHA1_HASH: {
                return 20;
            }
            case X509_NAME: {
                return 2 + (Integer)authority.getDistinguishedNameLength().getValue();
            }
            case CERT_SHA1_HASH: {
                return 20;
            }
        }
        return 0;
    }
}

