# Configure paths for cole when using `configure' script generated by `autoconf'
#
# To use:
#   Add the content of this file to your `acinclude.m4' file (in case this file
#   is not installed in your system), then run `aclocal' to generate
#   `aclocal.m4' file, then run `autoconf'. In your `configure.in' file, you can
#   add something like:
#   AM_PATH_COLE(2.0.0, [LIBS="$LIBS $COLE_LIBS" CFLAGS="$CFLAGS $COLE_CFLAGS"])

# Taken from GNOME CVS, from glib directory, which is distributed under GPL.
# Taken and modified by Arturo Tena <arturo@directmail.org>
# Original message:
#   Configure paths for GLIB
#   Owen Taylor     97-11-3

dnl AM_PATH_COLE([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for cole, and define COLE_CFLAGS and COLE_LIBS
AC_DEFUN(AM_PATH_COLE,
[dnl 
dnl Get the cflags and libraries from the cole-config script
dnl
AC_ARG_WITH(cole-prefix,[  --with-cole-prefix=PFX   Prefix where cole is installed (optional)],
            cole_config_prefix="$withval", cole_config_prefix="")
AC_ARG_WITH(cole-exec-prefix,[  --with-cole-exec-prefix=PFX Exec prefix where cole is installed (optional)],
            cole_config_exec_prefix="$withval", cole_config_exec_prefix="")
AC_ARG_ENABLE(coletest, [  --disable-coletest       Do not try to compile and run a test cole program],
                    , enable_coletest=yes)

  if test x$cole_config_exec_prefix != x ; then
     cole_config_args="$cole_config_args --exec-prefix=$cole_config_exec_prefix"
     if test x${COLE_CONFIG+set} != xset ; then
        COLE_CONFIG=$cole_config_exec_prefix/bin/cole-config
     fi
  fi
  if test x$cole_config_prefix != x ; then
     cole_config_args="$cole_config_args --prefix=$cole_config_prefix"
     if test x${COLE_CONFIG+set} != xset ; then
        COLE_CONFIG=$cole_config_prefix/bin/cole-config
     fi
  fi

  AC_PATH_PROG(COLE_CONFIG, cole-config, no)
dnl min_cole_version is set to   2.0.0 if not argument given.
  min_cole_version=ifelse([$1], ,2.0.0,$1)
  AC_MSG_CHECKING(for cole - version >= $min_cole_version)
  no_cole=""
  if test "$COLE_CONFIG" = "no" ; then
    no_cole=yes
  else
    COLE_CFLAGS=`$COLE_CONFIG $cole_config_args --cflags`
    COLE_LIBS=`$COLE_CONFIG $cole_config_args --libs`
    cole_config_major_version=`$COLE_CONFIG $cole_config_args --version | \
           sed 's/cole //' | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    cole_config_minor_version=`$COLE_CONFIG $cole_config_args --version | \
           sed 's/cole //' | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    cole_config_micro_version=`$COLE_CONFIG $cole_config_args --version | \
           sed 's/cole //' | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_coletest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $COLE_CFLAGS"
      LIBS="$COLE_LIBS $LIBS"
dnl
dnl Now check if the installed cole is sufficiently new. (Also sanity
dnl checks the results of cole-config to some extent
dnl
      rm -f conf.coletest
      AC_TRY_RUN([
#include <cole/cole.h>
#include <stdio.h>
#include <stdlib.h>

int
mystrlen (char * s)
{
	char *p;

	for (p = s; *p; p++) ;

	return p - s;
}

char *
mystrdup (char * s)
{
	char *ret;
	char *p1;
	char *p2;

	ret = malloc (mystrlen (s));
	if (ret == NULL)
		return NULL;

	p1 = s;
	p2 = ret;
	while (*p1) {
		*p2 = *p1;
		p1++;
		p2++;
	}

	return ret;
}

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.coletest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = mystrdup("$min_cole_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_cole_version");
     exit(1);
   }

  if ((cole_major_version != $cole_config_major_version) ||
      (cole_minor_version != $cole_config_minor_version) ||
      (cole_micro_version != $cole_config_micro_version))
    {
      printf("\n*** 'cole-config --version' returned %d.%d.%d, but cole (%d.%d.%d)\n", 
             $cole_config_major_version, $cole_config_minor_version, $cole_config_micro_version,
             cole_major_version, cole_minor_version, cole_micro_version);
      printf ("*** was found! If cole-config was correct, then it is best\n");
      printf ("*** to remove the old version of cole. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If cole-config was wrong, set the environment variable COLE_CONFIG\n");
      printf("*** to point to the correct copy of cole-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
    } 
  else if ((cole_major_version != COLE_MAJOR_VERSION) ||
           (cole_minor_version != COLE_MINOR_VERSION) ||
           (cole_micro_version != COLE_MICRO_VERSION))
    {
      printf("*** cole header files (version %d.%d.%d) do not match\n",
             COLE_MAJOR_VERSION, COLE_MINOR_VERSION, COLE_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
             cole_major_version, cole_minor_version, cole_micro_version);
    }
  else
    {
      if ((cole_major_version > major) ||
        ((cole_major_version == major) && (cole_minor_version > minor)) ||
        ((cole_major_version == major) && (cole_minor_version == minor) && (cole_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of cole (%d.%d.%d) was found.\n",
               cole_major_version, cole_minor_version, cole_micro_version);
        printf("*** You need a version of cole newer than %d.%d.%d. The latest version of\n",
               major, minor, micro);
        printf("*** cole is always available from http://arturo.directmail.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the cole-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of cole, but you can also set the COLE_CONFIG environment to point to the\n");
        printf("*** correct copy of cole-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_cole=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_cole" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$COLE_CONFIG" = "no" ; then
       echo "*** The cole-config script installed by cole could not be found"
       echo "*** If cole was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the COLE_CONFIG environment variable to the"
       echo "*** full path to cole-config."
     else
       if test -f conf.coletest ; then
        :
       else
          echo "*** Could not run cole test program, checking why..."
          CFLAGS="$CFLAGS $COLE_CFLAGS"
          LIBS="$LIBS $COLE_LIBS"
          AC_TRY_LINK([
#include <cole/cole.h>
#include <stdio.h>
],      [ return ((cole_major_version) || (cole_minor_version) || (cole_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding cole or finding the wrong"
          echo "*** version of cole. If it is not finding cole, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
          echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means cole was incorrectly installed"
          echo "*** or that you have moved cole since it was installed. In the latter case, you"
          echo "*** may want to edit the cole-config script: $COLE_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     COLE_CFLAGS=""
     COLE_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(COLE_CFLAGS)
  AC_SUBST(COLE_LIBS)
  rm -f conf.coletest
])

