/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "definedValues", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "definitions", "", "hasChanges", "", "localVariables", "", "namesToSubstitute", "", "namesWithSideEffects", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "temporary", "usages", "analyze", "", "apply", "assignVariable", "name", "value", "cleanUp", "isTrivial", "expr", "perform", "shouldConsiderTemporary", "shouldConsiderUnused", "useVariable", "SubstitutionCandidateFinder", "js.translator"})
public final class TemporaryVariableElimination {
    private final JsBlock root;
    private final Map<JsName, Integer> definitions;
    private final Map<JsName, Integer> usages;
    private final Map<JsName, JsExpression> definedValues;
    private final Set<JsName> temporary;
    private boolean hasChanges;
    private final Set<JsName> localVariables;
    private final Set<JsName> namesToSubstitute;
    private final Set<JsNode> statementsToRemove;
    private final Set<JsName> namesWithSideEffects;
    private final JsFunction function;

    public final boolean apply() {
        this.analyze();
        this.perform();
        this.cleanUp();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final Set<JsName> currentScope;
            @NotNull
            private Set<JsName> localVars;
            final /* synthetic */ TemporaryVariableElimination this$0;

            @NotNull
            public final Set<JsName> getCurrentScope() {
                return this.currentScope;
            }

            @NotNull
            public final Set<JsName> getLocalVars() {
                return this.localVars;
            }

            public final void setLocalVars(@NotNull Set<JsName> set) {
                Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
                this.localVars = set;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                if (!(jsExpression instanceof JsBinaryOperation)) {
                    jsExpression = null;
                }
                JsBinaryOperation jsBinaryOperation = (JsBinaryOperation)jsExpression;
                if (jsBinaryOperation != null) {
                    JsBinaryOperation jsBinaryOperation2 = jsBinaryOperation;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsBinaryOperation expression2 = jsBinaryOperation2;
                    boolean bl3 = false;
                    this.processBinaryExpression(expression2, MetadataProperties.getSynthetic(x), (Function0<Unit>)((Function0)new Function0<Unit>(this, x){
                        final /* synthetic */ analyze.1 this$0;
                        final /* synthetic */ JsExpressionStatement $x$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$x$inlined = jsExpressionStatement;
                            super(0);
                        }

                        public final void invoke() {
                            analyze.1.access$visitExpressionStatement$s-1623866647(this.this$0, this.$x$inlined);
                        }
                    }));
                    return;
                }
                super.visitExpressionStatement(x);
            }

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.processBinaryExpression(x, false, (Function0<Unit>)((Function0)new Function0<Unit>(this, x){
                    final /* synthetic */ analyze.1 this$0;
                    final /* synthetic */ JsBinaryOperation $x;

                    public final void invoke() {
                        analyze.1.access$visitBinaryExpression$s-1623866647(this.this$0, this.$x);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$x = jsBinaryOperation;
                        super(0);
                    }
                }));
            }

            /*
             * WARNING - void declaration
             */
            private final void processBinaryExpression(JsBinaryOperation expression2, boolean synthetic, Function0<Unit> orElse) {
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    void name;
                    Object object = assignment;
                    JsName jsName = (JsName)object.component1();
                    JsExpression value2 = (JsExpression)object.component2();
                    if (TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) {
                        void v0 = name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"name");
                        JsExpression jsExpression = value2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"value");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, (JsName)v0, jsExpression);
                        this.addVar((JsName)name);
                        this.accept((JsNode)value2);
                        if (synthetic) {
                            object = TemporaryVariableElimination.access$getTemporary$p(this.this$0);
                            boolean bl = false;
                            object.add(name);
                        }
                        return;
                    }
                }
                orElse.invoke();
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Iterator<JsVars.JsVar> iterator2 = x.getVars().iterator();
                while (iterator2.hasNext()) {
                    JsVars.JsVar v;
                    JsVars.JsVar jsVar = v = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"v");
                    JsName name = jsVar.getName();
                    JsExpression value2 = v.getInitExpression();
                    if (!TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) continue;
                    if (MetadataProperties.getSynthetic(x)) {
                        Collection collection = TemporaryVariableElimination.access$getTemporary$p(this.this$0);
                        boolean bl = false;
                        collection.add(name);
                    }
                    if (value2 == null) continue;
                    JsName jsName = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"name");
                    TemporaryVariableElimination.access$assignVariable(this.this$0, jsName, value2);
                    this.addVar(name);
                    this.accept((JsNode)value2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                JsName name = nameRef.getName();
                if (name != null && TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, name);
                    if (!this.currentScope.contains(name)) {
                        JsExpression jsExpression = Namer.getUndefinedExpression();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"Namer.getUndefinedExpression()");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name, jsExpression);
                    }
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Iterator<JsPropertyInitializer> iterator2 = x.getPropertyInitializers().iterator();
                while (iterator2.hasNext()) {
                    JsPropertyInitializer initializer2;
                    JsPropertyInitializer jsPropertyInitializer = initializer2 = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"initializer");
                    this.accept((JsNode)jsPropertyInitializer.getValueExpr());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitLoop(@NotNull JsLoop x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var5_5 = this_$iv;
                    boolean bl = false;
                    Set set = new LinkedHashSet<E>();
                    var5_5.setLocalVars(set);
                    boolean bl2 = false;
                    super.visitLoop(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll((Collection)collection, (Iterable)iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitIf(@NotNull JsIf x) {
                boolean bl;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.accept((JsNode)x.getIfExpression());
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var5_6 = this_$iv;
                    boolean bl2 = false;
                    Set set = new LinkedHashSet<E>();
                    var5_6.setLocalVars(set);
                    boolean bl3 = false;
                    this.accept((JsNode)x.getThenStatement());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    object = this_$iv.getLocalVars();
                    bl = false;
                    CollectionsKt.removeAll((Collection)collection, (Iterable)object);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
                JsStatement jsStatement = x.getElseStatement();
                if (jsStatement != null) {
                    JsStatement jsStatement2 = jsStatement;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    JsStatement it = jsStatement2;
                    boolean bl6 = false;
                    analyze.1 this_$iv2 = this;
                    boolean $i$f$withNewScope2 = false;
                    Set<JsName> localVarsBackup$iv2 = this_$iv2.getLocalVars();
                    try {
                        object = this_$iv2;
                        bl = false;
                        Set set = new LinkedHashSet<E>();
                        object.setLocalVars(set);
                        boolean bl7 = false;
                        this.accept((JsNode)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        Collection collection = this_$iv2.getCurrentScope();
                        Iterable iterable = this_$iv2.getLocalVars();
                        boolean bl8 = false;
                        CollectionsKt.removeAll((Collection)collection, (Iterable)iterable);
                        this_$iv2.setLocalVars(localVarsBackup$iv2);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCase(@NotNull JsCase x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var5_5 = this_$iv;
                    boolean bl = false;
                    Set set = new LinkedHashSet<E>();
                    var5_5.setLocalVars(set);
                    boolean bl2 = false;
                    super.visitCase(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll((Collection)collection, (Iterable)iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDefault(@NotNull JsDefault x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var5_5 = this_$iv;
                    boolean bl = false;
                    Set set = new LinkedHashSet<E>();
                    var5_5.setLocalVars(set);
                    boolean bl2 = false;
                    super.visitDefault(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll((Collection)collection, (Iterable)iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    analyze.1 var5_5 = this_$iv;
                    boolean bl = false;
                    Set set = new LinkedHashSet<E>();
                    var5_5.setLocalVars(set);
                    boolean bl2 = false;
                    super.visitCatch(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll((Collection)collection, (Iterable)iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Iterator<JsName> iterator2 = CollectUtilsKt.collectFreeVariables(x).iterator();
                while (iterator2.hasNext()) {
                    JsName freeVar;
                    JsName jsName = freeVar = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"freeVar");
                    TemporaryVariableElimination.access$useVariable(this.this$0, jsName);
                    TemporaryVariableElimination.access$useVariable(this.this$0, freeVar);
                }
            }

            private final void addVar(JsName name) {
                Collection collection = this.currentScope;
                boolean bl = false;
                collection.add(name);
                this.localVars.add(name);
            }
            {
                Set set;
                this.this$0 = $outer;
                List<JsParameter> list2 = TemporaryVariableElimination.access$getFunction$p($outer).getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.parameters");
                this.currentScope = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)analyze.currentScope.1.INSTANCE));
                analyze.1 var3_2 = this;
                boolean bl = false;
                var3_2.localVars = set = (Set)new LinkedHashSet<E>();
            }

            public static final /* synthetic */ void access$visitExpressionStatement$s-1623866647(analyze.1 $this, JsExpressionStatement x) {
                super.visitExpressionStatement(x);
            }

            public static final /* synthetic */ void access$visitBinaryExpression$s-1623866647(analyze.1 $this, JsBinaryOperation x) {
                super.visitBinaryExpression(x);
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final List<Pair<JsName, JsNode>> lastAssignedVars;
            final /* synthetic */ TemporaryVariableElimination this$0;

            @NotNull
            public final List<Pair<JsName, JsNode>> getLastAssignedVars() {
                return this.lastAssignedVars;
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                JsExpression expression2 = jsExpression;
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    void name;
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName jsName = (JsName)pair.component1();
                    JsExpression value2 = (JsExpression)pair.component2();
                    void v1 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"name");
                    JsExpression jsExpression2 = value2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"value");
                    this.handleDefinition((JsName)v1, jsExpression2, x);
                } else if (this.handleExpression(expression2)) {
                    this.invalidateTemporaries();
                }
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Iterator<JsVars.JsVar> iterator2 = x.getVars().iterator();
                while (iterator2.hasNext()) {
                    JsVars.JsVar v;
                    JsVars.JsVar jsVar = v = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"v");
                    JsExpression initializer2 = jsVar.getInitExpression();
                    if (initializer2 == null) continue;
                    JsName jsName = v.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"v.name");
                    this.handleDefinition(jsName, initializer2, v);
                }
            }

            private final void handleDefinition(JsName name, JsExpression value2, JsNode node) {
                boolean sideEffects;
                boolean bl = sideEffects = this.handleExpression(value2) || !TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name);
                if (TemporaryVariableElimination.access$shouldConsiderTemporary(this.this$0, name)) {
                    if (TemporaryVariableElimination.access$isTrivial(this.this$0, value2)) {
                        Collection collection = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                        boolean bl2 = false;
                        collection.add(node);
                        collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0);
                        bl2 = false;
                        collection.add(name);
                    } else {
                        Collection collection = this.lastAssignedVars;
                        Pair pair = new Pair((Object)name, (Object)node);
                        boolean bl3 = false;
                        collection.add(pair);
                        if (sideEffects) {
                            collection = TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0);
                            boolean bl4 = false;
                            collection.add(name);
                        }
                    }
                } else if (sideEffects) {
                    this.invalidateTemporaries();
                }
            }

            public void visitIf(@NotNull JsIf x) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                    JsExpression jsExpression = x.getIfExpression();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.ifExpression");
                    this.handleExpression(jsExpression);
                    this.invalidateTemporaries();
                    this.accept((JsNode)x.getThenStatement());
                    this.invalidateTemporaries();
                    JsStatement jsStatement = x.getElseStatement();
                    if (jsStatement == null) break block0;
                    JsStatement jsStatement2 = jsStatement;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsStatement it = jsStatement2;
                    boolean bl3 = false;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2 = jsExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsExpression it = jsExpression2;
                    boolean bl3 = false;
                    this.handleExpression(it);
                }
                this.invalidateTemporaries();
            }

            public void visitThrow(@NotNull JsThrow x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                List<JsSwitchMember> list2 = x.getCases();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.cases");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsSwitchMember it = (JsSwitchMember)element$iv;
                    boolean bl = false;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Iterator<JsPropertyInitializer> iterator2 = x.getPropertyInitializers().iterator();
                while (iterator2.hasNext()) {
                    JsPropertyInitializer initializer2;
                    JsPropertyInitializer jsPropertyInitializer = initializer2 = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"initializer");
                    this.accept((JsNode)jsPropertyInitializer.getValueExpr());
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitWhile(x);
                this.invalidateTemporaries();
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitDoWhile(x);
                this.invalidateTemporaries();
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.objectExpression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitFor(@NotNull JsFor x) {
                JsVars it;
                boolean bl;
                boolean bl2;
                SourceInfoAwareJsNode sourceInfoAwareJsNode;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsVars jsVars = x.getInitVars();
                if (jsVars != null) {
                    sourceInfoAwareJsNode = jsVars;
                    bl2 = false;
                    bl = false;
                    it = sourceInfoAwareJsNode;
                    boolean bl3 = false;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression = x.getInitExpression();
                if (jsExpression != null) {
                    sourceInfoAwareJsNode = jsExpression;
                    bl2 = false;
                    bl = false;
                    it = sourceInfoAwareJsNode;
                    boolean bl4 = false;
                    this.handleExpression((JsExpression)((Object)it));
                }
                this.invalidateTemporaries();
                JsExpression jsExpression2 = x.getCondition();
                if (jsExpression2 != null) {
                    sourceInfoAwareJsNode = jsExpression2;
                    bl2 = false;
                    bl = false;
                    it = sourceInfoAwareJsNode;
                    boolean bl5 = false;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression3 = x.getIncrementExpression();
                if (jsExpression3 != null) {
                    sourceInfoAwareJsNode = jsExpression3;
                    bl2 = false;
                    bl = false;
                    it = sourceInfoAwareJsNode;
                    boolean bl6 = false;
                    this.accept((JsNode)it);
                }
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitTry(@NotNull JsTry x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitTry(x);
                this.invalidateTemporaries();
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitCatch(x);
                this.invalidateTemporaries();
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitLabel(x);
                this.invalidateTemporaries();
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.invalidateTemporaries();
            }

            private final void invalidateTemporaries() {
                this.lastAssignedVars.clear();
            }

            /*
             * WARNING - void declaration
             */
            private final boolean handleExpression(JsExpression expression2) {
                SubstitutionCandidateFinder candidateFinder = this.this$0.new SubstitutionCandidateFinder();
                candidateFinder.accept((JsNode)expression2);
                List<JsName> candidates2 = candidateFinder.getSubstitutableVariableReferences();
                while (true) {
                    void assignedVar;
                    Object object = this.lastAssignedVars;
                    boolean bl = false;
                    if (!(!object.isEmpty())) break;
                    Pair pair = (Pair)CollectionsKt.last(this.lastAssignedVars);
                    object = (JsName)pair.component1();
                    JsNode assignedStatement = (JsNode)pair.component2();
                    int candidateIndex = candidates2.lastIndexOf(assignedVar);
                    if (candidateIndex < 0) break;
                    Collection collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0);
                    boolean bl2 = false;
                    collection.add(assignedVar);
                    collection = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                    bl2 = false;
                    collection.add(assignedStatement);
                    if (TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0).contains(assignedVar)) {
                        candidateFinder.setSideEffectOccurred(true);
                    }
                    candidates2 = candidates2.subList(0, candidateIndex);
                    this.lastAssignedVars.remove(CollectionsKt.getLastIndex(this.lastAssignedVars));
                }
                return candidateFinder.getSideEffectOccurred();
            }
            {
                List list2;
                this.this$0 = $outer;
                perform.1 var3_2 = this;
                boolean bl = false;
                var3_2.lastAssignedVars = list2 = (List)new ArrayList<E>();
            }
        }.accept((JsNode)this.root);
    }

    private final void cleanUp() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryVariableElimination this$0;

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsVars x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                List<JsVars.JsVar> list2 = x.getVars();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.vars");
                Collection collection = list2;
                Pair<List<JsVars.JsVar>, S> pair2 = (Pair<List<JsVars.JsVar>, S>)TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                boolean bl = false;
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                if (TypeIntrinsics.asMutableCollection((Object)collection2).removeAll((Collection<?>)pair2)) {
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                }
                List<JsVars.JsVar> list3 = x.getVars();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"x.vars");
                List<Pair<List<JsVars.JsVar>, S>> ranges2 = UtilsKt.splitToRanges(list3, (Function1)new Function1<JsVars.JsVar, Boolean>(this){
                    final /* synthetic */ cleanUp.1 this$0;

                    public final boolean invoke(JsVars.JsVar it) {
                        TemporaryVariableElimination temporaryVariableElimination = this.this$0.this$0;
                        JsVars.JsVar jsVar = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"it");
                        JsName jsName = jsVar.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"it.name");
                        return TemporaryVariableElimination.access$shouldConsiderUnused(temporaryVariableElimination, jsName);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                if (ranges2.size() == 1 && !((Boolean)ranges2.get(0).getSecond()).booleanValue()) {
                    return super.visit(x, ctx);
                }
                TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                for (Pair<List<JsVars.JsVar>, S> pair2 : ranges2) {
                    JsVars.JsVar[] jsVarArray;
                    void $this$toTypedArray$iv;
                    Object object;
                    JsContext<JsNode> jsContext;
                    Object initializer22;
                    Object $this$mapNotNullTo$iv$iv;
                    void subList;
                    List list4 = (List)pair2.component1();
                    boolean isRemoved = (Boolean)pair2.component2();
                    Iterable $this$mapNotNull$iv = (Iterable)subList;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        JsExpression jsExpression;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        JsVars.JsVar it = (JsVars.JsVar)element$iv$iv;
                        boolean bl3 = false;
                        JsVars.JsVar jsVar = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsVar, (String)"it");
                        if (jsVar.getInitExpression() == null) continue;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        JsExpression it$iv$iv = jsExpression;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List initializers = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = initializers;
                    boolean $i$f$forEach2 = false;
                    $this$mapNotNullTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$mapNotNullTo$iv$iv.hasNext()) {
                        T element$iv = $this$mapNotNullTo$iv$iv.next();
                        JsExpression it = (JsExpression)element$iv;
                        boolean bl7 = false;
                        this.accept((JsNode)it);
                    }
                    if (isRemoved) {
                        for (Object initializer22 : initializers) {
                            $this$mapNotNullTo$iv$iv = new JsExpressionStatement((JsExpression)this.accept((JsNode)initializer22));
                            jsContext = ctx;
                            boolean element$iv = false;
                            boolean it = false;
                            Object $this$apply = $this$mapNotNullTo$iv$iv;
                            boolean bl8 = false;
                            MetadataProperties.setSynthetic((HasMetadata)$this$apply, true);
                            object = $this$mapNotNullTo$iv$iv;
                            jsContext.addPrevious((JsNode)object);
                        }
                        continue;
                    }
                    initializer22 = (Collection)subList;
                    jsContext = ctx;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new JsVars.JsVar[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    JsVars.JsVar[] jsVarArray2 = Arrays.copyOf(jsVarArray, jsVarArray.length);
                    JsVars jsVars = new JsVars(jsVarArray2);
                    boolean bl9 = false;
                    boolean bl10 = false;
                    JsVars $this$apply = jsVars;
                    boolean bl11 = false;
                    MetadataProperties.setSynthetic($this$apply, true);
                    object = jsVars;
                    jsContext.addPrevious((JsNode)object);
                }
                ctx.removeMe();
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Pair<JsName, JsExpression> assignment;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                if (TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    ctx.removeMe();
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                    return false;
                }
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null && CollectionsKt.contains((Iterable)TemporaryVariableElimination.access$getLocalVariables$p(this.this$0), (Object)((JsNameRef)expression2).getName())) {
                    MetadataProperties.setSynthetic(x, true);
                }
                if ((assignment = JsAstUtils.decomposeAssignmentToVariable(expression2)) != null) {
                    void name;
                    Object object = assignment;
                    JsName jsName = (JsName)object.component1();
                    JsExpression value2 = (JsExpression)object.component2();
                    void v1 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"name");
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, (JsName)v1)) {
                        TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                        object = this.accept((JsNode)new JsExpressionStatement(value2));
                        JsContext<JsNode> jsContext = ctx;
                        boolean bl = false;
                        boolean bl2 = false;
                        JsExpressionStatement $this$apply = (JsExpressionStatement)object;
                        boolean bl3 = false;
                        MetadataProperties.setSynthetic($this$apply, true);
                        Object object2 = object;
                        jsContext.replaceMe(object2);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                Iterator<JsPropertyInitializer> iterator2 = x.getPropertyInitializers().iterator();
                while (iterator2.hasNext()) {
                    JsPropertyInitializer initializer2;
                    JsPropertyInitializer jsPropertyInitializer = initializer2 = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"initializer");
                    this.accept((JsNode)jsPropertyInitializer.getValueExpr());
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                JsName name = x.getName();
                if (name != null && x.getQualifier() == null && TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0).contains(name)) {
                    V v = TemporaryVariableElimination.access$getDefinedValues$p(this.this$0).get(name);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    JsExpression replacement2 = (JsExpression)this.accept((JsNode)v);
                    JsExpression jsExpression = replacement2.deepCopy();
                    JsContext<JsNode> jsContext = ctx;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsExpression $this$apply = jsExpression;
                    boolean bl3 = false;
                    MetadataProperties.setSynthetic($this$apply, true);
                    JsExpression jsExpression2 = jsExpression;
                    jsContext.replaceMe((JsNode)jsExpression2);
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                return false;
            }

            public void endVisit(@NotNull JsBinaryOperation x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Intrinsics.checkParameterIsNotNull(ctx, (String)"ctx");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x);
                if (assignment != null) {
                    JsName name;
                    JsName jsName = name = (JsName)assignment.getFirst();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"name");
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, jsName)) {
                        JsNode jsNode = this.accept((JsNode)x.getArg2());
                        JsContext<JsNode> jsContext = ctx;
                        boolean bl = false;
                        boolean bl2 = false;
                        JsExpression $this$apply = (JsExpression)jsNode;
                        boolean bl3 = false;
                        MetadataProperties.setSynthetic($this$apply, true);
                        JsNode jsNode2 = jsNode;
                        jsContext.replaceMe(jsNode2);
                    }
                }
                super.endVisit(x, ctx);
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void assignVariable(JsName name, JsExpression value2) {
        Integer n = this.definitions.get(name);
        this.definitions.put(name, (n != null ? n : 0) + 1);
        this.definedValues.put(name, value2);
    }

    private final void useVariable(JsName name) {
        Integer n = this.usages.get(name);
        this.usages.put(name, (n != null ? n : 0) + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderUnused(JsName name) {
        Integer n = this.definitions.get(name);
        if (n == null) return false;
        int n2 = n;
        if (n2 <= 0) return false;
        Integer n3 = this.usages.get(name);
        if ((n3 != null ? n3 : 0) != 0) return false;
        if (!this.temporary.contains(name)) return false;
        if (MetadataProperties.getImported(name)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderTemporary(JsName name) {
        Integer n = this.definitions.get(name);
        if (n == null) return false;
        if (n != 1) return false;
        if (!this.temporary.contains(name)) {
            return false;
        }
        JsExpression expr = this.definedValues.get(name);
        if (expr != null) {
            if (this.isTrivial(expr)) return true;
        }
        Integer n2 = this.usages.get(name);
        if (n2 == null) return false;
        if (n2 != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(JsExpression expr) {
        JsExpression jsExpression = expr;
        if (jsExpression instanceof JsNameRef) {
            JsExpression qualifier = ((JsNameRef)expr).getQualifier();
            if (MetadataProperties.getSideEffects(expr) == SideEffectKind.PURE && (qualifier == null || this.isTrivial(qualifier))) {
                if (CollectionsKt.contains((Iterable)this.temporary, (Object)((JsNameRef)expr).getName())) return false;
                return true;
            }
            JsName name = ((JsNameRef)expr).getName();
            if (!CollectionsKt.contains((Iterable)this.localVariables, (Object)name)) return false;
            Object object = this.definitions;
            boolean bl = false;
            Integer n = object.get(name);
            if (n == null || n == 0) {
                return true;
            }
            if (n != 1) return false;
            if (!CollectionsKt.contains((Iterable)this.namesToSubstitute, (Object)name)) return true;
            object = this.definedValues;
            bl = false;
            JsExpression jsExpression2 = (JsExpression)object.get(name);
            if (jsExpression2 == null) return false;
            object = jsExpression2;
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            boolean bl4 = this.isTrivial((JsExpression)it);
            if (!bl4) return false;
            return true;
        }
        if (jsExpression instanceof JsLiteral.JsValueLiteral) {
            if (expr.toString().length() >= 10) return false;
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression3;
            if (MetadataProperties.getSideEffects(expr) != SideEffectKind.PURE) return false;
            JsExpression jsExpression4 = ((JsInvocation)expr).getQualifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression4, (String)"expr.qualifier");
            if (!this.isTrivial(jsExpression4)) return false;
            List<JsExpression> list2 = ((JsInvocation)expr).getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expr.arguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                JsExpression it = (JsExpression)element$iv;
                boolean bl = false;
                jsExpression3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"it");
            } while (this.isTrivial(jsExpression3));
            return false;
        }
        if (!(jsExpression instanceof JsArrayAccess)) return false;
        JsExpression jsExpression5 = ((JsArrayAccess)expr).getArrayExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression5, (String)"expr.arrayExpression");
        if (!this.isTrivial(jsExpression5)) return false;
        JsExpression jsExpression6 = ((JsArrayAccess)expr).getIndexExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression6, (String)"expr.indexExpression");
        if (!this.isTrivial(jsExpression6)) return false;
        if (MetadataProperties.getSideEffects(expr) != SideEffectKind.PURE) return false;
        return true;
    }

    public TemporaryVariableElimination(@NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        this.function = function2;
        JsBlock jsBlock = this.function.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"function.body");
        this.root = jsBlock;
        TemporaryVariableElimination temporaryVariableElimination = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        temporaryVariableElimination.definitions = object;
        temporaryVariableElimination = this;
        bl = false;
        object = new LinkedHashMap();
        temporaryVariableElimination.usages = object;
        temporaryVariableElimination = this;
        bl = false;
        object = new LinkedHashMap();
        temporaryVariableElimination.definedValues = object;
        temporaryVariableElimination = this;
        bl = false;
        temporaryVariableElimination.temporary = object = (Set)new LinkedHashSet();
        this.localVariables = CollectUtilsKt.collectLocalVariables(this.function);
        temporaryVariableElimination = this;
        bl = false;
        temporaryVariableElimination.namesToSubstitute = object = (Set)new LinkedHashSet();
        temporaryVariableElimination = this;
        bl = false;
        temporaryVariableElimination.statementsToRemove = object = (Set)new LinkedHashSet();
        temporaryVariableElimination = this;
        bl = false;
        temporaryVariableElimination.namesWithSideEffects = object = (Set)new LinkedHashSet();
    }

    public static final /* synthetic */ void access$assignVariable(TemporaryVariableElimination $this, JsName name, JsExpression value2) {
        $this.assignVariable(name, value2);
    }

    public static final /* synthetic */ Set access$getTemporary$p(TemporaryVariableElimination $this) {
        return $this.temporary;
    }

    public static final /* synthetic */ void access$useVariable(TemporaryVariableElimination $this, JsName name) {
        $this.useVariable(name);
    }

    public static final /* synthetic */ JsFunction access$getFunction$p(TemporaryVariableElimination $this) {
        return $this.function;
    }

    public static final /* synthetic */ boolean access$isTrivial(TemporaryVariableElimination $this, JsExpression expr) {
        return $this.isTrivial(expr);
    }

    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryVariableElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ Set access$getNamesWithSideEffects$p(TemporaryVariableElimination $this) {
        return $this.namesWithSideEffects;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(TemporaryVariableElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryVariableElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    public static final /* synthetic */ boolean access$shouldConsiderUnused(TemporaryVariableElimination $this, JsName name) {
        return $this.shouldConsiderUnused(name);
    }

    public static final /* synthetic */ Map access$getDefinedValues$p(TemporaryVariableElimination $this) {
        return $this.definedValues;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination$SubstitutionCandidateFinder;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;)V", "sideEffectOccurred", "", "getSideEffectOccurred", "()Z", "setSideEffectOccurred", "(Z)V", "substitutableVariableReferences", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getSubstitutableVariableReferences", "()Ljava/util/List;", "visitArray", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "visitConditional", "Lorg/jetbrains/kotlin/js/backend/ast/JsConditional;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitNew", "Lorg/jetbrains/kotlin/js/backend/ast/JsNew;", "visitObjectLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "js.translator"})
    private final class SubstitutionCandidateFinder
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsName> substitutableVariableReferences;
        private boolean sideEffectOccurred;

        @NotNull
        public final List<JsName> getSubstitutableVariableReferences() {
            return this.substitutableVariableReferences;
        }

        public final boolean getSideEffectOccurred() {
            return this.sideEffectOccurred;
        }

        public final void setSideEffectOccurred(boolean bl) {
            this.sideEffectOccurred = bl;
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            Iterator<JsPropertyInitializer> iterator2 = x.getPropertyInitializers().iterator();
            while (iterator2.hasNext()) {
                JsPropertyInitializer initializer2;
                JsPropertyInitializer jsPropertyInitializer = initializer2 = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsPropertyInitializer, (String)"initializer");
                this.accept((JsNode)jsPropertyInitializer.getValueExpr());
            }
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitNew(@NotNull JsNew x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            super.visitNew(x);
            if (MetadataProperties.getSideEffects(x) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
            super.visitInvocation(invocation);
            if (MetadataProperties.getSideEffects(invocation) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            this.accept((JsNode)x.getTestExpression());
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            super.visitArrayAccess(x);
            if (MetadataProperties.getSideEffects(x) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            super.visitArray(x);
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            super.visitPrefixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            if (jsUnaryOperator != null) {
                switch (TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.sideEffectOccurred = true;
                        break;
                    }
                }
            }
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            super.visitPostfixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            if (jsUnaryOperator != null) {
                switch (TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings.$EnumSwitchMapping$1[jsUnaryOperator.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.sideEffectOccurred = true;
                        break;
                    }
                }
            }
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
            JsName name = nameRef.getName();
            if (name != null && TemporaryVariableElimination.this.localVariables.contains(name)) {
                if (!TemporaryVariableElimination.this.namesToSubstitute.contains(name) && TemporaryVariableElimination.this.shouldConsiderTemporary(name) && !this.sideEffectOccurred) {
                    Collection collection = this.substitutableVariableReferences;
                    boolean bl = false;
                    collection.add(name);
                }
            } else {
                super.visitNameRef(nameRef);
                if (MetadataProperties.getSideEffects(nameRef) == SideEffectKind.AFFECTS_STATE) {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            if (x.getOperator() == JsBinaryOperator.ASG) {
                JsExpression left = x.getArg1();
                JsExpression right = x.getArg2();
                if (left instanceof JsNameRef) {
                    JsExpression qualifier = ((JsNameRef)left).getQualifier();
                    if (qualifier != null) {
                        this.accept((JsNode)qualifier);
                    }
                } else if (left instanceof JsArrayAccess) {
                    this.accept((JsNode)((JsArrayAccess)left).getArrayExpression());
                    this.accept((JsNode)((JsArrayAccess)left).getIndexExpression());
                }
                this.accept((JsNode)right);
                this.sideEffectOccurred = true;
            } else if (x.getOperator() == JsBinaryOperator.AND || x.getOperator() == JsBinaryOperator.OR) {
                this.accept((JsNode)x.getArg1());
                this.sideEffectOccurred = true;
                this.accept((JsNode)x.getArg2());
            } else {
                super.visitBinaryExpression(x);
            }
        }

        public SubstitutionCandidateFinder() {
            List list2;
            SubstitutionCandidateFinder substitutionCandidateFinder = this;
            boolean bl = false;
            substitutionCandidateFinder.substitutableVariableReferences = list2 = (List)new ArrayList();
        }
    }
}

