/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultProjectStateRegistry
implements ProjectStateRegistry {
    private final WorkerLeaseService workerLeaseService;
    private final Object lock = new Object();
    private final Map<Path, ProjectStateImpl> projectsByPath = Maps.newLinkedHashMap();
    private final Map<ProjectComponentIdentifier, ProjectStateImpl> projectsById = Maps.newLinkedHashMap();
    private final Map<Pair<BuildIdentifier, Path>, ProjectStateImpl> projectsByCompId = Maps.newLinkedHashMap();
    private final AtomicReference<Thread> ownerOfAllProjects = new AtomicReference();
    private final Set<Thread> canDoAnythingToAnyProject = new CopyOnWriteArraySet<Thread>();

    public DefaultProjectStateRegistry(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProjects(BuildState owner) {
        Set<DefaultProjectDescriptor> allProjects = owner.getLoadedSettings().getProjectRegistry().getAllProjects();
        Object object = this.lock;
        synchronized (object) {
            for (DefaultProjectDescriptor descriptor : allProjects) {
                this.addProject(owner, descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProject(BuildState owner, DefaultProjectDescriptor projectDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            this.addProject(owner, projectDescriptor);
        }
    }

    private void addProject(BuildState owner, DefaultProjectDescriptor descriptor) {
        Path projectPath = descriptor.path();
        Path identityPath = owner.getIdentityPathForProject(projectPath);
        ProjectComponentIdentifier projectIdentifier = owner.getIdentifierForProject(projectPath);
        ProjectStateImpl projectState = new ProjectStateImpl(owner, identityPath, projectPath, descriptor.getName(), projectIdentifier);
        this.projectsByPath.put(identityPath, projectState);
        this.projectsById.put(projectIdentifier, projectState);
        this.projectsByCompId.put((Pair<BuildIdentifier, Path>)Pair.of((Object)owner.getBuildIdentifier(), (Object)projectPath), projectState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProjectStateImpl> getAllProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByPath.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(Project project) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByPath.get(((ProjectInternal)project).getIdentityPath());
            if (projectState == null) {
                throw new IllegalArgumentException("Could not find state for " + project);
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(ProjectComponentIdentifier identifier) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsById.get(identifier);
            if (projectState == null) {
                throw new IllegalArgumentException(identifier.getDisplayName() + " not found.");
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(BuildIdentifier buildIdentifier, Path projectPath) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByCompId.get(Pair.of((Object)buildIdentifier, (Object)projectPath));
            if (projectState == null) {
                throw new IllegalArgumentException(buildIdentifier + " project " + projectPath + " not found.");
            }
            return projectState;
        }
    }

    @Override
    public void withMutableStateOfAllProjects(Runnable runnable) {
        this.withMutableStateOfAllProjects(Factories.toFactory((Runnable)runnable));
    }

    @Override
    public <T> T withMutableStateOfAllProjects(Factory<T> factory) {
        if (!this.ownerOfAllProjects.compareAndSet(null, Thread.currentThread())) {
            if (this.ownerOfAllProjects.get() == Thread.currentThread()) {
                return (T)factory.create();
            }
            throw new IllegalStateException(String.format("Another thread (%s) currently holds the state lock for all projects.", this.ownerOfAllProjects));
        }
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.ownerOfAllProjects.set(null);
        }
    }

    @Override
    public void allowUncontrolledAccessToAnyProject(Runnable runnable) {
        this.allowUncontrolledAccessToAnyProject(Factories.toFactory((Runnable)runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T allowUncontrolledAccessToAnyProject(Factory<T> factory) {
        Thread currentThread = Thread.currentThread();
        boolean added = this.canDoAnythingToAnyProject.add(currentThread);
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            if (added) {
                this.canDoAnythingToAnyProject.remove(currentThread);
            }
        }
    }

    private static class CalculatedModelValueImpl<T>
    implements CalculatedModelValue<T> {
        private final WorkerLeaseService workerLeaseService;
        private final ModelContainer<?> owner;
        private final ReentrantLock lock = new ReentrantLock();
        private volatile T value;

        public CalculatedModelValueImpl(ProjectStateImpl owner, WorkerLeaseService workerLeaseService, @Nullable T initialValue) {
            this.workerLeaseService = workerLeaseService;
            this.value = initialValue;
            this.owner = owner;
        }

        @Override
        public T get() throws IllegalStateException {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                throw new IllegalStateException("No calculated value is available for " + this.owner);
            }
            return currentValue;
        }

        @Override
        public T getOrNull() {
            return this.value;
        }

        @Override
        public void set(T newValue) {
            this.assertCanMutate();
            this.value = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T update(Function<T, T> updateFunction) {
            this.acquireUpdateLock();
            try {
                T newValue = updateFunction.apply(this.value);
                this.value = newValue;
                T t = newValue;
                return t;
            }
            finally {
                this.releaseUpdateLock();
            }
        }

        private void acquireUpdateLock() {
            this.assertCanMutate();
            if (this.lock.tryLock()) {
                return;
            }
            this.workerLeaseService.withoutProjectLock(this.lock::lock);
        }

        private void assertCanMutate() {
            if (!this.owner.hasMutableState()) {
                throw new IllegalStateException("Current thread does not hold the state lock for " + this.owner);
            }
        }

        private void releaseUpdateLock() {
            this.lock.unlock();
        }
    }

    private class ProjectStateImpl
    implements ProjectState {
        private final Path projectPath;
        private final String projectName;
        private final ProjectComponentIdentifier identifier;
        private final BuildState owner;
        private final Path identityPath;
        private final ResourceLock projectLock;
        private final Set<Thread> canDoAnythingToThisProject = new CopyOnWriteArraySet<Thread>();
        private ProjectInternal project;

        ProjectStateImpl(BuildState owner, Path identityPath, Path projectPath, String projectName, ProjectComponentIdentifier identifier) {
            this.owner = owner;
            this.identityPath = identityPath;
            this.projectPath = projectPath;
            this.projectName = projectName;
            this.identifier = identifier;
            this.projectLock = DefaultProjectStateRegistry.this.workerLeaseService.getProjectLock(owner.getIdentityPath(), identityPath);
        }

        public String toString() {
            return this.identifier.getDisplayName();
        }

        @Override
        public BuildState getOwner() {
            return this.owner;
        }

        @Override
        @Nullable
        public ProjectState getParent() {
            return this.identityPath.getParent() == null ? null : (ProjectState)DefaultProjectStateRegistry.this.projectsByPath.get(this.identityPath.getParent());
        }

        @Override
        public String getName() {
            return this.projectName;
        }

        @Override
        public Path getIdentityPath() {
            return this.identityPath;
        }

        @Override
        public Path getProjectPath() {
            return this.projectPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attachMutableModel(ProjectInternal project) {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                if (this.project != null) {
                    throw new IllegalStateException(String.format("The project object for project %s has already been attached.", this.getIdentityPath()));
                }
                this.project = project;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProjectInternal getMutableModel() {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                if (this.project == null) {
                    throw new IllegalStateException(String.format("The project object for project %s has not been attached yet.", this.getIdentityPath()));
                }
                return this.project;
            }
        }

        @Override
        public ProjectComponentIdentifier getComponentIdentifier() {
            return this.identifier;
        }

        @Override
        public ResourceLock getAccessLock() {
            return this.projectLock;
        }

        @Override
        public void applyToMutableState(Consumer<? super ProjectInternal> action) {
            this.fromMutableState((Function)p -> {
                action.accept((ProjectInternal)p);
                return null;
            });
        }

        @Override
        public <S> S fromMutableState(Function<? super ProjectInternal, ? extends S> function) {
            Thread currentThread = Thread.currentThread();
            if (DefaultProjectStateRegistry.this.canDoAnythingToAnyProject.contains(currentThread) || this.canDoAnythingToThisProject.contains(currentThread)) {
                return function.apply(this.getMutableModel());
            }
            Thread currentOwner = (Thread)DefaultProjectStateRegistry.this.ownerOfAllProjects.get();
            if (currentOwner != null) {
                if (currentOwner == currentThread) {
                    return function.apply(this.getMutableModel());
                }
                throw new IllegalStateException(String.format("Cannot acquire state lock for %s as another thread (%s) currently holds the state lock for all projects.", this.project, currentOwner));
            }
            Collection currentLocks = DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks();
            if (currentLocks.contains(this.projectLock)) {
                if (currentLocks.size() == 1) {
                    return function.apply(this.getMutableModel());
                }
                currentLocks = Lists.newArrayList((Iterable)currentLocks);
                currentLocks.remove(this.projectLock);
                return (S)DefaultProjectStateRegistry.this.workerLeaseService.withoutLocks((Iterable)currentLocks, () -> function.apply(this.getMutableModel()));
            }
            if (!currentLocks.isEmpty()) {
                return (S)DefaultProjectStateRegistry.this.workerLeaseService.withoutLocks((Iterable)currentLocks, () -> this.withProjectLock(this.projectLock, function));
            }
            return this.withProjectLock(this.projectLock, function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forceAccessToMutableState(Consumer<? super ProjectInternal> action) {
            Thread currentThread = Thread.currentThread();
            boolean added = this.canDoAnythingToThisProject.add(currentThread);
            try {
                action.accept(this.getMutableModel());
            }
            finally {
                if (added) {
                    this.canDoAnythingToThisProject.remove(currentThread);
                }
            }
        }

        private <S> S withProjectLock(ResourceLock projectLock, Function<? super ProjectInternal, ? extends S> function) {
            return (S)DefaultProjectStateRegistry.this.workerLeaseService.withLocks(Collections.singleton(projectLock), () -> function.apply(this.getMutableModel()));
        }

        @Override
        public boolean hasMutableState() {
            Thread currentThread = Thread.currentThread();
            return this.canDoAnythingToThisProject.contains(currentThread) || DefaultProjectStateRegistry.this.canDoAnythingToAnyProject.contains(currentThread) || DefaultProjectStateRegistry.this.ownerOfAllProjects.get() == currentThread || DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks().contains(this.projectLock);
        }

        @Override
        public <T> CalculatedModelValue<T> newCalculatedValue(@Nullable T initialValue) {
            return new CalculatedModelValueImpl<T>(this, DefaultProjectStateRegistry.this.workerLeaseService, initialValue);
        }
    }
}

