/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestExecuter;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultSerializer;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.TestFrameworkOptions;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.ConfigureUtil;

@NonNullApi
@CacheableTask
public class Test
extends AbstractTestTask
implements JavaForkOptions,
PatternFilterable {
    private final JavaForkOptions forkOptions;
    private final ModularitySpec modularity;
    private final Property<JavaLauncher> javaLauncher;
    private FileCollection testClassesDirs;
    private final PatternFilterable patternSet = (PatternFilterable)this.getPatternSetFactory().create();
    private FileCollection classpath = this.getObjectFactory().fileCollection();
    private final ConfigurableFileCollection stableClasspath = this.getObjectFactory().fileCollection();
    private TestFramework testFramework;
    private boolean scanForTestClasses = true;
    private long forkEvery;
    private int maxParallelForks = 1;
    private TestExecuter<JvmTestExecutionSpec> testExecuter;

    public Test() {
        this.stableClasspath.from(new Object[]{new Callable<Object>(){

            @Override
            public Object call() {
                return Test.this.getClasspath();
            }
        }});
        this.forkOptions = this.getForkOptionsFactory().newDecoratedJavaForkOptions();
        this.forkOptions.setEnableAssertions(true);
        this.forkOptions.setExecutable(null);
        this.modularity = (ModularitySpec)this.getObjectFactory().newInstance(DefaultModularitySpec.class, new Object[0]);
        this.javaLauncher = this.getObjectFactory().property(JavaLauncher.class);
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ActorFactory getActorFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    @Deprecated
    protected ClassLoaderCache getClassLoaderCache() {
        DeprecationLogger.deprecateMethod(Test.class, (String)"getClassLoaderCache()").willBeRemovedInGradle7().undocumented().nagUser();
        return (ClassLoaderCache)this.getServices().get(ClassLoaderCache.class);
    }

    @Inject
    protected WorkerProcessFactory getProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Factory<PatternSet> getPatternSetFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaForkOptionsFactory getForkOptionsFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModuleRegistry getModuleRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaModuleDetector getJavaModuleDetector() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public File getWorkingDir() {
        return this.forkOptions.getWorkingDir();
    }

    public void setWorkingDir(File dir) {
        this.forkOptions.setWorkingDir(dir);
    }

    public void setWorkingDir(Object dir) {
        this.forkOptions.setWorkingDir(dir);
    }

    public Test workingDir(Object dir) {
        this.forkOptions.workingDir(dir);
        return this;
    }

    @Input
    public JavaVersion getJavaVersion() {
        return ((JvmVersionDetector)this.getServices().get(JvmVersionDetector.class)).getJavaVersion(this.getEffectiveExecutable());
    }

    @Internal
    public String getExecutable() {
        return this.forkOptions.getExecutable();
    }

    public Test executable(Object executable) {
        this.forkOptions.executable(executable);
        return this;
    }

    public void setExecutable(String executable) {
        this.forkOptions.setExecutable(executable);
    }

    public void setExecutable(Object executable) {
        this.forkOptions.setExecutable(executable);
    }

    public Map<String, Object> getSystemProperties() {
        return this.forkOptions.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.forkOptions.setSystemProperties(properties);
    }

    public Test systemProperties(Map<String, ?> properties) {
        this.forkOptions.systemProperties(properties);
        return this;
    }

    public Test systemProperty(String name, Object value) {
        this.forkOptions.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.forkOptions.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.forkOptions.setBootstrapClasspath(classpath);
    }

    public Test bootstrapClasspath(Object ... classpath) {
        this.forkOptions.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.forkOptions.getMinHeapSize();
    }

    public String getDefaultCharacterEncoding() {
        return this.forkOptions.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.forkOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public void setMinHeapSize(String heapSize) {
        this.forkOptions.setMinHeapSize(heapSize);
    }

    public String getMaxHeapSize() {
        return this.forkOptions.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.forkOptions.setMaxHeapSize(heapSize);
    }

    public List<String> getJvmArgs() {
        return this.forkOptions.getJvmArgs();
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.forkOptions.getJvmArgumentProviders();
    }

    public void setJvmArgs(List<String> arguments) {
        this.forkOptions.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.forkOptions.setJvmArgs(arguments);
    }

    public Test jvmArgs(Iterable<?> arguments) {
        this.forkOptions.jvmArgs(arguments);
        return this;
    }

    public Test jvmArgs(Object ... arguments) {
        this.forkOptions.jvmArgs(arguments);
        return this;
    }

    public boolean getEnableAssertions() {
        return this.forkOptions.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.forkOptions.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.forkOptions.getDebug();
    }

    @Option(option="debug-jvm", description="Enable debugging for the test process. The process is started suspended and listening on port 5005.")
    public void setDebug(boolean enabled) {
        this.forkOptions.setDebug(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.forkOptions.getDebugOptions();
    }

    public void debugOptions(Action<JavaDebugOptions> action) {
        this.forkOptions.debugOptions(action);
    }

    @Option(option="fail-fast", description="Stops test execution after the first failed test.")
    public void setFailFast(boolean failFast) {
        super.setFailFast(failFast);
    }

    public boolean getFailFast() {
        return super.getFailFast();
    }

    public List<String> getAllJvmArgs() {
        return this.forkOptions.getAllJvmArgs();
    }

    public void setAllJvmArgs(List<String> arguments) {
        this.forkOptions.setAllJvmArgs(arguments);
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.forkOptions.setAllJvmArgs(arguments);
    }

    @Internal
    public Map<String, Object> getEnvironment() {
        return this.forkOptions.getEnvironment();
    }

    public Test environment(Map<String, ?> environmentVariables) {
        this.forkOptions.environment(environmentVariables);
        return this;
    }

    public Test environment(String name, Object value) {
        this.forkOptions.environment(name, value);
        return this;
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.forkOptions.setEnvironment(environmentVariables);
    }

    public Test copyTo(ProcessForkOptions target) {
        this.forkOptions.copyTo(target);
        this.copyToolchainAsExecutable(target);
        return this;
    }

    public Test copyTo(JavaForkOptions target) {
        this.forkOptions.copyTo(target);
        this.copyToolchainAsExecutable((ProcessForkOptions)target);
        return this;
    }

    private void copyToolchainAsExecutable(ProcessForkOptions target) {
        target.setExecutable(this.getEffectiveExecutable());
    }

    @Incubating
    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    protected JvmTestExecutionSpec createTestExecutionSpec() {
        this.validateToolchainConfiguration();
        JavaForkOptionsInternal javaForkOptions = this.getForkOptionsFactory().newJavaForkOptions();
        this.copyTo((JavaForkOptions)javaForkOptions);
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        boolean testIsModule = javaModuleDetector.isModule(((Boolean)this.modularity.getInferModulePath().get()).booleanValue(), this.getTestClassesDirs());
        FileCollection classpath = javaModuleDetector.inferClasspath(testIsModule, (FileCollection)this.stableClasspath);
        FileCollection modulePath = javaModuleDetector.inferModulePath(testIsModule, (FileCollection)this.stableClasspath);
        return new JvmTestExecutionSpec(this.getTestFramework(), (Iterable<? extends File>)classpath, (Iterable<? extends File>)modulePath, this.getCandidateClassFiles(), this.isScanForTestClasses(), this.getTestClassesDirs(), this.getPath(), this.getIdentityPath(), this.getForkEvery(), (JavaForkOptions)javaForkOptions, this.getMaxParallelForks(), this.getPreviousFailedTestClasses());
    }

    private void validateToolchainConfiguration() {
        if (this.javaLauncher.isPresent()) {
            Preconditions.checkState((this.forkOptions.getExecutable() == null ? 1 : 0) != 0, (Object)"Must not use `executable` property on `Test` together with `javaLauncher` property");
        }
    }

    private Set<String> getPreviousFailedTestClasses() {
        TestResultSerializer serializer = new TestResultSerializer(this.getBinResultsDir());
        if (serializer.isHasResults()) {
            final HashSet<String> previousFailedTestClasses = new HashSet<String>();
            serializer.read((Action)new Action<TestClassResult>(){

                public void execute(TestClassResult testClassResult) {
                    if (testClassResult.getFailuresCount() > 0) {
                        previousFailedTestClasses.add(testClassResult.getClassName());
                    }
                }
            });
            return previousFailedTestClasses;
        }
        return Collections.emptySet();
    }

    @TaskAction
    public void executeTests() {
        JavaVersion javaVersion = this.getJavaVersion();
        if (!javaVersion.isJava6Compatible()) {
            throw new UnsupportedJavaRuntimeException("Support for test execution using Java 5 or earlier was removed in Gradle 3.0.");
        }
        if (this.getDebug()) {
            this.getLogger().info("Running tests for remote debugging.");
        }
        try {
            super.executeTests();
        }
        finally {
            this.testFramework = null;
        }
    }

    protected TestExecuter<JvmTestExecutionSpec> createTestExecuter() {
        if (this.testExecuter == null) {
            return new DefaultTestExecuter(this.getProcessBuilderFactory(), this.getActorFactory(), this.getModuleRegistry(), (WorkerLeaseRegistry)this.getServices().get(WorkerLeaseRegistry.class), (BuildOperationExecutor)this.getServices().get(BuildOperationExecutor.class), ((StartParameter)this.getServices().get(StartParameter.class)).getMaxWorkerCount(), (Clock)this.getServices().get(Clock.class), (DocumentationRegistry)this.getServices().get(DocumentationRegistry.class), (DefaultTestFilter)this.getFilter());
        }
        return this.testExecuter;
    }

    protected List<String> getNoMatchingTestErrorReasons() {
        ArrayList reasons = Lists.newArrayList();
        if (!this.getIncludes().isEmpty()) {
            reasons.add(this.getIncludes() + "(include rules)");
        }
        if (!this.getExcludes().isEmpty()) {
            reasons.add(this.getExcludes() + "(exclude rules)");
        }
        reasons.addAll(super.getNoMatchingTestErrorReasons());
        return reasons;
    }

    public Test include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    public Test include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    public Test include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public Test include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public Test exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public Test exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public Test exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public Test exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public Test setTestNameIncludePatterns(List<String> testNamePattern) {
        super.setTestNameIncludePatterns(testNamePattern);
        return this;
    }

    @Internal
    public FileCollection getTestClassesDirs() {
        return this.testClassesDirs;
    }

    public void setTestClassesDirs(FileCollection testClassesDirs) {
        this.testClassesDirs = testClassesDirs;
    }

    @Internal
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public Test setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    @Internal
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public Test setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }

    @Internal
    public TestFramework getTestFramework() {
        return this.testFramework(null);
    }

    public TestFramework testFramework(@Nullable Closure testFrameworkConfigure) {
        if (this.testFramework == null) {
            this.useJUnit(testFrameworkConfigure);
        }
        return this.testFramework;
    }

    @Nested
    public TestFrameworkOptions getOptions() {
        return this.getTestFramework().getOptions();
    }

    public TestFrameworkOptions options(Closure testFrameworkConfigure) {
        return (TestFrameworkOptions)ConfigureUtil.configure((Closure)testFrameworkConfigure, (Object)this.getOptions());
    }

    public TestFrameworkOptions options(Action<? super TestFrameworkOptions> testFrameworkConfigure) {
        TestFrameworkOptions options = this.getOptions();
        testFrameworkConfigure.execute((Object)options);
        return options;
    }

    TestFramework useTestFramework(TestFramework testFramework) {
        return this.useTestFramework(testFramework, null);
    }

    private <T extends TestFrameworkOptions> TestFramework useTestFramework(TestFramework testFramework, @Nullable Action<? super T> testFrameworkConfigure) {
        if (testFramework == null) {
            throw new IllegalArgumentException("testFramework is null!");
        }
        this.testFramework = testFramework;
        if (testFrameworkConfigure != null) {
            testFrameworkConfigure.execute(Cast.uncheckedNonnullCast((Object)this.testFramework.getOptions()));
        }
        return this.testFramework;
    }

    public void useJUnit() {
        this.useJUnit((Action<? super JUnitOptions>)Actions.doNothing());
    }

    public void useJUnit(@Nullable Closure testFrameworkConfigure) {
        this.useJUnit((Action<? super JUnitOptions>)ConfigureUtil.configureUsing((Closure)testFrameworkConfigure));
    }

    public void useJUnit(Action<? super JUnitOptions> testFrameworkConfigure) {
        this.useTestFramework(new JUnitTestFramework(this, (DefaultTestFilter)this.getFilter()), testFrameworkConfigure);
    }

    public void useJUnitPlatform() {
        this.useJUnitPlatform((Action<? super JUnitPlatformOptions>)Actions.doNothing());
    }

    public void useJUnitPlatform(Action<? super JUnitPlatformOptions> testFrameworkConfigure) {
        this.useTestFramework(new JUnitPlatformTestFramework((DefaultTestFilter)this.getFilter()), testFrameworkConfigure);
    }

    public void useTestNG() {
        this.useTestNG((Action<? super TestNGOptions>)Actions.doNothing());
    }

    public void useTestNG(Closure testFrameworkConfigure) {
        this.useTestNG((Action<? super TestNGOptions>)ConfigureUtil.configureUsing((Closure)testFrameworkConfigure));
    }

    public void useTestNG(Action<? super TestNGOptions> testFrameworkConfigure) {
        this.useTestFramework(new TestNGTestFramework(this, (FileCollection)this.stableClasspath, (DefaultTestFilter)this.getFilter(), this.getObjectFactory()), testFrameworkConfigure);
    }

    @Incubating
    @Classpath
    protected FileCollection getStableClasspath() {
        return this.stableClasspath;
    }

    @Internal(value="captured by stableClasspath")
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public boolean isScanForTestClasses() {
        return this.scanForTestClasses;
    }

    public void setScanForTestClasses(boolean scanForTestClasses) {
        this.scanForTestClasses = scanForTestClasses;
    }

    @Internal
    public long getForkEvery() {
        return this.getDebug() ? 0L : this.forkEvery;
    }

    public void setForkEvery(@Nullable Long forkEvery) {
        if (forkEvery != null && forkEvery < 0L) {
            throw new IllegalArgumentException("Cannot set forkEvery to a value less than 0.");
        }
        this.forkEvery = forkEvery == null ? 0L : forkEvery;
    }

    @Internal
    public int getMaxParallelForks() {
        return this.getDebug() ? 1 : this.maxParallelForks;
    }

    public void setMaxParallelForks(int maxParallelForks) {
        if (maxParallelForks < 1) {
            throw new IllegalArgumentException("Cannot set maxParallelForks to a value less than 1.");
        }
        this.maxParallelForks = maxParallelForks;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @SkipWhenEmpty
    public FileTree getCandidateClassFiles() {
        return this.getTestClassesDirs().getAsFileTree().matching(this.patternSet);
    }

    public void filter(Action<TestFilter> action) {
        action.execute((Object)this.getFilter());
    }

    void setTestExecuter(TestExecuter<JvmTestExecutionSpec> testExecuter) {
        this.testExecuter = testExecuter;
    }

    @Incubating
    @Internal(value="getJavaVersion() is used as @Input")
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @Nullable
    private String getEffectiveExecutable() {
        if (this.javaLauncher.isPresent()) {
            return ((JavaLauncher)this.javaLauncher.get()).getExecutablePath().toString();
        }
        String executable = this.getExecutable();
        return executable == null ? Jvm.current().getJavaExecutable().getAbsolutePath() : executable;
    }
}

