/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.CompositeExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;

abstract class DefaultCompositeExclude
implements CompositeExclude {
    private final ImmutableSet<ExcludeSpec> components;
    private final int hashCode;
    private final int size;

    DefaultCompositeExclude(ImmutableSet<ExcludeSpec> components) {
        this.components = components;
        this.size = components.size();
        this.hashCode = 31 * components.hashCode() + this.size ^ this.mask();
    }

    abstract int mask();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCompositeExclude that = (DefaultCompositeExclude)o;
        return this.hashCode == that.hashCode && Objects.equal(this.components, that.components);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public final Stream<ExcludeSpec> components() {
        return this.components.stream();
    }

    @Override
    public Set<ExcludeSpec> getComponents() {
        return this.components;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return "{\"" + this.getDisplayName() + "\":  " + this.components + '}';
    }

    protected abstract String getDisplayName();
}

