"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = adPlugin;

var _constants = require("../../utils/constants");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
function adPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ad = components.clientAction.namespaceFactory();
  const ad = Client.prototype.ad.prototype;
  ad.deleteDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  ad.previewDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_preview`
    },
    needBody: true,
    method: 'POST'
  });
  ad.createDetector = ca({
    url: {
      fmt: _constants.API.DETECTOR_BASE
    },
    needBody: true,
    method: 'POST'
  });
  ad.validateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_validate/<%=validationType%>`,
      req: {
        validationType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchTasks = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/tasks/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.updateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  ad.getDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?job=true&task=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.searchResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchResultsFromCustomResultIndex = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search/<%=resultIndex%>?only_query_custom_result_index=<%=onlyQueryCustomResultIndex%>`,
      req: {
        resultIndex: {
          type: 'string',
          required: false
        },
        onlyQueryCustomResultIndex: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.startDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.startHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.stopDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.stopHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.detectorProfile = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_profile/init_progress,state,error`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.matchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/match?name=<%=detectorName%>`,
      req: {
        detectorName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  ad.detectorCount = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/count`
    },
    method: 'GET'
  });
  ad.topAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=false`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.topHistoricalAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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