/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;

public class CompactPathRule
extends Rule
implements Rule.ApplyURI {
    public CompactPathRule() {
        this._handling = false;
        this._terminating = false;
    }

    @Override
    public void applyURI(Request request, String oldURI, String newURI) throws IOException {
        String uri = request.getRequestURI();
        if (uri.startsWith("/")) {
            uri = URIUtil.compactPath((String)uri);
        }
        request.setURIPathQuery(uri);
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.startsWith("/")) {
            return URIUtil.compactPath((String)target);
        }
        return target;
    }
}

