/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.response.transform;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.ltr.CSVFeatureLogger;
import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRRescorer;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.ltr.LTRThreadModule;
import org.apache.solr.ltr.SolrQueryRequestContextUtils;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.interleaving.LTRInterleavingScoringQuery;
import org.apache.solr.ltr.interleaving.OriginalRankingLTRScoringQuery;
import org.apache.solr.ltr.model.LTRScoringModel;
import org.apache.solr.ltr.norm.Normalizer;
import org.apache.solr.ltr.search.LTRQParserPlugin;
import org.apache.solr.ltr.store.FeatureStore;
import org.apache.solr.ltr.store.rest.ManagedFeatureStore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;

public class LTRFeatureLoggerTransformerFactory
extends TransformerFactory {
    private static final String FV_FORMAT = "format";
    private static final String FV_STORE = "store";
    private static String DEFAULT_LOGGING_MODEL_NAME = "logging-model";
    private String fvCacheName;
    private String loggingModelName = DEFAULT_LOGGING_MODEL_NAME;
    private String defaultStore;
    private FeatureLogger.FeatureFormat defaultFormat = FeatureLogger.FeatureFormat.DENSE;
    private char csvKeyValueDelimiter = (char)61;
    private char csvFeatureSeparator = (char)44;
    private LTRThreadModule threadManager = null;

    public void setFvCacheName(String fvCacheName) {
        this.fvCacheName = fvCacheName;
    }

    public void setLoggingModelName(String loggingModelName) {
        this.loggingModelName = loggingModelName;
    }

    public void setDefaultStore(String defaultStore) {
        this.defaultStore = defaultStore;
    }

    public void setDefaultFormat(String defaultFormat) {
        this.defaultFormat = FeatureLogger.FeatureFormat.valueOf(defaultFormat.toUpperCase(Locale.ROOT));
    }

    public void setCsvKeyValueDelimiter(String csvKeyValueDelimiter) {
        if (csvKeyValueDelimiter.length() != 1) {
            throw new IllegalArgumentException("csvKeyValueDelimiter must be exactly 1 character");
        }
        this.csvKeyValueDelimiter = csvKeyValueDelimiter.charAt(0);
    }

    public void setCsvFeatureSeparator(String csvFeatureSeparator) {
        if (csvFeatureSeparator.length() != 1) {
            throw new IllegalArgumentException("csvFeatureSeparator must be exactly 1 character");
        }
        this.csvFeatureSeparator = csvFeatureSeparator.charAt(0);
    }

    public void init(NamedList args) {
        super.init(args);
        this.threadManager = LTRThreadModule.getInstance(args);
        SolrPluginUtils.invokeSetters((Object)((Object)this), (Iterable)args);
    }

    public DocTransformer create(String name, SolrParams localparams, SolrQueryRequest req) {
        SolrQueryRequestContextUtils.setIsExtractingFeatures(req);
        String fvStoreName = localparams.get(FV_STORE);
        SolrQueryRequestContextUtils.setFvStoreName(req, fvStoreName == null ? this.defaultStore : fvStoreName);
        SolrQueryRequestContextUtils.setFeatureLogger(req, this.createFeatureLogger(localparams.get(FV_FORMAT)));
        return new FeatureTransformer(name, localparams, req, fvStoreName != null);
    }

    private FeatureLogger createFeatureLogger(String formatStr) {
        FeatureLogger.FeatureFormat format = formatStr != null ? FeatureLogger.FeatureFormat.valueOf(formatStr.toUpperCase(Locale.ROOT)) : this.defaultFormat;
        if (this.fvCacheName == null) {
            throw new IllegalArgumentException("a fvCacheName must be configured");
        }
        return new CSVFeatureLogger(this.fvCacheName, format, this.csvKeyValueDelimiter, this.csvFeatureSeparator);
    }

    private static class LoggingModel
    extends LTRScoringModel {
        public LoggingModel(String name, String featureStoreName, List<Feature> allFeatures) {
            this(name, Collections.emptyList(), Collections.emptyList(), featureStoreName, allFeatures, Collections.emptyMap());
        }

        protected LoggingModel(String name, List<Feature> features, List<Normalizer> norms, String featureStoreName, List<Feature> allFeatures, Map<String, Object> params) {
            super(name, features, norms, featureStoreName, allFeatures, params);
        }

        @Override
        public float score(float[] modelFeatureValuesNormalized) {
            return 0.0f;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc, float finalScore, List<Explanation> featureExplanations) {
            return Explanation.match((Number)Float.valueOf(finalScore), (String)(this.toString() + " logging model, used only for logging the features"), (Explanation[])new Explanation[0]);
        }
    }

    class FeatureTransformer
    extends DocTransformer {
        private final String name;
        private final SolrParams localparams;
        private final SolrQueryRequest req;
        private final boolean hasExplicitFeatureStore;
        private List<LeafReaderContext> leafContexts;
        private SolrIndexSearcher searcher;
        private LTRScoringQuery[] rerankingQueriesFromContext;
        private LTRScoringQuery[] rerankingQueries;
        private LTRScoringQuery.ModelWeight[] modelWeights;
        private FeatureLogger featureLogger;
        private boolean docsWereNotReranked;

        public FeatureTransformer(String name, SolrParams localparams, SolrQueryRequest req, boolean hasExplicitFeatureStore) {
            this.name = name;
            this.localparams = localparams;
            this.req = req;
            this.hasExplicitFeatureStore = hasExplicitFeatureStore;
        }

        public String getName() {
            return this.name;
        }

        public void setContext(ResultContext context) {
            super.setContext(context);
            if (context == null) {
                return;
            }
            if (context.getRequest() == null) {
                return;
            }
            this.searcher = context.getSearcher();
            if (this.searcher == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "searcher is null");
            }
            this.leafContexts = this.searcher.getTopReaderContext().leaves();
            if (LTRFeatureLoggerTransformerFactory.this.threadManager != null) {
                LTRFeatureLoggerTransformerFactory.this.threadManager.setExecutor(context.getRequest().getCore().getCoreContainer().getUpdateShardHandler().getUpdateExecutor());
            }
            this.rerankingQueriesFromContext = SolrQueryRequestContextUtils.getScoringQueries(this.req);
            this.docsWereNotReranked = this.rerankingQueriesFromContext == null || this.rerankingQueriesFromContext.length == 0;
            String transformerFeatureStore = SolrQueryRequestContextUtils.getFvStoreName(this.req);
            Map<String, String[]> transformerExternalFeatureInfo = LTRQParserPlugin.extractEFIParams(this.localparams);
            LoggingModel loggingModel = this.createLoggingModel(transformerFeatureStore);
            this.setupRerankingQueriesForLogging(transformerFeatureStore, transformerExternalFeatureInfo, loggingModel);
            this.setupRerankingWeightsForLogging(context);
        }

        private LoggingModel createLoggingModel(String transformerFeatureStore) {
            ManagedFeatureStore fr = ManagedFeatureStore.getManagedFeatureStore(this.req.getCore());
            FeatureStore store = fr.getFeatureStore(transformerFeatureStore);
            transformerFeatureStore = store.getName();
            return new LoggingModel(LTRFeatureLoggerTransformerFactory.this.loggingModelName, transformerFeatureStore, store.getFeatures());
        }

        private void setupRerankingQueriesForLogging(String transformerFeatureStore, Map<String, String[]> transformerExternalFeatureInfo, LoggingModel loggingModel) {
            if (this.docsWereNotReranked) {
                LTRScoringQuery loggingQuery = new LTRScoringQuery(loggingModel, transformerExternalFeatureInfo, true, LTRFeatureLoggerTransformerFactory.this.threadManager);
                this.rerankingQueries = new LTRScoringQuery[]{loggingQuery};
            } else {
                this.rerankingQueries = new LTRScoringQuery[this.rerankingQueriesFromContext.length];
                System.arraycopy(this.rerankingQueriesFromContext, 0, this.rerankingQueries, 0, this.rerankingQueriesFromContext.length);
                if (transformerFeatureStore != null) {
                    LTRScoringModel matchingRerankingModel = loggingModel;
                    for (LTRScoringQuery rerankingQuery : this.rerankingQueries) {
                        if (rerankingQuery instanceof OriginalRankingLTRScoringQuery || !transformerFeatureStore.equals(rerankingQuery.getScoringModel().getFeatureStoreName())) continue;
                        matchingRerankingModel = rerankingQuery.getScoringModel();
                    }
                    for (int i = 0; i < this.rerankingQueries.length; ++i) {
                        this.rerankingQueries[i] = new LTRScoringQuery(matchingRerankingModel, !transformerExternalFeatureInfo.isEmpty() ? transformerExternalFeatureInfo : this.rerankingQueries[i].getExternalFeatureInfo(), true, LTRFeatureLoggerTransformerFactory.this.threadManager);
                    }
                }
            }
        }

        private void setupRerankingWeightsForLogging(ResultContext context) {
            this.modelWeights = new LTRScoringQuery.ModelWeight[this.rerankingQueries.length];
            for (int i = 0; i < this.rerankingQueries.length; ++i) {
                if (this.rerankingQueries[i].getOriginalQuery() == null) {
                    this.rerankingQueries[i].setOriginalQuery(context.getQuery());
                }
                this.rerankingQueries[i].setRequest(this.req);
                if (this.rerankingQueries[i] instanceof OriginalRankingLTRScoringQuery && !this.hasExplicitFeatureStore) continue;
                if (this.rerankingQueries[i].getFeatureLogger() == null) {
                    this.rerankingQueries[i].setFeatureLogger(SolrQueryRequestContextUtils.getFeatureLogger(this.req));
                }
                this.featureLogger = this.rerankingQueries[i].getFeatureLogger();
                try {
                    this.modelWeights[i] = this.rerankingQueries[i].createWeight((IndexSearcher)this.searcher, ScoreMode.COMPLETE, 1.0f);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
                }
                if (this.modelWeights[i] != null) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error logging the features, model weight is null");
            }
        }

        public void transform(SolrDocument doc, int docid, float score) throws IOException {
            this.implTransform(doc, docid, Float.valueOf(score));
        }

        public void transform(SolrDocument doc, int docid) throws IOException {
            this.implTransform(doc, docid, null);
        }

        private void implTransform(SolrDocument doc, int docid, Float score) throws IOException {
            LTRScoringQuery rerankingQuery = this.rerankingQueries[0];
            LTRScoringQuery.ModelWeight rerankingModelWeight = this.modelWeights[0];
            for (int i = 1; i < this.rerankingQueries.length; ++i) {
                if (!((LTRInterleavingScoringQuery)this.rerankingQueriesFromContext[i]).getPickedInterleavingDocIds().contains(docid)) continue;
                rerankingQuery = this.rerankingQueries[i];
                rerankingModelWeight = this.modelWeights[i];
            }
            if (!(rerankingQuery instanceof OriginalRankingLTRScoringQuery) || this.hasExplicitFeatureStore) {
                String featureVector = this.featureLogger.getFeatureVector(docid, rerankingQuery, this.searcher);
                if (featureVector == null) {
                    featureVector = this.featureLogger.makeFeatureVector(LTRRescorer.extractFeaturesInfo(rerankingModelWeight, docid, this.docsWereNotReranked ? score : null, this.leafContexts));
                }
                doc.addField(this.name, (Object)featureVector);
            }
        }
    }
}

