/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Cutter;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorCutLocal;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.TopologicalOperations;
import java.util.ArrayList;

class OperatorCutCursor
extends GeometryCursor {
    boolean m_bConsiderTouch;
    Geometry m_cuttee;
    Polyline m_cutter;
    double m_tolerance;
    ProgressTracker m_progressTracker;
    int m_cutIndex;
    ArrayList<MultiPath> m_cuts = null;

    OperatorCutCursor(boolean bConsiderTouch, Geometry cuttee, Polyline cutter, SpatialReference spatialReference, ProgressTracker progressTracker) {
        if (cuttee == null || cutter == null) {
            throw new GeometryException("invalid argument");
        }
        this.m_bConsiderTouch = bConsiderTouch;
        this.m_cuttee = cuttee;
        this.m_cutter = cutter;
        Envelope2D e = InternalUtils.getMergedExtent(cuttee, cutter);
        this.m_tolerance = InternalUtils.calculateToleranceFromGeometry(spatialReference, e, true);
        this.m_cutIndex = -1;
        this.m_progressTracker = progressTracker;
    }

    @Override
    public int getGeometryID() {
        return 0;
    }

    @Override
    public Geometry next() {
        this.generateCuts_();
        if (++this.m_cutIndex < this.m_cuts.size()) {
            return this.m_cuts.get(this.m_cutIndex);
        }
        return null;
    }

    private void generateCuts_() {
        if (this.m_cuts != null) {
            return;
        }
        this.m_cuts = new ArrayList();
        Geometry.Type type = this.m_cuttee.getType();
        switch (type.value()) {
            case 1607: {
                this.generate_polyline_cuts_();
                break;
            }
            case 1736: {
                this.generate_polygon_cuts_();
                break;
            }
        }
    }

    private void generate_polyline_cuts_() {
        Polyline left = new Polyline();
        Polyline right = new Polyline();
        Polyline uncut = new Polyline();
        this.m_cuts.add(left);
        this.m_cuts.add(right);
        ArrayList<OperatorCutLocal.CutPair> cutPairs = new ArrayList<OperatorCutLocal.CutPair>(0);
        Cutter.CutPolyline(this.m_bConsiderTouch, (Polyline)this.m_cuttee, this.m_cutter, this.m_tolerance, cutPairs, null, this.m_progressTracker);
        for (int icut = 0; icut < cutPairs.size(); ++icut) {
            OperatorCutLocal.CutPair cutPair = cutPairs.get(icut);
            if (cutPair.m_side == 0) {
                left.add((MultiPath)cutPair.m_geometry, false);
                continue;
            }
            if (cutPair.m_side == 1 || cutPair.m_side == 2) {
                right.add((MultiPath)cutPair.m_geometry, false);
                continue;
            }
            if (cutPair.m_side == 3) {
                this.m_cuts.add((MultiPath)cutPair.m_geometry);
                continue;
            }
            uncut.add((MultiPath)cutPair.m_geometry, false);
        }
        if (!(uncut.isEmpty() || left.isEmpty() && right.isEmpty() && this.m_cuts.size() < 3)) {
            this.m_cuts.add(uncut);
        }
        if (left.isEmpty() && right.isEmpty() && this.m_cuts.size() < 3) {
            this.m_cuts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate_polygon_cuts_() {
        AttributeStreamOfInt32 cutHandles = new AttributeStreamOfInt32(0);
        EditShape shape = new EditShape();
        int sideIndex = shape.createGeometryUserIndex();
        int cutteeHandle = shape.addGeometry(this.m_cuttee);
        int cutterHandle = shape.addGeometry(this.m_cutter);
        TopologicalOperations topoOp = new TopologicalOperations();
        try {
            topoOp.setEditShapeCrackAndCluster(shape, this.m_tolerance, this.m_progressTracker);
            topoOp.cut(sideIndex, cutteeHandle, cutterHandle, cutHandles);
            Polygon cutteeRemainder = (Polygon)shape.getGeometry(cutteeHandle);
            Polygon left = new Polygon();
            Polygon right = new Polygon();
            this.m_cuts.clear();
            this.m_cuts.add(left);
            this.m_cuts.add(right);
            for (int icutIndex = 0; icutIndex < cutHandles.size(); ++icutIndex) {
                EditShape shapeIntersect = new EditShape();
                int geometryA = shapeIntersect.addGeometry(cutteeRemainder);
                int geometryB = shapeIntersect.addGeometry(shape.getGeometry(cutHandles.get(icutIndex)));
                topoOp.setEditShape(shapeIntersect, this.m_progressTracker);
                int intersectHandle = topoOp.intersection(geometryA, geometryB);
                Geometry cutGeometry = shapeIntersect.getGeometry(intersectHandle);
                if (cutGeometry.isEmpty()) continue;
                int side = shape.getGeometryUserIndex(cutHandles.get(icutIndex), sideIndex);
                if (side == 2) {
                    left.add((MultiPath)cutGeometry, false);
                } else if (side == 1) {
                    right.add((MultiPath)cutGeometry, false);
                } else {
                    this.m_cuts.add((MultiPath)cutGeometry);
                }
                EditShape shapeDifference = new EditShape();
                geometryA = shapeDifference.addGeometry(cutteeRemainder);
                geometryB = shapeDifference.addGeometry(shape.getGeometry(cutHandles.get(icutIndex)));
                topoOp.setEditShape(shapeDifference, this.m_progressTracker);
                cutteeRemainder = (Polygon)shapeDifference.getGeometry(topoOp.difference(geometryA, geometryB));
            }
            if (!cutteeRemainder.isEmpty() && cutHandles.size() > 0) {
                this.m_cuts.add(cutteeRemainder);
            }
            if (left.isEmpty() && right.isEmpty()) {
                this.m_cuts.clear();
            }
        }
        finally {
            topoOp.removeShape();
        }
    }
}

