/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Paint;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.PlotElement;

class SourcedPlotElement
extends PlotElement {
    final String srcName;
    final SourcedPlotElement parent;
    double[] values;

    SourcedPlotElement(String srcName, Paint color) {
        super(color);
        this.srcName = srcName;
        this.parent = null;
    }

    SourcedPlotElement(String srcName, Paint color, SourcedPlotElement parent) {
        super(color);
        this.srcName = srcName;
        this.parent = parent;
    }

    void assignValues(DataProcessor dproc) {
        this.values = this.parent == null ? dproc.getValues(this.srcName) : this.stackValues(dproc);
    }

    double[] stackValues(DataProcessor dproc) {
        double[] parentValues = this.parent.getValues();
        double[] procValues = dproc.getValues(this.srcName);
        double[] stacked = new double[procValues.length];
        for (int i = 0; i < stacked.length; ++i) {
            stacked[i] = Double.isNaN(parentValues[i]) ? procValues[i] : (Double.isNaN(procValues[i]) ? parentValues[i] : parentValues[i] + procValues[i]);
        }
        return stacked;
    }

    Paint getParentColor() {
        return this.parent != null ? this.parent.color : null;
    }

    double[] getValues() {
        return this.values;
    }

    double getMinValue() {
        return Util.min(this.values);
    }

    double getMaxValue() {
        return Util.max(this.values);
    }
}

