/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificatePair;
import org.bouncycastle.jce.X509LDAPCertStoreParameters;
import org.bouncycastle.jce.provider.X509AttrCertParser;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.jce.provider.X509CertPairParser;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.util.StoreException;
import org.bouncycastle.x509.X509AttributeCertStoreSelector;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509CertPairStoreSelector;
import org.bouncycastle.x509.X509CertStoreSelector;
import org.bouncycastle.x509.X509CertificatePair;
import org.bouncycastle.x509.util.StreamParsingException;

public class LDAPStoreHelper {
    private X509LDAPCertStoreParameters params;
    private static String LDAP_PROVIDER = "com.sun.jndi.ldap.LdapCtxFactory";
    private static String REFERRALS_IGNORE = "ignore";
    private static final String SEARCH_SECURITY_LEVEL = "none";
    private static final String URL_CONTEXT_PREFIX = "com.sun.jndi.url";
    private Map cacheMap = new HashMap(cacheSize);
    private static int cacheSize = 32;
    private static long lifeTime = 60000L;

    public LDAPStoreHelper(X509LDAPCertStoreParameters params) {
        this.params = params;
    }

    private DirContext connectLDAP() throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", LDAP_PROVIDER);
        props.setProperty("java.naming.batchsize", "0");
        props.setProperty("java.naming.provider.url", this.params.getLdapURL());
        props.setProperty("java.naming.factory.url.pkgs", URL_CONTEXT_PREFIX);
        props.setProperty("java.naming.referral", REFERRALS_IGNORE);
        props.setProperty("java.naming.security.authentication", SEARCH_SECURITY_LEVEL);
        InitialDirContext ctx = new InitialDirContext(props);
        return ctx;
    }

    private String parseDN(String subject, String dNAttributeName) {
        String temp = subject;
        int begin = temp.toLowerCase().indexOf(dNAttributeName.toLowerCase() + "=");
        if (begin == -1) {
            return "";
        }
        int end = (temp = temp.substring(begin + dNAttributeName.length())).indexOf(44);
        if (end == -1) {
            end = temp.length();
        }
        while (temp.charAt(end - 1) == '\\') {
            if ((end = temp.indexOf(44, end + 1)) != -1) continue;
            end = temp.length();
        }
        temp = temp.substring(0, end);
        begin = temp.indexOf(61);
        if ((temp = temp.substring(begin + 1)).charAt(0) == ' ') {
            temp = temp.substring(1);
        }
        if (temp.startsWith("\"")) {
            temp = temp.substring(1);
        }
        if (temp.endsWith("\"")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    private Set createCerts(List list, X509CertStoreSelector xselector) throws StoreException {
        HashSet<X509Certificate> certSet = new HashSet<X509Certificate>();
        Iterator it = list.iterator();
        X509CertParser parser = new X509CertParser();
        while (it.hasNext()) {
            try {
                parser.engineInit(new ByteArrayInputStream((byte[])it.next()));
                X509Certificate cert = (X509Certificate)parser.engineRead();
                if (!xselector.match((Object)cert)) continue;
                certSet.add(cert);
            }
            catch (Exception exception) {}
        }
        return certSet;
    }

    private List certSubjectSerialSearch(X509CertStoreSelector xselector, String[] attrs, String[] attrNames, String[] subjectAttributeNames) throws StoreException {
        ArrayList list = new ArrayList();
        String subject = null;
        String serial = null;
        subject = this.getSubjectAsString(xselector);
        if (xselector.getSerialNumber() != null) {
            serial = xselector.getSerialNumber().toString();
        }
        if (xselector.getCertificate() != null) {
            subject = xselector.getCertificate().getSubjectX500Principal().getName("RFC1779");
            serial = xselector.getCertificate().getSerialNumber().toString();
        }
        String attrValue = null;
        if (subject != null) {
            for (int i = 0; i < subjectAttributeNames.length; ++i) {
                attrValue = this.parseDN(subject, subjectAttributeNames[i]);
                list.addAll(this.search(attrNames, "*" + attrValue + "*", attrs));
            }
        }
        if (serial != null && this.params.getSearchForSerialNumberIn() != null) {
            attrValue = serial;
            list.addAll(this.search(this.splitString(this.params.getSearchForSerialNumberIn()), attrValue, attrs));
        }
        if (serial == null && subject == null) {
            list.addAll(this.search(attrNames, "*", attrs));
        }
        return list;
    }

    private List crossCertificatePairSubjectSearch(X509CertPairStoreSelector xselector, String[] attrs, String[] attrNames, String[] subjectAttributeNames) throws StoreException {
        ArrayList list = new ArrayList();
        String subject = null;
        if (xselector.getForwardSelector() != null) {
            subject = this.getSubjectAsString(xselector.getForwardSelector());
        }
        if (xselector.getCertPair() != null && xselector.getCertPair().getForward() != null) {
            subject = xselector.getCertPair().getForward().getSubjectX500Principal().getName("RFC1779");
        }
        String attrValue = null;
        if (subject != null) {
            for (int i = 0; i < subjectAttributeNames.length; ++i) {
                attrValue = this.parseDN(subject, subjectAttributeNames[i]);
                list.addAll(this.search(attrNames, "*" + attrValue + "*", attrs));
            }
        }
        if (subject == null) {
            list.addAll(this.search(attrNames, "*", attrs));
        }
        return list;
    }

    private List attrCertSubjectSerialSearch(X509AttributeCertStoreSelector xselector, String[] attrs, String[] attrNames, String[] subjectAttributeNames) throws StoreException {
        ArrayList list = new ArrayList();
        String subject = null;
        String serial2 = null;
        HashSet<String> serials = new HashSet<String>();
        Principal[] principals = null;
        if (xselector.getHolder() != null) {
            if (xselector.getHolder().getSerialNumber() != null) {
                serials.add(xselector.getHolder().getSerialNumber().toString());
            }
            if (xselector.getHolder().getEntityNames() != null) {
                principals = xselector.getHolder().getEntityNames();
            }
        }
        if (xselector.getAttributeCert() != null) {
            if (xselector.getAttributeCert().getHolder().getEntityNames() != null) {
                principals = xselector.getAttributeCert().getHolder().getEntityNames();
            }
            serials.add(xselector.getAttributeCert().getSerialNumber().toString());
        }
        if (principals != null) {
            subject = principals[0] instanceof X500Principal ? ((X500Principal)principals[0]).getName("RFC1779") : principals[0].getName();
        }
        if (xselector.getSerialNumber() != null) {
            serials.add(xselector.getSerialNumber().toString());
        }
        String attrValue = null;
        if (subject != null) {
            for (int i = 0; i < subjectAttributeNames.length; ++i) {
                attrValue = this.parseDN(subject, subjectAttributeNames[i]);
                list.addAll(this.search(attrNames, "*" + attrValue + "*", attrs));
            }
        }
        if (serials.size() > 0 && this.params.getSearchForSerialNumberIn() != null) {
            for (String serial2 : serials) {
                list.addAll(this.search(this.splitString(this.params.getSearchForSerialNumberIn()), serial2, attrs));
            }
        }
        if (serials.size() == 0 && subject == null) {
            list.addAll(this.search(attrNames, "*", attrs));
        }
        return list;
    }

    private List cRLIssuerSearch(X509CRLStoreSelector xselector, String[] attrs, String[] attrNames, String[] issuerAttributeNames) throws StoreException {
        ArrayList list = new ArrayList();
        String issuer = null;
        HashSet<Principal> issuers = new HashSet<Principal>();
        if (xselector.getIssuers() != null) {
            issuers.addAll(xselector.getIssuers());
        }
        if (xselector.getCertificateChecking() != null) {
            issuers.add(this.getCertificateIssuer(xselector.getCertificateChecking()));
        }
        if (xselector.getAttrCertificateChecking() != null) {
            Principal[] principals = xselector.getAttrCertificateChecking().getIssuer().getPrincipals();
            for (int i = 0; i < principals.length; ++i) {
                if (!(principals[i] instanceof X500Principal)) continue;
                issuers.add(principals[i]);
            }
        }
        Iterator it = issuers.iterator();
        while (it.hasNext()) {
            issuer = ((X500Principal)it.next()).getName("RFC1779");
            String attrValue = null;
            for (int i = 0; i < issuerAttributeNames.length; ++i) {
                attrValue = this.parseDN(issuer, issuerAttributeNames[i]);
                list.addAll(this.search(attrNames, "*" + attrValue + "*", attrs));
            }
        }
        if (issuer == null) {
            list.addAll(this.search(attrNames, "*", attrs));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List search(String[] attributeNames, String attributeValue, String[] attrs) throws StoreException {
        ArrayList list;
        String filter = null;
        if (attributeNames == null) {
            filter = null;
        } else {
            filter = "";
            if (attributeValue.equals("**")) {
                attributeValue = "*";
            }
            for (int i = 0; i < attributeNames.length; ++i) {
                filter = filter + "(" + attributeNames[i] + "=" + attributeValue + ")";
            }
            filter = "(|" + filter + ")";
        }
        String filter2 = "";
        for (int i = 0; i < attrs.length; ++i) {
            filter2 = filter2 + "(" + attrs[i] + "=*)";
        }
        filter2 = "(|" + filter2 + ")";
        String filter3 = "(&" + filter + "" + filter2 + ")";
        if (filter == null) {
            filter3 = filter2;
        }
        if ((list = this.getFromCache(filter3)) != null) {
            return list;
        }
        DirContext ctx = null;
        list = new ArrayList();
        try {
            ctx = this.connectLDAP();
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setCountLimit(0L);
            constraints.setReturningAttributes(attrs);
            NamingEnumeration<SearchResult> results = ctx.search(this.params.getBaseDN(), filter3, constraints);
            while (results.hasMoreElements()) {
                SearchResult sr = results.next();
                NamingEnumeration<?> enumeration = sr.getAttributes().getAll().next().getAll();
                while (enumeration.hasMore()) {
                    list.add(enumeration.next());
                }
            }
            this.addToCache(filter3, list);
        }
        catch (NamingException namingException) {
        }
        finally {
            try {
                if (null != ctx) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    private Set createCRLs(List list, X509CRLStoreSelector xselector) throws StoreException {
        HashSet<X509CRL> crlSet = new HashSet<X509CRL>();
        X509CRLParser parser = new X509CRLParser();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            try {
                parser.engineInit(new ByteArrayInputStream((byte[])it.next()));
                X509CRL crl = (X509CRL)parser.engineRead();
                if (!xselector.match((Object)crl)) continue;
                crlSet.add(crl);
            }
            catch (StreamParsingException streamParsingException) {}
        }
        return crlSet;
    }

    private Set createCrossCertificatePairs(List list, X509CertPairStoreSelector xselector) throws StoreException {
        HashSet<X509CertificatePair> certPairSet = new HashSet<X509CertificatePair>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                X509CertificatePair pair;
                try {
                    X509CertPairParser parser = new X509CertPairParser();
                    parser.engineInit(new ByteArrayInputStream((byte[])list.get(i)));
                    pair = (X509CertificatePair)parser.engineRead();
                }
                catch (StreamParsingException e) {
                    byte[] forward = (byte[])list.get(i);
                    byte[] reverse = (byte[])list.get(i + 1);
                    pair = new X509CertificatePair(new CertificatePair(Certificate.getInstance(new ASN1InputStream(forward).readObject()), Certificate.getInstance(new ASN1InputStream(reverse).readObject())));
                    ++i;
                }
                if (!xselector.match(pair)) continue;
                certPairSet.add(pair);
                continue;
            }
            catch (CertificateParsingException certificateParsingException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return certPairSet;
    }

    private Set createAttributeCertificates(List list, X509AttributeCertStoreSelector xselector) throws StoreException {
        HashSet<X509AttributeCertificate> certSet = new HashSet<X509AttributeCertificate>();
        Iterator it = list.iterator();
        X509AttrCertParser parser = new X509AttrCertParser();
        while (it.hasNext()) {
            try {
                parser.engineInit(new ByteArrayInputStream((byte[])it.next()));
                X509AttributeCertificate cert = (X509AttributeCertificate)parser.engineRead();
                if (!xselector.match(cert)) continue;
                certSet.add(cert);
            }
            catch (StreamParsingException streamParsingException) {}
        }
        return certSet;
    }

    public Collection getAuthorityRevocationLists(X509CRLStoreSelector selector) throws StoreException {
        String[] issuerAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getAuthorityRevocationListAttribute());
        List list = this.cRLIssuerSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapAuthorityRevocationListAttributeName()), issuerAttributeNames = this.splitString(this.params.getAuthorityRevocationListIssuerAttributeName()));
        Set resultSet = this.createCRLs(list, selector);
        if (resultSet.size() == 0) {
            X509CRLStoreSelector emptySelector = new X509CRLStoreSelector();
            list = this.cRLIssuerSearch(emptySelector, attrs, attrNames, issuerAttributeNames);
            resultSet.addAll(this.createCRLs(list, selector));
        }
        return resultSet;
    }

    public Collection getAttributeCertificateRevocationLists(X509CRLStoreSelector selector) throws StoreException {
        String[] issuerAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getAttributeCertificateRevocationListAttribute());
        List list = this.cRLIssuerSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapAttributeCertificateRevocationListAttributeName()), issuerAttributeNames = this.splitString(this.params.getAttributeCertificateRevocationListIssuerAttributeName()));
        Set resultSet = this.createCRLs(list, selector);
        if (resultSet.size() == 0) {
            X509CRLStoreSelector emptySelector = new X509CRLStoreSelector();
            list = this.cRLIssuerSearch(emptySelector, attrs, attrNames, issuerAttributeNames);
            resultSet.addAll(this.createCRLs(list, selector));
        }
        return resultSet;
    }

    public Collection getAttributeAuthorityRevocationLists(X509CRLStoreSelector selector) throws StoreException {
        String[] issuerAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getAttributeAuthorityRevocationListAttribute());
        List list = this.cRLIssuerSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapAttributeAuthorityRevocationListAttributeName()), issuerAttributeNames = this.splitString(this.params.getAttributeAuthorityRevocationListIssuerAttributeName()));
        Set resultSet = this.createCRLs(list, selector);
        if (resultSet.size() == 0) {
            X509CRLStoreSelector emptySelector = new X509CRLStoreSelector();
            list = this.cRLIssuerSearch(emptySelector, attrs, attrNames, issuerAttributeNames);
            resultSet.addAll(this.createCRLs(list, selector));
        }
        return resultSet;
    }

    public Collection getCrossCertificatePairs(X509CertPairStoreSelector selector) throws StoreException {
        String[] subjectAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getCrossCertificateAttribute());
        List list = this.crossCertificatePairSubjectSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapCrossCertificateAttributeName()), subjectAttributeNames = this.splitString(this.params.getCrossCertificateSubjectAttributeName()));
        Set resultSet = this.createCrossCertificatePairs(list, selector);
        if (resultSet.size() == 0) {
            X509CertStoreSelector emptyCertselector = new X509CertStoreSelector();
            X509CertPairStoreSelector emptySelector = new X509CertPairStoreSelector();
            emptySelector.setForwardSelector(emptyCertselector);
            emptySelector.setReverseSelector(emptyCertselector);
            list = this.crossCertificatePairSubjectSearch(emptySelector, attrs, attrNames, subjectAttributeNames);
            resultSet.addAll(this.createCrossCertificatePairs(list, selector));
        }
        return resultSet;
    }

    public Collection getUserCertificates(X509CertStoreSelector selector) throws StoreException {
        String[] subjectAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getUserCertificateAttribute());
        List list = this.certSubjectSerialSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapUserCertificateAttributeName()), subjectAttributeNames = this.splitString(this.params.getUserCertificateSubjectAttributeName()));
        Set resultSet = this.createCerts(list, selector);
        if (resultSet.size() == 0) {
            X509CertStoreSelector emptySelector = new X509CertStoreSelector();
            list = this.certSubjectSerialSearch(emptySelector, attrs, attrNames, subjectAttributeNames);
            resultSet.addAll(this.createCerts(list, selector));
        }
        return resultSet;
    }

    public Collection getAACertificates(X509AttributeCertStoreSelector selector) throws StoreException {
        String[] subjectAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getAACertificateAttribute());
        List list = this.attrCertSubjectSerialSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapAACertificateAttributeName()), subjectAttributeNames = this.splitString(this.params.getAACertificateSubjectAttributeName()));
        Set resultSet = this.createAttributeCertificates(list, selector);
        if (resultSet.size() == 0) {
            X509AttributeCertStoreSelector emptySelector = new X509AttributeCertStoreSelector();
            list = this.attrCertSubjectSerialSearch(emptySelector, attrs, attrNames, subjectAttributeNames);
            resultSet.addAll(this.createAttributeCertificates(list, selector));
        }
        return resultSet;
    }

    public Collection getAttributeDescriptorCertificates(X509AttributeCertStoreSelector selector) throws StoreException {
        String[] subjectAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getAttributeDescriptorCertificateAttribute());
        List list = this.attrCertSubjectSerialSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapAttributeDescriptorCertificateAttributeName()), subjectAttributeNames = this.splitString(this.params.getAttributeDescriptorCertificateSubjectAttributeName()));
        Set resultSet = this.createAttributeCertificates(list, selector);
        if (resultSet.size() == 0) {
            X509AttributeCertStoreSelector emptySelector = new X509AttributeCertStoreSelector();
            list = this.attrCertSubjectSerialSearch(emptySelector, attrs, attrNames, subjectAttributeNames);
            resultSet.addAll(this.createAttributeCertificates(list, selector));
        }
        return resultSet;
    }

    public Collection getCACertificates(X509CertStoreSelector selector) throws StoreException {
        String[] subjectAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getCACertificateAttribute());
        List list = this.certSubjectSerialSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapCACertificateAttributeName()), subjectAttributeNames = this.splitString(this.params.getCACertificateSubjectAttributeName()));
        Set resultSet = this.createCerts(list, selector);
        if (resultSet.size() == 0) {
            X509CertStoreSelector emptySelector = new X509CertStoreSelector();
            list = this.certSubjectSerialSearch(emptySelector, attrs, attrNames, subjectAttributeNames);
            resultSet.addAll(this.createCerts(list, selector));
        }
        return resultSet;
    }

    public Collection getDeltaCertificateRevocationLists(X509CRLStoreSelector selector) throws StoreException {
        String[] issuerAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getDeltaRevocationListAttribute());
        List list = this.cRLIssuerSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapDeltaRevocationListAttributeName()), issuerAttributeNames = this.splitString(this.params.getDeltaRevocationListIssuerAttributeName()));
        Set resultSet = this.createCRLs(list, selector);
        if (resultSet.size() == 0) {
            X509CRLStoreSelector emptySelector = new X509CRLStoreSelector();
            list = this.cRLIssuerSearch(emptySelector, attrs, attrNames, issuerAttributeNames);
            resultSet.addAll(this.createCRLs(list, selector));
        }
        return resultSet;
    }

    public Collection getAttributeCertificateAttributes(X509AttributeCertStoreSelector selector) throws StoreException {
        String[] subjectAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getAttributeCertificateAttributeAttribute());
        List list = this.attrCertSubjectSerialSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapAttributeCertificateAttributeAttributeName()), subjectAttributeNames = this.splitString(this.params.getAttributeCertificateAttributeSubjectAttributeName()));
        Set resultSet = this.createAttributeCertificates(list, selector);
        if (resultSet.size() == 0) {
            X509AttributeCertStoreSelector emptySelector = new X509AttributeCertStoreSelector();
            list = this.attrCertSubjectSerialSearch(emptySelector, attrs, attrNames, subjectAttributeNames);
            resultSet.addAll(this.createAttributeCertificates(list, selector));
        }
        return resultSet;
    }

    public Collection getCertificateRevocationLists(X509CRLStoreSelector selector) throws StoreException {
        String[] issuerAttributeNames;
        String[] attrNames;
        String[] attrs = this.splitString(this.params.getCertificateRevocationListAttribute());
        List list = this.cRLIssuerSearch(selector, attrs, attrNames = this.splitString(this.params.getLdapCertificateRevocationListAttributeName()), issuerAttributeNames = this.splitString(this.params.getCertificateRevocationListIssuerAttributeName()));
        Set resultSet = this.createCRLs(list, selector);
        if (resultSet.size() == 0) {
            X509CRLStoreSelector emptySelector = new X509CRLStoreSelector();
            list = this.cRLIssuerSearch(emptySelector, attrs, attrNames, issuerAttributeNames);
            resultSet.addAll(this.createCRLs(list, selector));
        }
        return resultSet;
    }

    private synchronized void addToCache(String searchCriteria, List list) {
        Date now = new Date(System.currentTimeMillis());
        ArrayList<Object> cacheEntry = new ArrayList<Object>();
        cacheEntry.add(now);
        cacheEntry.add(list);
        if (this.cacheMap.containsKey(searchCriteria)) {
            this.cacheMap.put(searchCriteria, cacheEntry);
        } else {
            if (this.cacheMap.size() >= cacheSize) {
                Iterator it = this.cacheMap.entrySet().iterator();
                long oldest = now.getTime();
                Object replace = null;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    long current = ((Date)((List)entry.getValue()).get(0)).getTime();
                    if (current >= oldest) continue;
                    oldest = current;
                    replace = entry.getKey();
                }
                this.cacheMap.remove(replace);
            }
            this.cacheMap.put(searchCriteria, cacheEntry);
        }
    }

    private List getFromCache(String searchCriteria) {
        List entry = (List)this.cacheMap.get(searchCriteria);
        long now = System.currentTimeMillis();
        if (entry != null) {
            if (((Date)entry.get(0)).getTime() < now - lifeTime) {
                return null;
            }
            return (List)entry.get(1);
        }
        return null;
    }

    private String[] splitString(String str) {
        return str.split("\\s+");
    }

    private String getSubjectAsString(X509CertStoreSelector xselector) {
        try {
            byte[] encSubject = xselector.getSubjectAsBytes();
            if (encSubject != null) {
                return new X500Principal(encSubject).getName("RFC1779");
            }
        }
        catch (IOException e) {
            throw new StoreException("exception processing name: " + e.getMessage(), e);
        }
        return null;
    }

    private X500Principal getCertificateIssuer(X509Certificate cert) {
        return cert.getIssuerX500Principal();
    }
}

