/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeProtocolVersionAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private ProtocolVersion newValue;
    private ProtocolVersion oldValue = null;

    public ChangeProtocolVersionAction(ProtocolVersion newValue) {
        this.newValue = newValue;
    }

    public ChangeProtocolVersionAction() {
    }

    public void setNewValue(ProtocolVersion newValue) {
        this.newValue = newValue;
    }

    public ProtocolVersion getNewValue() {
        return this.newValue;
    }

    public ProtocolVersion getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getSelectedProtocolVersion();
        tlsContext.setSelectedProtocolVersion(this.newValue);
        LOGGER.info("Changed ProtocolVersion from " + (Object)((Object)this.oldValue) == null ? this.oldValue.name() : null + " to " + this.newValue.name());
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode((Object)this.newValue);
        hash = 83 * hash + Objects.hashCode((Object)this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeProtocolVersionAction other = (ChangeProtocolVersionAction)obj;
        if (this.newValue != other.newValue) {
            return false;
        }
        return this.oldValue == other.oldValue;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

