/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.identity.IDValue;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.ValueStore;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.apache.xerces.validators.schema.identity.XPathMatcher;

public class Field {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;
    protected boolean mayMatch = true;

    public Field(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public XPathMatcher createMatcher(ValueStore valueStore) {
        return new Matcher(this.fXPath, valueStore);
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public org.apache.xerces.validators.schema.identity.XPath getXPath() {
        return this.fXPath;
    }

    public boolean mayMatch() {
        return this.mayMatch;
    }

    public void setMayMatch(boolean bl) {
        this.mayMatch = bl;
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public static class XPath
    extends org.apache.xerces.validators.schema.identity.XPath {
        public XPath(String string, StringPool stringPool, NamespacesScope namespacesScope) throws XPathException {
            super(string.trim().startsWith("/") || string.trim().startsWith(".") ? string : "./" + string, stringPool, namespacesScope);
        }
    }

    protected class Matcher
    extends XPathMatcher {
        protected ValueStore fStore;

        public Matcher(XPath xPath, ValueStore valueStore) {
            super(xPath, true, null);
            this.fStore = valueStore;
        }

        protected void matched(String string, DatatypeValidator datatypeValidator, boolean bl) throws Exception {
            super.matched(string, datatypeValidator, bl);
            if (bl) {
                this.fStore.reportNilError(Field.this.fIdentityConstraint);
            }
            this.fStore.addValue(Field.this, new IDValue(string, datatypeValidator));
            Field.this.mayMatch = false;
        }
    }
}

