import activeElement from './activeElement';
import addClass from './addClass';
import addEventListener from './addEventListener';
import animate from './animate';
import { cancel as cancelAnimationFrame, request as requestAnimationFrame } from './animationFrame';
import closest from './closest';
import contains from './contains';
import style from './css';
import filter from './filterEventHandler';
import getComputedStyle from './getComputedStyle';
import hasClass from './hasClass';
import height from './height';
import listen from './listen';
import matches from './matches';
import offset from './offset';
import offsetParent from './offsetParent';
import ownerDocument from './ownerDocument';
import ownerWindow from './ownerWindow';
import position from './position';
import querySelectorAll from './querySelectorAll';
import removeClass from './removeClass';
import removeEventListener from './removeEventListener';
import scrollbarSize from './scrollbarSize';
import scrollLeft from './scrollLeft';
import scrollParent from './scrollParent';
import scrollTo from './scrollTo';
import scrollTop from './scrollTop';
import toggleClass from './toggleClass';
import transitionEnd from './transitionEnd';
import width from './width';
export { addEventListener, removeEventListener, animate, filter, listen, style, getComputedStyle, activeElement, ownerDocument, ownerWindow, requestAnimationFrame, cancelAnimationFrame, matches, height, width, offset, offsetParent, position, contains, scrollbarSize, scrollLeft, scrollParent, scrollTo, scrollTop, querySelectorAll, closest, addClass, removeClass, hasClass, toggleClass, transitionEnd, };
declare const _default: {
    addEventListener: typeof addEventListener;
    removeEventListener: typeof removeEventListener;
    animate: typeof animate;
    filter: typeof filter;
    listen: typeof listen;
    style: typeof style;
    getComputedStyle: typeof getComputedStyle;
    activeElement: typeof activeElement;
    ownerDocument: typeof ownerDocument;
    ownerWindow: typeof ownerWindow;
    requestAnimationFrame: typeof globalThis.requestAnimationFrame;
    cancelAnimationFrame: (id: number) => void;
    matches: typeof matches;
    height: typeof height;
    width: typeof width;
    offset: typeof offset;
    offsetParent: typeof offsetParent;
    position: typeof position;
    contains: typeof contains;
    scrollbarSize: typeof scrollbarSize;
    scrollLeft: {
        (node: Element): number;
        (node: Element, val: number): undefined;
    };
    scrollParent: typeof scrollParent;
    scrollTo: typeof scrollTo;
    scrollTop: {
        (node: Element): number;
        (node: Element, val: number): undefined;
    };
    querySelectorAll: typeof querySelectorAll;
    closest: typeof closest;
    addClass: typeof addClass;
    removeClass: typeof removeClass;
    hasClass: typeof hasClass;
    toggleClass: typeof toggleClass;
    transitionEnd: typeof transitionEnd;
};
export default _default;
