/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public final class AuthorizationManagerAfterMethodInterceptor
implements Ordered,
MethodInterceptor,
PointcutAdvisor,
AopInfrastructureBean {
    static final Supplier<Authentication> AUTHENTICATION_SUPPLIER = () -> {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationCredentialsNotFoundException("An Authentication object was not found in the SecurityContext");
        }
        return authentication;
    };
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pointcut pointcut;
    private final AuthorizationManager<MethodInvocationResult> authorizationManager;
    private int order;

    public AuthorizationManagerAfterMethodInterceptor(Pointcut pointcut, AuthorizationManager<MethodInvocationResult> authorizationManager) {
        Assert.notNull((Object)pointcut, "pointcut cannot be null");
        Assert.notNull(authorizationManager, "authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    public static AuthorizationManagerAfterMethodInterceptor postAuthorize() {
        return AuthorizationManagerAfterMethodInterceptor.postAuthorize(new PostAuthorizeAuthorizationManager());
    }

    public static AuthorizationManagerAfterMethodInterceptor postAuthorize(PostAuthorizeAuthorizationManager authorizationManager) {
        AuthorizationManagerAfterMethodInterceptor interceptor = new AuthorizationManagerAfterMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PostAuthorize.class), authorizationManager);
        interceptor.setOrder(500);
        return interceptor;
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        Object result = mi.proceed();
        this.attemptAuthorization(mi, result);
        return result;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Override
    public Advice getAdvice() {
        return this;
    }

    @Override
    public boolean isPerInstance() {
        return true;
    }

    private void attemptAuthorization(MethodInvocation mi, Object result) {
        this.logger.debug(LogMessage.of(() -> "Authorizing method invocation " + mi));
        AuthorizationDecision decision = this.authorizationManager.check(AUTHENTICATION_SUPPLIER, new MethodInvocationResult(mi, result));
        if (decision != null && !decision.isGranted()) {
            this.logger.debug(LogMessage.of(() -> "Failed to authorize " + mi + " with authorization manager " + this.authorizationManager + " and decision " + decision));
            throw new AccessDeniedException("Access Denied");
        }
        this.logger.debug(LogMessage.of(() -> "Authorized method invocation " + mi));
    }
}

