/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Optional;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSource$AsCharSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class ByteSource {
    protected ByteSource() {
    }

    public CharSource asCharSource(Charset charset) {
        return new ByteSource$AsCharSource(this, charset);
    }

    public abstract InputStream openStream();

    public Optional sizeIfKnown() {
        return Optional.absent();
    }

    @CanIgnoreReturnValue
    public long copyTo(ByteSink byteSink) {
        Preconditions.checkNotNull(byteSink);
        try (Closer closer = Closer.create();){
            InputStream inputStream = (InputStream)closer.register(this.openStream());
            OutputStream outputStream = (OutputStream)closer.register(byteSink.openStream());
            long l = ByteStreams.copy(inputStream, outputStream);
            return l;
        }
    }

    public byte[] read() {
        try (Closer closer = Closer.create();){
            InputStream inputStream = (InputStream)closer.register(this.openStream());
            Optional optional = this.sizeIfKnown();
            byte[] byArray = optional.isPresent() ? ByteStreams.toByteArray(inputStream, (Long)optional.get()) : ByteStreams.toByteArray(inputStream);
            return byArray;
        }
    }
}

