/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class Facet2DStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String collection;
    private ModifiableSolrParams params;
    private Bucket x;
    private Bucket y;
    private Metric metric;
    private String zkHost;
    private Iterator<Tuple> out;
    private List<Tuple> tuples = new ArrayList<Tuple>();
    private int dimensionX;
    private int dimensionY;
    private FieldComparator bucketSort;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;

    public Facet2DStream(String zkHost, String collection, ModifiableSolrParams params, Bucket x, Bucket y, String dimensions, Metric metric) throws IOException {
        if (dimensions != null) {
            String[] strDimensions = dimensions.split(",");
            if (strDimensions.length != 2) {
                throw new IOException(String.format(Locale.ROOT, "two dimension values expected. %s found", strDimensions.length));
            }
            this.dimensionX = Integer.parseInt(strDimensions[0]);
            this.dimensionY = Integer.parseInt(strDimensions[1]);
        }
        String bucketSortString = metric.getIdentifier() + " desc";
        this.bucketSort = this.parseBucketSort(bucketSortString, x, y);
        this.init(collection, (SolrParams)params, x, y, this.bucketSort, this.dimensionX, this.dimensionY, metric, zkHost);
    }

    public Facet2DStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String keyY;
        String keyX;
        String collectionName = factory.getValueOperand(expression, 0);
        if (collectionName.indexOf(34) > -1) {
            collectionName = collectionName.replaceAll("\"", "").replaceAll(" ", "");
        }
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter bucketXExpression = factory.getNamedOperand(expression, "x");
        StreamExpressionNamedParameter bucketYExpression = factory.getNamedOperand(expression, "y");
        StreamExpressionNamedParameter dimensionsExpression = factory.getNamedOperand(expression, "dimensions");
        List<StreamExpression> metricExpression = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (collectionName == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("x") || namedParam.getName().equals("y") || namedParam.getName().equals("dimensions") || namedParam.getName().equals("zkHost")) continue;
            params.add(namedParam.getName(), new String[]{namedParam.getParameter().toString().trim()});
        }
        if (params.get("q") == null) {
            params.set("q", new String[]{"*:*"});
        }
        Bucket x = null;
        if (bucketXExpression != null && bucketXExpression.getParameter() instanceof StreamExpressionValue && (keyX = ((StreamExpressionValue)bucketXExpression.getParameter()).getValue()) != null && !keyX.equals("")) {
            x = new Bucket(keyX.trim());
        }
        Bucket y = null;
        if (bucketYExpression != null && bucketYExpression.getParameter() instanceof StreamExpressionValue && (keyY = ((StreamExpressionValue)bucketYExpression.getParameter()).getValue()) != null && !keyY.equals("")) {
            y = new Bucket(keyY.trim());
        }
        if (x == null || y == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - x and y buckets expected. eg. 'x=\"name\"'", expression));
        }
        Metric metric = null;
        metric = metricExpression == null || metricExpression.size() == 0 ? new CountMetric() : factory.constructMetric(metricExpression.get(0));
        String bucketSortString = metric.getIdentifier() + " desc";
        FieldComparator bucketSort = this.parseBucketSort(bucketSortString, x, y);
        int dimensionX = 10;
        int dimensionY = 10;
        if (dimensionsExpression != null && dimensionsExpression.getParameter() instanceof StreamExpressionValue) {
            String[] strDimensions = ((StreamExpressionValue)dimensionsExpression.getParameter()).getValue().split(",");
            if (strDimensions.length != 2) {
                throw new IOException(String.format(Locale.ROOT, "two dimension values expected. Found %s", strDimensions.length));
            }
            dimensionX = Integer.parseInt(strDimensions[0].trim());
            dimensionY = Integer.parseInt(strDimensions[1].trim());
        }
        String zkHost = null;
        if (zkHostExpression == null) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, (SolrParams)params, x, y, bucketSort, dimensionX, dimensionY, metric, zkHost);
    }

    private FieldComparator parseBucketSort(String bucketSortString, Bucket x, Bucket y) throws IOException {
        String[] spec = bucketSortString.trim().split("\\s+");
        String fieldName = spec[0].trim();
        return new FieldComparator(fieldName, ComparatorOrder.DESCENDING);
    }

    private void init(String collection, SolrParams params, Bucket x, Bucket y, FieldComparator bucketSort, int dimensionX, int dimensionY, Metric metric, String zkHost) {
        this.collection = collection;
        this.params = new ModifiableSolrParams(params);
        this.x = x;
        this.y = y;
        this.dimensionX = dimensionX;
        this.dimensionY = dimensionY;
        this.metric = metric;
        this.bucketSort = bucketSort;
        this.zkHost = zkHost;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(this.params.stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        for (Map.Entry param : this.params.getMap().entrySet()) {
            for (String val : (String[])param.getValue()) {
                expression.addParameter(new StreamExpressionNamedParameter((String)param.getKey(), val));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.x.toString());
        expression.addParameter(new StreamExpressionNamedParameter("x", builder.toString()));
        builder = new StringBuilder();
        builder.append(this.y.toString());
        expression.addParameter(new StreamExpressionNamedParameter("y", builder.toString()));
        expression.addParameter(new StreamExpressionNamedParameter("dimensions", Integer.toString(this.dimensionX) + "," + Integer.toString(this.dimensionY)));
        expression.addParameter(this.metric.toExpression(factory));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public void open() throws IOException {
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(this.zkHost);
            this.cloudSolrClient = ((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(hosts, Optional.empty()).withSocketTimeout(30000)).withConnectionTimeout(15000)).build();
        }
        FieldComparator[] adjustedSorts = this.adjustSorts(this.x, this.y, this.bucketSort);
        String json = this.getJsonFacetString(this.x, this.y, this.metric, adjustedSorts, this.dimensionX, this.dimensionY);
        ModifiableSolrParams paramsLoc = new ModifiableSolrParams((SolrParams)this.params);
        paramsLoc.set("json.facet", new String[]{json});
        paramsLoc.set("rows", new String[]{"0"});
        QueryRequest request = new QueryRequest((SolrParams)paramsLoc, SolrRequest.METHOD.POST);
        try {
            NamedList response = this.cloudSolrClient.request((SolrRequest)request, this.collection);
            this.getTuples(response, this.x, this.y, this.metric);
            this.out = this.tuples.iterator();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.out.hasNext()) {
            return this.out.next();
        }
        Tuple tuple = Tuple.EOF();
        tuple.put("rows", this.tuples.size());
        return tuple;
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null && this.cloudSolrClient != null) {
            this.cloudSolrClient.close();
        }
    }

    private String getJsonFacetString(Bucket x, Bucket y, Metric metric, FieldComparator[] adjustedSorts, int dimensionX, int dimensionY) {
        StringBuilder buf = new StringBuilder();
        this.appendJson(buf, x, y, metric, adjustedSorts, dimensionX, dimensionY);
        return "{" + buf.toString() + "}";
    }

    private FieldComparator[] adjustSorts(Bucket x, Bucket y, FieldComparator bucketSort) throws IOException {
        FieldComparator[] adjustSorts = new FieldComparator[2];
        if (bucketSort.getLeftFieldName().contains("(")) {
            for (int i = 0; i < adjustSorts.length; ++i) {
                adjustSorts[i] = bucketSort;
            }
        } else {
            adjustSorts[0] = new FieldComparator(x.toString(), bucketSort.getOrder());
            adjustSorts[1] = new FieldComparator(y.toString(), bucketSort.getOrder());
        }
        return adjustSorts;
    }

    private void appendJson(StringBuilder buf, Bucket x, Bucket y, Metric metric, FieldComparator[] adjustedSorts, int dimensionX, int dimensionY) {
        buf.append('\"');
        buf.append("x");
        buf.append('\"');
        buf.append(":{");
        buf.append("\"type\":\"terms\"");
        buf.append(",\"field\":\"").append(x.toString()).append('\"');
        buf.append(",\"limit\":").append(dimensionX);
        buf.append(",\"overrequest\":1000");
        String fsort = this.getFacetSort(adjustedSorts[0].getLeftFieldName(), metric);
        buf.append(",\"sort\":\"").append(fsort).append(" desc\"");
        buf.append(",\"facet\":{");
        String identifier = metric.getIdentifier();
        if (!identifier.startsWith("count(")) {
            buf.append("\"agg\":\"").append(identifier).append('\"');
            buf.append(",");
        }
        buf.append('\"');
        buf.append("y");
        buf.append('\"');
        buf.append(":{");
        buf.append("\"type\":\"terms\"");
        buf.append(",\"field\":\"").append(y.toString()).append('\"');
        buf.append(",\"limit\":").append(dimensionY);
        buf.append(",\"overrequest\":1000");
        String fsortY = this.getFacetSort(adjustedSorts[1].getLeftFieldName(), metric);
        buf.append(",\"sort\":\"").append(fsortY).append(" desc\"");
        buf.append(",\"facet\":{");
        if (!identifier.startsWith("count(")) {
            buf.append("\"agg\":\"").append(identifier).append('\"');
        }
        buf.append("}}}}");
    }

    private String getFacetSort(String id, Metric metric) {
        if (id.startsWith("count(")) {
            return "count";
        }
        if (id.equals(metric.getIdentifier())) {
            return "agg";
        }
        return null;
    }

    private void getTuples(NamedList<?> response, Bucket x, Bucket y, Metric metric) {
        Tuple tuple = new Tuple();
        NamedList facets = (NamedList)response.get("facets");
        this.fillTuples(0, this.tuples, tuple, facets, x, y, metric);
    }

    private void fillTuples(int level, List<Tuple> tuples, Tuple currentTuple, NamedList<?> facets, Bucket x, Bucket y, Metric metric) {
        String bucketXName = x.toString();
        String bucketYName = y.toString();
        NamedList allXBuckets = (NamedList)facets.get("x");
        for (int b = 0; b < allXBuckets.size(); ++b) {
            List buckets = (List)allXBuckets.get("buckets");
            for (int s = 0; s < buckets.size(); ++s) {
                NamedList bucket = (NamedList)buckets.get(s);
                Object val = bucket.get("val");
                if (val instanceof Integer) {
                    val = ((Integer)val).longValue();
                }
                Tuple tx = currentTuple.clone();
                tx.put(bucketXName, val);
                NamedList allYBuckets = (NamedList)bucket.get("y");
                List ybuckets = (List)allYBuckets.get("buckets");
                for (int d = 0; d < ybuckets.size(); ++d) {
                    NamedList bucketY = (NamedList)ybuckets.get(d);
                    Object valY = bucketY.get("val");
                    if (valY instanceof Integer) {
                        valY = ((Integer)valY).longValue();
                    }
                    Tuple yt = tx.clone();
                    yt.put(bucketYName, valY);
                    int m = 0;
                    String identifier = metric.getIdentifier();
                    if (!identifier.startsWith("count(")) {
                        Number d1 = (Number)bucketY.get("agg");
                        if (metric.outputLong) {
                            if (d1 instanceof Long || d1 instanceof Integer) {
                                yt.put(identifier, d1.longValue());
                            } else {
                                yt.put(identifier, Math.round(d1.doubleValue()));
                            }
                        } else {
                            yt.put(identifier, d1.doubleValue());
                        }
                        ++m;
                    } else {
                        long l = ((Number)bucketY.get("count")).longValue();
                        yt.put("count(*)", l);
                    }
                    tuples.add(yt);
                }
            }
        }
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.bucketSort;
    }

    public String getCollection() {
        return this.collection;
    }

    public Bucket getX() {
        return this.x;
    }

    public Bucket getY() {
        return this.y;
    }
}

