/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.solr.search.SyntaxError;

class ScoreModeParser {
    private static final Map<String, ScoreMode> lowerAndCapitalCase = ScoreModeParser.getLowerAndCapitalCaseMap();

    private ScoreModeParser() {
    }

    private static Map<String, ScoreMode> getLowerAndCapitalCaseMap() {
        HashMap<String, ScoreMode> map = new HashMap<String, ScoreMode>(ScoreMode.values().length * 2);
        for (ScoreMode s : ScoreMode.values()) {
            map.put(s.name().toLowerCase(Locale.ROOT), s);
            map.put(s.name(), s);
        }
        return Collections.unmodifiableMap(map);
    }

    static ScoreMode parse(String score) throws SyntaxError {
        ScoreMode scoreMode = lowerAndCapitalCase.get(score);
        if (scoreMode == null) {
            throw new SyntaxError("Unable to parse ScoreMode from: " + score);
        }
        return scoreMode;
    }
}

