/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.security.SolrNodeKeyPair;

@Path(value="/node/key")
public class PublicKeyAPI
extends JerseyResource {
    private final SolrNodeKeyPair nodeKeyPair;

    @Inject
    public PublicKeyAPI(SolrNodeKeyPair nodeKeyPair) {
        this.nodeKeyPair = nodeKeyPair;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.ALL)
    public PublicKeyResponse getPublicKey() {
        PublicKeyResponse response = this.instantiateJerseyResponse(PublicKeyResponse.class);
        response.key = this.nodeKeyPair.getKeyPair().getPublicKeyStr();
        return response;
    }

    public static class PublicKeyResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="key")
        @Schema(description="The public key of the receiving Solr node.")
        public String key;
    }
}

