/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.impl.ZkDistribStateManager;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerNodePrioritizer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZkStateReader zkStateReader;
    private final String adminPath;
    private final ShardHandlerFactory shardHandlerFactory;
    private final Overseer overseer;

    public OverseerNodePrioritizer(ZkStateReader zkStateReader, Overseer overseer, String adminPath, ShardHandlerFactory shardHandlerFactory) {
        this.zkStateReader = zkStateReader;
        this.adminPath = adminPath;
        this.shardHandlerFactory = shardHandlerFactory;
        this.overseer = overseer;
    }

    public synchronized void prioritizeOverseerNodes(String overseerId) throws Exception {
        Map m;
        Object l;
        SolrZkClient zk = this.zkStateReader.getZkClient();
        ArrayList<String> overseerDesignates = new ArrayList<String>();
        if (zk.exists("/roles.json", true).booleanValue() && (l = (List)(m = (Map)Utils.fromJSON((byte[])zk.getData("/roles.json", null, new Stat(), true))).get("overseer")) != null) {
            overseerDesignates.addAll((Collection<String>)l);
        }
        List<String> preferredOverseers = ClusterAPI.getNodesByRole(NodeRoles.Role.OVERSEER, "preferred", (DistribStateManager)new ZkDistribStateManager(this.zkStateReader.getZkClient()));
        for (String preferred : preferredOverseers) {
            if (!overseerDesignates.contains(preferred)) continue;
            log.warn("Node {} has been configured to be a preferred overseer using both ADDROLE API command as well as using Node Roles (i.e. -Dsolr.node.roles start up property). Only the latter is recommended.", (Object)preferred);
        }
        overseerDesignates.addAll(preferredOverseers);
        if (overseerDesignates.isEmpty()) {
            return;
        }
        String ldr = OverseerTaskProcessor.getLeaderNode(zk);
        if (overseerDesignates.contains(ldr)) {
            return;
        }
        log.info("prioritizing overseer nodes at {} overseer designates are {}", (Object)overseerId, overseerDesignates);
        List<String> electionNodes = OverseerTaskProcessor.getSortedElectionNodes(zk, "/overseer_elect/election");
        if (electionNodes.size() < 2) {
            return;
        }
        log.info("sorted nodes {}", electionNodes);
        String designateNodeId = null;
        for (String electionNode : electionNodes) {
            if (!overseerDesignates.contains(LeaderElector.getNodeName(electionNode))) continue;
            designateNodeId = electionNode;
            break;
        }
        if (designateNodeId == null) {
            log.warn("No live overseer designate ");
            return;
        }
        if (!designateNodeId.equals(electionNodes.get(1))) {
            log.info("asking node {} to come join election at head", (Object)designateNodeId);
            this.invokeOverseerOpWithRetries(designateNodeId, "rejoinAtHead", 5);
            if (log.isInfoEnabled()) {
                log.info("asking the old first in line {} to rejoin election  ", (Object)electionNodes.get(1));
            }
            this.invokeOverseerOpWithRetries(electionNodes.get(1), "rejoin", 5);
            if (log.isInfoEnabled()) {
                List<String> newElectionNodes = OverseerTaskProcessor.getSortedElectionNodes(zk, "/overseer_elect/election");
                log.info("sorted nodes after prioritization {}", newElectionNodes);
            }
        }
        this.overseer.sendQuitToOverseer(OverseerTaskProcessor.getLeaderId(this.zkStateReader.getZkClient()));
    }

    private void invokeOverseerOpWithRetries(String electionNode, String op, int retryCount) {
        boolean successful = false;
        for (int i = 0; i < retryCount && !successful; ++i) {
            try {
                this.invokeOverseerOp(electionNode, op);
                successful = true;
                continue;
            }
            catch (SolrException e) {
                if (i < retryCount - 1) {
                    log.warn("Exception occurred while invoking Overseer Operation '{}'. Retrying.", (Object)op, (Object)e);
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                throw e;
            }
        }
    }

    private void invokeOverseerOp(String electionNode, String op) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.OVERSEEROP.toString()});
        params.set("op", new String[]{op});
        params.set("qt", new String[]{this.adminPath});
        params.set("electionNode", new String[]{electionNode});
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        String replica = this.zkStateReader.getBaseUrlForNodeName(LeaderElector.getNodeName(electionNode));
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        shardHandler.submit(sreq, replica, sreq.params);
        ShardResponse response = shardHandler.takeCompletedOrError();
        if (response.getException() != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception occurred while invoking Overseer Operation: " + op, response.getException());
        }
    }
}

