/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.tracing.TraceUtils;

public abstract class AdminAPIBase
extends JerseyResource {
    protected final CoreContainer coreContainer;
    protected final SolrQueryRequest solrQueryRequest;
    protected final SolrQueryResponse solrQueryResponse;

    public AdminAPIBase(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        this.coreContainer = coreContainer;
        this.solrQueryRequest = solrQueryRequest;
        this.solrQueryResponse = solrQueryResponse;
    }

    protected CoreContainer fetchAndValidateZooKeeperAwareCoreContainer() {
        AdminAPIBase.validateZooKeeperAwareCoreContainer(this.coreContainer);
        return this.coreContainer;
    }

    public static void validateZooKeeperAwareCoreContainer(CoreContainer coreContainer) {
        if (coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
    }

    public static void recordCollectionForLogAndTracing(String collection, SolrQueryRequest solrQueryRequest) {
        MDCLoggingContext.setCollection(collection);
        TraceUtils.setDbInstance(solrQueryRequest, collection);
    }

    public void disableResponseCaching() {
        this.solrQueryResponse.setHttpCaching(false);
    }
}

