/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class AlignTableAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(AlignTableAction.class);
    private boolean isHorizontal;

    public AlignTableAction(ArchitectSwingSession session, String actionName, String actionDescription, boolean isHorizontal) {
        super(session, actionName, actionDescription);
        this.isHorizontal = isHorizontal;
    }

    public AlignTableAction(ArchitectFrame frame, String actionName, String actionDescription, boolean isHorizontal) {
        super(frame, actionName, actionDescription);
        this.isHorizontal = isHorizontal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<TablePane> selection = new ArrayList();
        for (ContainerPane<?, ?> cp : this.getSession().getPlayPen().getSelectedContainers()) {
            if (!(cp instanceof TablePane)) continue;
            selection.add((TablePane)cp);
        }
        if ((selection = Collections.unmodifiableList(selection)).size() < 2) {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("AlignTableAction.selectAtLeastTwoTables"));
        } else if (selection.size() >= 2) {
            int min = Integer.MAX_VALUE;
            this.getPlaypen().startCompoundEdit("Aligning tables");
            logger.debug((Object)("Starting to align " + selection.size() + "tables"));
            if (!this.isHorizontal) {
                int i;
                for (i = 0; i < selection.size(); ++i) {
                    if (((TablePane)selection.get(i)).getX() >= min) continue;
                    min = ((TablePane)selection.get(i)).getX();
                }
                for (i = 0; i < selection.size(); ++i) {
                    ((TablePane)selection.get(i)).setLocation(min, ((TablePane)selection.get(i)).getY());
                }
            } else {
                int i;
                for (i = 0; i < selection.size(); ++i) {
                    if (((TablePane)selection.get(i)).getY() >= min) continue;
                    min = ((TablePane)selection.get(i)).getY();
                }
                for (i = 0; i < selection.size(); ++i) {
                    ((TablePane)selection.get(i)).setLocation(((TablePane)selection.get(i)).getX(), min);
                }
            }
            this.getPlaypen().endCompoundEdit("Ending the alignment of tables");
        } else {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("AlignTableAction.selectAtLeastTwoTables"));
        }
    }
}

