/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlComplexTypes;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOperation;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlTypes;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Wsdl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Port _port;
    private final Definition _wsdlDefinition;
    private final Service _service;
    private final WsdlTypes _wsdlTypes;
    private HashMap<String, WsdlOperation> _operationCache;

    public Wsdl(URI wsdlURI, QName serviceQName, String portName) {
        try {
            this._wsdlDefinition = this.parse(wsdlURI);
        }
        catch (WSDLException e) {
            throw new RuntimeException("Could not load WSDL file: " + e.getMessage(), e);
        }
        if (serviceQName == null) {
            this._service = (Service)this._wsdlDefinition.getServices().values().iterator().next();
        } else {
            this._service = this._wsdlDefinition.getService(serviceQName);
            if (this._service == null) {
                throw new IllegalArgumentException("Service: " + serviceQName + " is not defined in the WSDL file " + wsdlURI);
            }
        }
        if (portName == null) {
            this._port = (Port)this._service.getPorts().values().iterator().next();
        } else {
            this._port = this._service.getPort(portName);
            if (this._port == null) {
                throw new IllegalArgumentException("Port: " + portName + " is not defined in the service: " + serviceQName);
            }
        }
        this._wsdlTypes = new WsdlTypes(this._wsdlDefinition);
        this._operationCache = new HashMap();
    }

    public Wsdl(WSDLLocator wsdlLocator, QName serviceQName, String portName) {
        try {
            this._wsdlDefinition = this.parse(wsdlLocator);
        }
        catch (WSDLException e) {
            throw new RuntimeException("Could not load WSDL file: " + e.getMessage(), e);
        }
        this._service = this._wsdlDefinition.getService(serviceQName);
        if (this._service == null) {
            throw new IllegalArgumentException("Service: " + serviceQName + " is not defined in the WSDL file.");
        }
        this._port = this._service.getPort(portName);
        if (this._port == null) {
            throw new IllegalArgumentException("Port: " + portName + " is not defined in the service: " + serviceQName);
        }
        this._wsdlTypes = new WsdlTypes(this._wsdlDefinition);
        this._operationCache = new HashMap();
    }

    public WsdlComplexTypes getComplexTypes() {
        return this._wsdlTypes.getNamedComplexTypes();
    }

    public WsdlOperation getOperation(String operationName) {
        if (this._operationCache.containsKey(operationName)) {
            return this._operationCache.get(operationName);
        }
        Binding b = this._port.getBinding();
        PortType pt = b.getPortType();
        Operation op = pt.getOperation(operationName, null, null);
        if (op != null) {
            try {
                WsdlOperation wop = new WsdlOperation(b, op, this._wsdlTypes);
                this._operationCache.put(operationName, wop);
                return wop;
            }
            catch (Exception e) {
                LogWriter.getInstance().logError("WSDL", "Could not retrieve WSDL Operator for operation name: " + operationName, (Throwable)e);
            }
        }
        return null;
    }

    public List<WsdlOperation> getOperations() {
        ArrayList<WsdlOperation> opList = new ArrayList<WsdlOperation>();
        PortType pt = this._port.getBinding().getPortType();
        List operations = pt.getOperations();
        Iterator itr = operations.iterator();
        while (itr.hasNext()) {
            WsdlOperation operation = this.getOperation(((Operation)itr.next()).getName());
            if (operation == null) continue;
            opList.add(operation);
        }
        return opList;
    }

    public String getPortName() {
        return this._port.getName();
    }

    public QName getPortTypeQName() {
        Binding b = this._port.getBinding();
        return b.getPortType().getQName();
    }

    public String getServiceEndpoint() {
        return WsdlUtils.getSOAPAddress(this._port);
    }

    public String getServiceName() {
        return this._service.getQName().getLocalPart();
    }

    public String getTargetNamespace() {
        return this._wsdlDefinition.getTargetNamespace();
    }

    public void setPort(QName portName) {
        Port port = this._service.getPort(portName.getLocalPart());
        if (port == null) {
            throw new IllegalArgumentException("Port name: '" + portName + "' was not found in the WSDL file.");
        }
        this._port = port;
        this._operationCache.clear();
    }

    private WSDLReader getReader() throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        wsdlReader.setExtensionRegistry(registry);
        wsdlReader.setFeature("javax.wsdl.verbose", true);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        return wsdlReader;
    }

    private Definition parse(WSDLLocator wsdlLocator) throws WSDLException {
        WSDLReader wsdlReader = this.getReader();
        return wsdlReader.readWSDL(wsdlLocator);
    }

    private Definition parse(URI wsdlURI) throws WSDLException {
        WSDLReader wsdlReader = this.getReader();
        return wsdlReader.readWSDL(wsdlURI.toString());
    }
}

