/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.serializer.AbstractRecordSerializer;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PopAndSendRecordAction
extends MessageAction
implements SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private Boolean asPlanned = null;

    public PopAndSendRecordAction() {
    }

    public PopAndSendRecordAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        AbstractRecord record = tlsContext.getRecordBuffer().pop();
        String sending = record.getContentMessageType().name();
        if (this.connectionAlias == null) {
            LOGGER.info("Sending record: " + sending);
        } else {
            LOGGER.info("Sending record(" + this.connectionAlias + "): " + sending);
        }
        AbstractRecordSerializer s = record.getRecordSerializer();
        try {
            tlsContext.getTransportHandler().sendData(s.serialize());
            this.asPlanned = true;
        }
        catch (IOException ex) {
            LOGGER.debug((Object)ex);
            tlsContext.setReceivedTransportHandlerException(true);
            this.asPlanned = false;
        }
        this.setExecuted(true);
    }

    public String toString() {
        return "PopAndSendRecordAction";
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted() && Objects.equals(this.asPlanned, Boolean.TRUE);
    }

    @Override
    public void setRecords(List<AbstractRecord> records) {
        this.records = records;
    }

    @Override
    public void reset() {
        this.messages = new LinkedList();
        this.records = new LinkedList();
        this.setExecuted(null);
        this.asPlanned = null;
    }

    @Override
    public List<ProtocolMessage> getSendMessages() {
        return this.messages;
    }

    @Override
    public List<AbstractRecord> getSendRecords() {
        return this.records;
    }
}

