/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import de.rub.nds.tlsattacker.attacks.padding.PaddingVectorGenerator;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.attacks.padding.vector.TrippleVector;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import java.util.LinkedList;
import java.util.List;

public class LongRecordPaddingGenerator
extends PaddingVectorGenerator {
    @Override
    public List<PaddingVector> getVectors(CipherSuite suite, ProtocolVersion version) {
        LinkedList<PaddingVector> vectorList = new LinkedList<PaddingVector>();
        int blockSize = AlgorithmResolver.getCipher(suite).getBlocksize();
        int macSize = AlgorithmResolver.getMacAlgorithm(version, suite).getSize();
        vectorList.add(new TrippleVector("ValidPlainData", "ValidPlainData", (VariableModification)new ByteArrayExplicitValueModification(new byte[16384]), (VariableModification)new ByteArrayExplicitValueModification(new byte[AlgorithmResolver.getMacAlgorithm(version, suite).getSize()]), (VariableModification)new ByteArrayExplicitValueModification(this.createPaddingBytes(this.calculateValidPaddingSize(blockSize, macSize)))));
        vectorList.add(new TrippleVector("InvalidPlainData", "InvalidPlainData", (VariableModification)new ByteArrayExplicitValueModification(new byte[16385]), (VariableModification)new ByteArrayExplicitValueModification(new byte[AlgorithmResolver.getMacAlgorithm(version, suite).getSize()]), (VariableModification)new ByteArrayExplicitValueModification(this.createPaddingBytes(this.calculateInvalidPaddingSize(blockSize, macSize)))));
        return vectorList;
    }

    private int calculateValidPaddingSize(int blocksize, int macSize) {
        return blocksize - macSize % blocksize;
    }

    private int calculateInvalidPaddingSize(int blocksize, int macSize) {
        return blocksize - macSize % blocksize - 1;
    }
}

