/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.writer.TypeSection;
import com.android.tools.smali.dexlib2.writer.builder.BaseBuilderPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

class BuilderTypePool
extends BaseBuilderPool
implements TypeSection<BuilderStringReference, BuilderTypeReference, BuilderTypeReference> {
    private final ConcurrentMap<String, BuilderTypeReference> internedItems = Maps.newConcurrentMap();

    public BuilderTypePool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderTypeReference internType(String type) {
        BuilderTypeReference ret = (BuilderTypeReference)this.internedItems.get(type);
        if (ret != null) {
            return ret;
        }
        BuilderStringReference stringRef = ((BuilderStringPool)this.dexBuilder.stringSection).internString(type);
        BuilderTypeReference typeReference = new BuilderTypeReference(stringRef);
        ret = this.internedItems.putIfAbsent(type, typeReference);
        return ret == null ? typeReference : ret;
    }

    public BuilderTypeReference internNullableType(String type) {
        if (type == null) {
            return null;
        }
        return this.internType(type);
    }

    @Override
    public BuilderStringReference getString(BuilderTypeReference key) {
        return key.stringReference;
    }

    @Override
    public int getNullableItemIndex(BuilderTypeReference key) {
        return key == null ? -1 : key.index;
    }

    @Override
    public int getItemIndex(BuilderTypeReference key) {
        return key.getIndex();
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderTypeReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderTypeReference>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderTypeReference key) {
                return key.index;
            }

            @Override
            protected int setValue(BuilderTypeReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    @Override
    public int getItemCount() {
        return this.internedItems.size();
    }
}

