/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.cache.GlobalCache;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;

public class DefaultArtifactCacheMetadata
implements ArtifactCacheMetadata,
GlobalCache {
    public static final CacheVersion CACHE_LAYOUT_VERSION = CacheLayout.META_DATA.getVersion();
    private final File cacheDir;
    private final File transformsDir;
    private final File baseDir;

    public DefaultArtifactCacheMetadata(GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        this.baseDir = cacheBuilderFactory.getRootDir();
        this.cacheDir = cacheBuilderFactory.baseDirForCrossVersionCache(CacheLayout.ROOT.getKey());
        this.transformsDir = cacheBuilderFactory.baseDirForCrossVersionCache(CacheLayout.TRANSFORMS.getKey());
    }

    public DefaultArtifactCacheMetadata(GlobalScopedCacheBuilderFactory cacheBuilderFactory, File baseDir) {
        this(cacheBuilderFactory.createCacheBuilderFactory(baseDir));
    }

    @Override
    public File getCacheDir() {
        return this.cacheDir;
    }

    @Override
    public File getTransformsStoreDirectory() {
        return this.transformsDir;
    }

    @Override
    public File getFileStoreDirectory() {
        return this.createCacheRelativeDir(CacheLayout.FILE_STORE);
    }

    @Override
    public File getExternalResourcesStoreDirectory() {
        return this.createCacheRelativeDir(CacheLayout.RESOURCES);
    }

    @Override
    public File getMetaDataStoreDirectory() {
        return new File(this.createCacheRelativeDir(CacheLayout.META_DATA), "descriptors");
    }

    private File createCacheRelativeDir(CacheLayout cacheLayout) {
        return cacheLayout.getPath(this.getCacheDir());
    }

    public List<File> getGlobalCacheRoots() {
        return ImmutableList.of((Object)this.baseDir);
    }
}

